/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;

public class AutoOffsetResetStrategy {
    public static final AutoOffsetResetStrategy EARLIEST = new AutoOffsetResetStrategy(StrategyType.EARLIEST);
    public static final AutoOffsetResetStrategy LATEST = new AutoOffsetResetStrategy(StrategyType.LATEST);
    public static final AutoOffsetResetStrategy NONE = new AutoOffsetResetStrategy(StrategyType.NONE);
    private final StrategyType type;
    private final Optional<Duration> duration;

    private AutoOffsetResetStrategy(StrategyType type) {
        this.type = type;
        this.duration = Optional.empty();
    }

    private AutoOffsetResetStrategy(Duration duration) {
        this.type = StrategyType.BY_DURATION;
        this.duration = Optional.of(duration);
    }

    public static AutoOffsetResetStrategy fromString(String offsetStrategy) {
        if (offsetStrategy == null) {
            throw new IllegalArgumentException("Auto offset reset strategy is null");
        }
        if (StrategyType.BY_DURATION.toString().equals(offsetStrategy)) {
            throw new IllegalArgumentException("<:duration> part is missing in by_duration auto offset reset strategy.");
        }
        if (Arrays.asList(Utils.enumOptions(StrategyType.class)).contains(offsetStrategy)) {
            StrategyType type = StrategyType.valueOf(offsetStrategy.toUpperCase(Locale.ROOT));
            switch (type.ordinal()) {
                case 1: {
                    return EARLIEST;
                }
                case 0: {
                    return LATEST;
                }
                case 2: {
                    return NONE;
                }
            }
            throw new IllegalArgumentException("Unknown auto offset reset strategy: " + offsetStrategy);
        }
        if (offsetStrategy.startsWith(String.valueOf((Object)StrategyType.BY_DURATION) + ":")) {
            String isoDuration = offsetStrategy.substring(StrategyType.BY_DURATION.toString().length() + 1);
            try {
                Duration duration = Duration.parse(isoDuration);
                if (duration.isNegative()) {
                    throw new IllegalArgumentException("Negative duration is not supported in by_duration offset reset strategy.");
                }
                return new AutoOffsetResetStrategy(duration);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to parse duration string in by_duration offset reset strategy.", e);
            }
        }
        throw new IllegalArgumentException("Unknown auto offset reset strategy: " + offsetStrategy);
    }

    public StrategyType type() {
        return this.type;
    }

    public String name() {
        return this.type.toString();
    }

    public Optional<Long> timestamp() {
        if (this.type == StrategyType.EARLIEST) {
            return Optional.of(-2L);
        }
        if (this.type == StrategyType.LATEST) {
            return Optional.of(-1L);
        }
        if (this.type == StrategyType.BY_DURATION && this.duration.isPresent()) {
            Instant now = Instant.now();
            return Optional.of(now.minus(this.duration.get()).toEpochMilli());
        }
        return Optional.empty();
    }

    public Optional<Duration> duration() {
        return this.duration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoOffsetResetStrategy that = (AutoOffsetResetStrategy)o;
        return this.type == that.type && Objects.equals(this.duration, that.duration);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.duration});
    }

    public String toString() {
        return "AutoOffsetResetStrategy{type=" + String.valueOf((Object)this.type) + this.duration.map(value -> ", duration=" + String.valueOf(value)).orElse("") + "}";
    }

    public static enum StrategyType {
        LATEST,
        EARLIEST,
        NONE,
        BY_DURATION;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }

    public static class Validator
    implements ConfigDef.Validator {
        @Override
        public void ensureValid(String name, Object value) {
            String offsetStrategy = (String)value;
            try {
                AutoOffsetResetStrategy.fromString(offsetStrategy);
            }
            catch (Exception e) {
                throw new ConfigException(name, value, "Invalid value `" + offsetStrategy + "` for configuration " + name + ". The value must be either 'earliest', 'latest', 'none' or of the format 'by_duration:<PnDTnHnMn.nS.>'.");
            }
        }

        public String toString() {
            String values = Arrays.stream(StrategyType.values()).map(strategyType -> {
                if (strategyType == StrategyType.BY_DURATION) {
                    return "by_duration:PnDTnHnMn.nS";
                }
                return strategyType.toString();
            }).collect(Collectors.joining(", "));
            return "[" + values + "]";
        }
    }
}

