/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.publisher;

import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LoaderManifestType;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.fault.FaultHandler;
import org.slf4j.Logger;

public class AclPublisher
implements MetadataPublisher {
    private final Logger log;
    private final int nodeId;
    private final FaultHandler faultHandler;
    private final String nodeType;
    private final Optional<Plugin<Authorizer>> authorizer;
    private boolean completedInitialLoad = false;

    public AclPublisher(int nodeId, FaultHandler faultHandler, String nodeType, Optional<Plugin<Authorizer>> authorizer) {
        this.nodeId = nodeId;
        this.faultHandler = faultHandler;
        this.nodeType = nodeType;
        this.authorizer = authorizer.filter(plugin -> plugin.get() instanceof ClusterMetadataAuthorizer);
        this.log = new LogContext(this.name()).logger(AclPublisher.class);
    }

    @Override
    public final String name() {
        return "AclPublisher " + this.nodeType + " id=" + this.nodeId;
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        String deltaName = "MetadataDelta up to " + newImage.offset();
        Optional.ofNullable(delta.aclsDelta()).ifPresent(aclsDelta -> this.authorizer.ifPresent(authorizer -> {
            ClusterMetadataAuthorizer clusterMetadataAuthorizer = (ClusterMetadataAuthorizer)authorizer.get();
            if (manifest.type().equals((Object)LoaderManifestType.SNAPSHOT)) {
                try {
                    this.log.info("Loading authorizer snapshot at offset {}", (Object)newImage.offset());
                    clusterMetadataAuthorizer.loadSnapshot(newImage.acls().acls());
                }
                catch (Throwable t) {
                    this.faultHandler.handleFault("Error loading authorizer snapshot in " + deltaName, t);
                }
            } else {
                try {
                    aclsDelta.changes().forEach((key, value) -> {
                        if (value.isPresent()) {
                            clusterMetadataAuthorizer.addAcl((Uuid)key, (StandardAcl)value.get());
                        } else {
                            clusterMetadataAuthorizer.removeAcl((Uuid)key);
                        }
                    });
                }
                catch (Throwable t) {
                    this.faultHandler.handleFault("Error loading authorizer changes in " + deltaName, t);
                }
            }
            if (!this.completedInitialLoad) {
                this.completedInitialLoad = true;
                clusterMetadataAuthorizer.completeInitialLoad();
            }
        }));
    }

    @Override
    public void close() {
        this.authorizer.ifPresent(authorizer -> {
            ClusterMetadataAuthorizer clusterMetadataAuthorizer = (ClusterMetadataAuthorizer)authorizer.get();
            clusterMetadataAuthorizer.completeInitialLoad(new TimeoutException());
        });
    }
}

