/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.raft.ReplicaKey;
import org.apache.kafka.raft.generated.QuorumStateData;

public final class ElectionState {
    private static final int UNKNOWN_LEADER_ID = -1;
    private static final int NOT_VOTED = -1;
    private final int epoch;
    private final OptionalInt leaderId;
    private final Optional<ReplicaKey> votedKey;
    private final Set<Integer> voters;

    ElectionState(int epoch, OptionalInt leaderId, Optional<ReplicaKey> votedKey, Set<Integer> voters) {
        this.epoch = epoch;
        this.leaderId = leaderId;
        this.votedKey = votedKey;
        this.voters = voters;
    }

    public int epoch() {
        return this.epoch;
    }

    public boolean isLeader(int nodeId) {
        if (nodeId < 0) {
            throw new IllegalArgumentException("Invalid negative nodeId: " + nodeId);
        }
        return this.leaderIdOrSentinel() == nodeId;
    }

    public boolean isVotedCandidate(ReplicaKey nodeKey) {
        if (nodeKey.id() < 0) {
            throw new IllegalArgumentException("Invalid node key " + String.valueOf(nodeKey));
        }
        if (this.votedKey.isEmpty()) {
            return false;
        }
        if (this.votedKey.get().id() != nodeKey.id()) {
            return false;
        }
        if (this.votedKey.get().directoryId().isEmpty()) {
            return true;
        }
        return this.votedKey.get().directoryId().equals(nodeKey.directoryId());
    }

    public int leaderId() {
        if (this.leaderId.isEmpty()) {
            throw new IllegalStateException("Attempt to access nil leaderId");
        }
        return this.leaderId.getAsInt();
    }

    public int leaderIdOrSentinel() {
        return this.leaderId.orElse(-1);
    }

    public OptionalInt optionalLeaderId() {
        return this.leaderId;
    }

    public ReplicaKey votedKey() {
        if (this.votedKey.isEmpty()) {
            throw new IllegalStateException("Attempt to access nil votedId");
        }
        return this.votedKey.get();
    }

    public Optional<ReplicaKey> optionalVotedKey() {
        return this.votedKey;
    }

    public boolean hasLeader() {
        return this.leaderId.isPresent();
    }

    public boolean hasVoted() {
        return this.votedKey.isPresent();
    }

    public QuorumStateData toQuorumStateData(short version) {
        QuorumStateData data = new QuorumStateData().setLeaderEpoch(this.epoch).setLeaderId(this.leaderIdOrSentinel()).setVotedId(this.votedKey.map(ReplicaKey::id).orElse(-1));
        if (version == 0) {
            List<QuorumStateData.Voter> dataVoters = this.voters.stream().map(voterId -> new QuorumStateData.Voter().setVoterId((int)voterId)).collect(Collectors.toList());
            data.setCurrentVoters(dataVoters);
        } else if (version == 1) {
            data.setVotedDirectoryId(this.votedKey.flatMap(ReplicaKey::directoryId).orElse(ReplicaKey.NO_DIRECTORY_ID));
        } else {
            throw new IllegalStateException(String.format("File quorum state store doesn't handle supported version %d", version));
        }
        return data;
    }

    public String toString() {
        return String.format("Election(epoch=%d, leaderId=%s, votedKey=%s, voters=%s)", this.epoch, this.leaderId, this.votedKey, this.voters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElectionState that = (ElectionState)o;
        if (this.epoch != that.epoch) {
            return false;
        }
        if (!this.leaderId.equals(that.leaderId)) {
            return false;
        }
        if (!this.votedKey.equals(that.votedKey)) {
            return false;
        }
        return this.voters.equals(that.voters);
    }

    public int hashCode() {
        return Objects.hash(this.epoch, this.leaderId, this.votedKey, this.voters);
    }

    public static ElectionState withVotedCandidate(int epoch, ReplicaKey votedKey, Set<Integer> voters) {
        if (votedKey.id() < 0) {
            throw new IllegalArgumentException("Illegal voted Id " + votedKey.id() + ": must be non-negative");
        }
        return new ElectionState(epoch, OptionalInt.empty(), Optional.of(votedKey), voters);
    }

    public static ElectionState withElectedLeader(int epoch, int leaderId, Optional<ReplicaKey> votedKey, Set<Integer> voters) {
        if (leaderId < 0) {
            throw new IllegalArgumentException("Illegal leader Id " + leaderId + ": must be non-negative");
        }
        return new ElectionState(epoch, OptionalInt.of(leaderId), votedKey, voters);
    }

    public static ElectionState withUnknownLeader(int epoch, Set<Integer> voters) {
        return new ElectionState(epoch, OptionalInt.empty(), Optional.empty(), voters);
    }

    public static ElectionState fromQuorumStateData(QuorumStateData data) {
        Optional<ReplicaKey> votedKey = data.votedId() == -1 ? Optional.empty() : Optional.of(ReplicaKey.of(data.votedId(), data.votedDirectoryId()));
        return new ElectionState(data.leaderEpoch(), data.leaderId() == -1 ? OptionalInt.empty() : OptionalInt.of(data.leaderId()), votedKey, data.currentVoters().stream().map(QuorumStateData.Voter::voterId).collect(Collectors.toSet()));
    }
}

