/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.StreamsGroupHeartbeatRequestData;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTargetAssignmentMemberValue;

public record TasksTuple(Map<String, Set<Integer>> activeTasks, Map<String, Set<Integer>> standbyTasks, Map<String, Set<Integer>> warmupTasks) {
    public static final TasksTuple EMPTY = new TasksTuple(Map.of(), Map.of(), Map.of());

    public TasksTuple {
        activeTasks = Collections.unmodifiableMap(Objects.requireNonNull(activeTasks));
        standbyTasks = Collections.unmodifiableMap(Objects.requireNonNull(standbyTasks));
        warmupTasks = Collections.unmodifiableMap(Objects.requireNonNull(warmupTasks));
    }

    public boolean isEmpty() {
        return this.activeTasks.isEmpty() && this.standbyTasks.isEmpty() && this.warmupTasks.isEmpty();
    }

    public TasksTuple merge(TasksTuple other) {
        Map<String, Set<Integer>> mergedActiveTasks = TasksTuple.merge(this.activeTasks, other.activeTasks);
        Map<String, Set<Integer>> mergedStandbyTasks = TasksTuple.merge(this.standbyTasks, other.standbyTasks);
        Map<String, Set<Integer>> mergedWarmupTasks = TasksTuple.merge(this.warmupTasks, other.warmupTasks);
        return new TasksTuple(mergedActiveTasks, mergedStandbyTasks, mergedWarmupTasks);
    }

    private static Map<String, Set<Integer>> merge(Map<String, Set<Integer>> tasks1, Map<String, Set<Integer>> tasks2) {
        HashMap<String, Set<Integer>> result = new HashMap<String, Set<Integer>>();
        tasks1.forEach((subtopologyId, tasks) -> result.put((String)subtopologyId, new HashSet(tasks)));
        tasks2.forEach((subtopologyId, tasks) -> result.computeIfAbsent((String)subtopologyId, __ -> new HashSet()).addAll(tasks));
        return result;
    }

    public boolean containsAny(TasksTuple other) {
        return this.activeTasks.entrySet().stream().anyMatch(entry -> other.activeTasks.containsKey(entry.getKey()) && !Collections.disjoint((Collection)entry.getValue(), (Collection)other.activeTasks.get(entry.getKey()))) || this.standbyTasks.entrySet().stream().anyMatch(entry -> other.standbyTasks.containsKey(entry.getKey()) && !Collections.disjoint((Collection)entry.getValue(), (Collection)other.standbyTasks.get(entry.getKey()))) || this.warmupTasks.entrySet().stream().anyMatch(entry -> other.warmupTasks.containsKey(entry.getKey()) && !Collections.disjoint((Collection)entry.getValue(), (Collection)other.warmupTasks.get(entry.getKey())));
    }

    public static TasksTuple fromTargetAssignmentRecord(StreamsGroupTargetAssignmentMemberValue record) {
        return new TasksTuple(record.activeTasks().stream().collect(Collectors.toMap(StreamsGroupTargetAssignmentMemberValue.TaskIds::subtopologyId, taskId -> new HashSet<Integer>(taskId.partitions()))), record.standbyTasks().stream().collect(Collectors.toMap(StreamsGroupTargetAssignmentMemberValue.TaskIds::subtopologyId, taskId -> new HashSet<Integer>(taskId.partitions()))), record.warmupTasks().stream().collect(Collectors.toMap(StreamsGroupTargetAssignmentMemberValue.TaskIds::subtopologyId, taskId -> new HashSet<Integer>(taskId.partitions()))));
    }

    @Override
    public String toString() {
        return "(active=" + TasksTuple.taskAssignmentToString(this.activeTasks) + ", standby=" + TasksTuple.taskAssignmentToString(this.standbyTasks) + ", warmup=" + TasksTuple.taskAssignmentToString(this.warmupTasks) + ")";
    }

    public static TasksTuple fromHeartbeatRequest(List<StreamsGroupHeartbeatRequestData.TaskIds> ownedActiveTasks, List<StreamsGroupHeartbeatRequestData.TaskIds> ownedStandbyTasks, List<StreamsGroupHeartbeatRequestData.TaskIds> ownedWarmupTasks) {
        return new TasksTuple(ownedActiveTasks.stream().collect(Collectors.toMap(StreamsGroupHeartbeatRequestData.TaskIds::subtopologyId, taskId -> new HashSet(taskId.partitions()))), ownedStandbyTasks.stream().collect(Collectors.toMap(StreamsGroupHeartbeatRequestData.TaskIds::subtopologyId, taskId -> new HashSet(taskId.partitions()))), ownedWarmupTasks.stream().collect(Collectors.toMap(StreamsGroupHeartbeatRequestData.TaskIds::subtopologyId, taskId -> new HashSet(taskId.partitions()))));
    }

    private static String taskAssignmentToString(Map<String, Set<Integer>> assignment) {
        StringBuilder builder = new StringBuilder("[");
        Iterator<Map.Entry<String, Set<Integer>>> subtopologyIterator = assignment.entrySet().iterator();
        while (subtopologyIterator.hasNext()) {
            Map.Entry<String, Set<Integer>> entry = subtopologyIterator.next();
            Iterator<Integer> partitionsIterator = entry.getValue().iterator();
            while (partitionsIterator.hasNext()) {
                builder.append(entry.getKey());
                builder.append("-");
                builder.append(partitionsIterator.next());
                if (!partitionsIterator.hasNext() && !subtopologyIterator.hasNext()) continue;
                builder.append(", ");
            }
        }
        builder.append("]");
        return builder.toString();
    }
}

