/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.IntSupplier;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AlterShareGroupOffsetsRequestData;
import org.apache.kafka.common.message.AlterShareGroupOffsetsResponseData;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DeleteShareGroupOffsetsRequestData;
import org.apache.kafka.common.message.DeleteShareGroupOffsetsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.DescribeShareGroupOffsetsRequestData;
import org.apache.kafka.common.message.DescribeShareGroupOffsetsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.common.message.ShareGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.message.StreamsGroupDescribeResponseData;
import org.apache.kafka.common.message.StreamsGroupHeartbeatRequestData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.coordinator.group.GroupConfig;
import org.apache.kafka.coordinator.group.streams.StreamsGroupHeartbeatResult;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;

public interface GroupCoordinator {
    public CompletableFuture<ConsumerGroupHeartbeatResponseData> consumerGroupHeartbeat(AuthorizableRequestContext var1, ConsumerGroupHeartbeatRequestData var2);

    public CompletableFuture<StreamsGroupHeartbeatResult> streamsGroupHeartbeat(AuthorizableRequestContext var1, StreamsGroupHeartbeatRequestData var2);

    public CompletableFuture<ShareGroupHeartbeatResponseData> shareGroupHeartbeat(AuthorizableRequestContext var1, ShareGroupHeartbeatRequestData var2);

    public CompletableFuture<JoinGroupResponseData> joinGroup(AuthorizableRequestContext var1, JoinGroupRequestData var2, BufferSupplier var3);

    public CompletableFuture<SyncGroupResponseData> syncGroup(AuthorizableRequestContext var1, SyncGroupRequestData var2, BufferSupplier var3);

    public CompletableFuture<HeartbeatResponseData> heartbeat(AuthorizableRequestContext var1, HeartbeatRequestData var2);

    public CompletableFuture<LeaveGroupResponseData> leaveGroup(AuthorizableRequestContext var1, LeaveGroupRequestData var2);

    public CompletableFuture<ListGroupsResponseData> listGroups(AuthorizableRequestContext var1, ListGroupsRequestData var2);

    public CompletableFuture<List<DescribeGroupsResponseData.DescribedGroup>> describeGroups(AuthorizableRequestContext var1, List<String> var2);

    public CompletableFuture<List<ConsumerGroupDescribeResponseData.DescribedGroup>> consumerGroupDescribe(AuthorizableRequestContext var1, List<String> var2);

    public CompletableFuture<List<StreamsGroupDescribeResponseData.DescribedGroup>> streamsGroupDescribe(AuthorizableRequestContext var1, List<String> var2);

    public CompletableFuture<List<ShareGroupDescribeResponseData.DescribedGroup>> shareGroupDescribe(AuthorizableRequestContext var1, List<String> var2);

    public CompletableFuture<AlterShareGroupOffsetsResponseData> alterShareGroupOffsets(AuthorizableRequestContext var1, String var2, AlterShareGroupOffsetsRequestData var3);

    public CompletableFuture<DeleteGroupsResponseData.DeletableGroupResultCollection> deleteGroups(AuthorizableRequestContext var1, List<String> var2, BufferSupplier var3);

    public CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchOffsets(AuthorizableRequestContext var1, OffsetFetchRequestData.OffsetFetchRequestGroup var2, boolean var3);

    public CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchAllOffsets(AuthorizableRequestContext var1, OffsetFetchRequestData.OffsetFetchRequestGroup var2, boolean var3);

    public CompletableFuture<DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseGroup> describeShareGroupOffsets(AuthorizableRequestContext var1, DescribeShareGroupOffsetsRequestData.DescribeShareGroupOffsetsRequestGroup var2);

    public CompletableFuture<DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseGroup> describeShareGroupAllOffsets(AuthorizableRequestContext var1, DescribeShareGroupOffsetsRequestData.DescribeShareGroupOffsetsRequestGroup var2);

    public CompletableFuture<DeleteShareGroupOffsetsResponseData> deleteShareGroupOffsets(AuthorizableRequestContext var1, DeleteShareGroupOffsetsRequestData var2);

    public CompletableFuture<OffsetCommitResponseData> commitOffsets(AuthorizableRequestContext var1, OffsetCommitRequestData var2, BufferSupplier var3);

    public CompletableFuture<TxnOffsetCommitResponseData> commitTransactionalOffsets(AuthorizableRequestContext var1, TxnOffsetCommitRequestData var2, BufferSupplier var3);

    public CompletableFuture<OffsetDeleteResponseData> deleteOffsets(AuthorizableRequestContext var1, OffsetDeleteRequestData var2, BufferSupplier var3);

    public CompletableFuture<Void> completeTransaction(TopicPartition var1, long var2, short var4, int var5, TransactionResult var6, Duration var7);

    public int partitionFor(String var1);

    public void onPartitionsDeleted(List<TopicPartition> var1, BufferSupplier var2) throws ExecutionException, InterruptedException;

    public void onElection(int var1, int var2);

    public void onResignation(int var1, OptionalInt var2);

    public void onNewMetadataImage(MetadataImage var1, MetadataDelta var2);

    public Properties groupMetadataTopicConfigs();

    public Optional<GroupConfig> groupConfig(String var1);

    public void updateGroupConfig(String var1, Properties var2);

    public void startup(IntSupplier var1);

    public void shutdown();
}

