/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.coordinator.group.GroupConfig;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupConfig;

public class GroupConfigManager
implements AutoCloseable {
    private final GroupConfig defaultConfig;
    private final Map<String, GroupConfig> configMap = new ConcurrentHashMap<String, GroupConfig>();

    public GroupConfigManager(Map<?, ?> defaultConfig) {
        this.defaultConfig = new GroupConfig(defaultConfig);
    }

    public void updateGroupConfig(String groupId, Properties newGroupConfig) {
        if (null == groupId || groupId.isEmpty()) {
            throw new InvalidRequestException("Group name can't be empty.");
        }
        GroupConfig newConfig = GroupConfig.fromProps(this.defaultConfig.originals(), newGroupConfig);
        this.configMap.put(groupId, newConfig);
    }

    public Optional<GroupConfig> groupConfig(String groupId) {
        return Optional.ofNullable(this.configMap.get(groupId));
    }

    public List<String> groupIds() {
        return List.copyOf(this.configMap.keySet());
    }

    public static void validate(Properties newGroupConfig, GroupCoordinatorConfig groupCoordinatorConfig, ShareGroupConfig shareGroupConfig) {
        Properties combinedConfigs = new Properties();
        combinedConfigs.putAll(groupCoordinatorConfig.extractConsumerGroupConfigMap());
        combinedConfigs.putAll((Map<?, ?>)newGroupConfig);
        GroupConfig.validate(combinedConfigs, groupCoordinatorConfig, shareGroupConfig);
    }

    @Override
    public void close() {
        this.configMap.clear();
    }
}

