/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public final class TranslatedValueMapView<K, V, B>
extends AbstractMap<K, V> {
    private final Map<K, B> underlyingMap;
    private final Function<B, V> valueMapping;
    private final TranslatedValueSetView set;

    public TranslatedValueMapView(Map<K, B> underlyingMap, Function<B, V> valueMapping) {
        this.underlyingMap = underlyingMap;
        this.valueMapping = valueMapping;
        this.set = new TranslatedValueSetView();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.underlyingMap.containsKey(key);
    }

    @Override
    public V get(Object key) {
        if (!this.underlyingMap.containsKey(key)) {
            return null;
        }
        B value = this.underlyingMap.get(key);
        return this.valueMapping.apply(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.set;
    }

    @Override
    public boolean isEmpty() {
        return this.underlyingMap.isEmpty();
    }

    class TranslatedValueSetView
    extends AbstractSet<Map.Entry<K, V>> {
        TranslatedValueSetView() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new TranslatedValueEntryIterator(TranslatedValueMapView.this.underlyingMap.entrySet().iterator());
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)o;
            if (!TranslatedValueMapView.this.underlyingMap.containsKey(other.getKey())) {
                return false;
            }
            Object value = TranslatedValueMapView.this.underlyingMap.get(other.getKey());
            Object translatedValue = TranslatedValueMapView.this.valueMapping.apply(value);
            return Objects.equals(translatedValue, other.getValue());
        }

        @Override
        public boolean isEmpty() {
            return TranslatedValueMapView.this.underlyingMap.isEmpty();
        }

        @Override
        public int size() {
            return TranslatedValueMapView.this.underlyingMap.size();
        }
    }

    class TranslatedValueEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, B>> underlyingIterator;

        TranslatedValueEntryIterator(Iterator<Map.Entry<K, B>> underlyingIterator) {
            this.underlyingIterator = underlyingIterator;
        }

        @Override
        public boolean hasNext() {
            return this.underlyingIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry underlyingEntry = this.underlyingIterator.next();
            return new AbstractMap.SimpleImmutableEntry(underlyingEntry.getKey(), TranslatedValueMapView.this.valueMapping.apply(underlyingEntry.getValue()));
        }
    }
}

