/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

public class ThroughputThrottler {
    private static final long NS_PER_MS = 1000000L;
    private static final long NS_PER_SEC = 1000000000L;
    private static final long MIN_SLEEP_NS = 2000000L;
    private final long startMs;
    private final long sleepTimeNs;
    private final double targetThroughput;
    private long sleepDeficitNs = 0L;
    private boolean wakeup = false;

    public ThroughputThrottler(double targetThroughput, long startMs) {
        this.startMs = startMs;
        this.targetThroughput = targetThroughput;
        this.sleepTimeNs = targetThroughput > 0.0 ? (long)(1.0E9 / targetThroughput) : Long.MAX_VALUE;
    }

    public boolean shouldThrottle(long amountSoFar, long sendStartMs) {
        if (this.targetThroughput < 0.0) {
            return false;
        }
        float elapsedSec = (float)(sendStartMs - this.startMs) / 1000.0f;
        return elapsedSec > 0.0f && (double)amountSoFar / (double)elapsedSec > this.targetThroughput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throttle() {
        block15: {
            if (this.targetThroughput == 0.0) {
                try {
                    ThroughputThrottler throughputThrottler = this;
                    synchronized (throughputThrottler) {
                        while (!this.wakeup) {
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return;
            }
            this.sleepDeficitNs += this.sleepTimeNs;
            if (this.sleepDeficitNs >= 2000000L) {
                long sleepStartNs = System.nanoTime();
                try {
                    ThroughputThrottler throughputThrottler = this;
                    synchronized (throughputThrottler) {
                        long remaining = this.sleepDeficitNs;
                        while (!this.wakeup && remaining > 0L) {
                            long sleepMs = remaining / 1000000L;
                            long sleepNs = remaining - sleepMs * 1000000L;
                            this.wait(sleepMs, (int)sleepNs);
                            long elapsed = System.nanoTime() - sleepStartNs;
                            remaining = this.sleepDeficitNs - elapsed;
                        }
                        this.wakeup = false;
                    }
                    this.sleepDeficitNs = 0L;
                }
                catch (InterruptedException e) {
                    long sleepElapsedNs = System.nanoTime() - sleepStartNs;
                    if (sleepElapsedNs > this.sleepDeficitNs) break block15;
                    this.sleepDeficitNs -= sleepElapsedNs;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        ThroughputThrottler throughputThrottler = this;
        synchronized (throughputThrottler) {
            this.wakeup = true;
            this.notifyAll();
        }
    }
}

