/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushHttpMetricsReporter
implements MetricsReporter {
    private static final Logger log = LoggerFactory.getLogger(PushHttpMetricsReporter.class);
    private static final String METRICS_PREFIX = "metrics.";
    static final String METRICS_URL_CONFIG = "metrics.url";
    static final String METRICS_PERIOD_CONFIG = "metrics.period";
    static final String METRICS_HOST_CONFIG = "metrics.host";
    static final String CLIENT_ID_CONFIG = "client.id";
    private static final Map<String, String> HEADERS = new LinkedHashMap<String, String>();
    private final Object lock = new Object();
    private final Supplier<Long> currentTimeMillis;
    private final ScheduledExecutorService executor;
    private final Map<MetricName, KafkaMetric> metrics = new LinkedHashMap<MetricName, KafkaMetric>();
    private final ObjectMapper json = new ObjectMapper();
    private URL url;
    private String host;
    private String clientId;
    private static final ConfigDef CONFIG_DEF;

    public PushHttpMetricsReporter() {
        this.currentTimeMillis = System::currentTimeMillis;
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    PushHttpMetricsReporter(Time mockTime, ScheduledExecutorService mockExecutor) {
        this.currentTimeMillis = () -> ((Time)mockTime).milliseconds();
        this.executor = mockExecutor;
    }

    public void configure(Map<String, ?> configs) {
        PushHttpMetricsReporterConfig config = new PushHttpMetricsReporterConfig(CONFIG_DEF, configs);
        try {
            this.url = new URL(config.getString(METRICS_URL_CONFIG));
        }
        catch (MalformedURLException e) {
            throw new ConfigException("Malformed metrics.url", (Object)e);
        }
        int period = config.getInteger(METRICS_PERIOD_CONFIG);
        this.clientId = config.getString(CLIENT_ID_CONFIG);
        this.host = config.getString(METRICS_HOST_CONFIG);
        if (this.host == null || this.host.isEmpty()) {
            try {
                this.host = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                throw new ConfigException("Failed to get canonical hostname", (Object)e);
            }
        }
        this.executor.scheduleAtFixedRate(new HttpReporter(), period, period, TimeUnit.SECONDS);
        log.info("Configured PushHttpMetricsReporter for {} to report every {} seconds", (Object)this.url, (Object)period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(List<KafkaMetric> initMetrics) {
        Object object = this.lock;
        synchronized (object) {
            for (KafkaMetric metric : initMetrics) {
                log.debug("Adding metric {}", (Object)metric.metricName());
                this.metrics.put(metric.metricName(), metric);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metricChange(KafkaMetric metric) {
        Object object = this.lock;
        synchronized (object) {
            log.debug("Updating metric {}", (Object)metric.metricName());
            this.metrics.put(metric.metricName(), metric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metricRemoval(KafkaMetric metric) {
        Object object = this.lock;
        synchronized (object) {
            log.debug("Removing metric {}", (Object)metric.metricName());
            this.metrics.remove(metric.metricName());
        }
    }

    public void close() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new KafkaException("Interrupted when shutting down PushHttpMetricsReporter", (Throwable)e);
        }
    }

    static HttpURLConnection newHttpConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    static String readResponse(InputStream is) {
        try (Scanner s = new Scanner(is, StandardCharsets.UTF_8).useDelimiter("\\A");){
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }

    static {
        HEADERS.put("Content-Type", "application/json");
        CONFIG_DEF = new ConfigDef().define(METRICS_URL_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "The URL to report metrics to").define(METRICS_PERIOD_CONFIG, ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "The frequency at which metrics should be reported, in second").define(METRICS_HOST_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "The hostname to report with each metric; if empty, defaults to the FQDN that can be automaticallydetermined").define(CLIENT_ID_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "Client ID to identify the application, generally inherited from the producer/consumer/streams/connect instance");
    }

    private static class PushHttpMetricsReporterConfig
    extends AbstractConfig {
        public PushHttpMetricsReporterConfig(ConfigDef definition, Map<?, ?> originals) {
            super(definition, originals);
        }

        public Integer getInteger(String key) {
            return (Integer)this.get(key);
        }
    }

    private class HttpReporter
    implements Runnable {
        private HttpReporter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<MetricValue> samples;
            long now = PushHttpMetricsReporter.this.currentTimeMillis.get();
            Object object = PushHttpMetricsReporter.this.lock;
            synchronized (object) {
                samples = new ArrayList<MetricValue>(PushHttpMetricsReporter.this.metrics.size());
                for (KafkaMetric metric : PushHttpMetricsReporter.this.metrics.values()) {
                    MetricName name = metric.metricName();
                    samples.add(new MetricValue(name.name(), name.group(), name.tags(), metric.metricValue()));
                }
            }
            MetricsReport report = new MetricsReport(new MetricClientInfo(PushHttpMetricsReporter.this.host, PushHttpMetricsReporter.this.clientId, now), samples);
            log.trace("Reporting {} metrics to {}", (Object)samples.size(), (Object)PushHttpMetricsReporter.this.url);
            HttpURLConnection connection = null;
            try {
                connection = PushHttpMetricsReporter.newHttpConnection(PushHttpMetricsReporter.this.url);
                connection.setRequestMethod("POST");
                connection.setDoInput(true);
                connection.setRequestProperty("Content-Type", "application/json");
                byte[] data = PushHttpMetricsReporter.this.json.writeValueAsBytes((Object)report);
                connection.setRequestProperty("Content-Length", Integer.toString(data.length));
                connection.setRequestProperty("Accept", "*/*");
                connection.setUseCaches(false);
                connection.setDoOutput(true);
                try (OutputStream os = connection.getOutputStream();){
                    os.write(data);
                    os.flush();
                }
                int responseCode = connection.getResponseCode();
                if (responseCode >= 400) {
                    InputStream is = connection.getErrorStream();
                    String msg = PushHttpMetricsReporter.readResponse(is);
                    log.error("Error reporting metrics, {}: {}", (Object)responseCode, (Object)msg);
                } else if (responseCode >= 300) {
                    log.error("PushHttpMetricsReporter does not currently support redirects, saw {}", (Object)responseCode);
                } else {
                    log.info("Finished reporting metrics with response code {}", (Object)responseCode);
                }
            }
            catch (Throwable t) {
                log.error("Error reporting metrics", t);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
    }

    private static class MetricValue {
        private final String name;
        private final String group;
        private final Map<String, String> tags;
        private final Object value;

        MetricValue(String name, String group, Map<String, String> tags, Object value) {
            this.name = name;
            this.group = group;
            this.tags = tags;
            this.value = value;
        }

        @JsonProperty
        public String name() {
            return this.name;
        }

        @JsonProperty
        public String group() {
            return this.group;
        }

        @JsonProperty
        public Map<String, String> tags() {
            return this.tags;
        }

        @JsonProperty
        public Object value() {
            return this.value;
        }
    }

    private static class MetricClientInfo {
        private final String host;
        private final String clientId;
        private final long time;

        MetricClientInfo(String host, String clientId, long time) {
            this.host = host;
            this.clientId = clientId;
            this.time = time;
        }

        @JsonProperty
        public String host() {
            return this.host;
        }

        @JsonProperty(value="client_id")
        public String clientId() {
            return this.clientId;
        }

        @JsonProperty
        public long time() {
            return this.time;
        }
    }

    private static class MetricsReport {
        private final MetricClientInfo client;
        private final Collection<MetricValue> metrics;

        MetricsReport(MetricClientInfo client, Collection<MetricValue> metrics) {
            this.client = client;
            this.metrics = metrics;
        }

        @JsonProperty
        public MetricClientInfo client() {
            return this.client;
        }

        @JsonProperty
        public Collection<MetricValue> metrics() {
            return this.metrics;
        }
    }
}

