/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Optional;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ControllerMutationQuotaManager;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.apache.kafka.server.config.ReplicationQuotaManagerConfig;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.QuotaType;
import scala.Option;
import scala.jdk.javaapi.OptionConverters;

public class QuotaFactory {
    public static final ReplicaQuota UNBOUNDED_QUOTA = new ReplicaQuota(){

        @Override
        public boolean isThrottled(TopicPartition topicPartition) {
            return false;
        }

        @Override
        public boolean isQuotaExceeded() {
            return false;
        }

        @Override
        public void record(long value) {
        }
    };

    public static QuotaManagers instantiate(KafkaConfig cfg, Metrics metrics, Time time, String threadNamePrefix, String role) {
        Optional<Plugin<ClientQuotaCallback>> clientQuotaCallbackPlugin = QuotaFactory.createClientQuotaCallback(cfg, metrics, role);
        Option clientQuotaCallbackPluginOption = OptionConverters.toScala(clientQuotaCallbackPlugin);
        return new QuotaManagers(new ClientQuotaManager(QuotaFactory.clientConfig(cfg), metrics, QuotaType.FETCH, time, threadNamePrefix, (Option<Plugin<ClientQuotaCallback>>)clientQuotaCallbackPluginOption), new ClientQuotaManager(QuotaFactory.clientConfig(cfg), metrics, QuotaType.PRODUCE, time, threadNamePrefix, (Option<Plugin<ClientQuotaCallback>>)clientQuotaCallbackPluginOption), new ClientRequestQuotaManager(QuotaFactory.clientConfig(cfg), metrics, time, threadNamePrefix, clientQuotaCallbackPlugin), new ControllerMutationQuotaManager(QuotaFactory.clientControllerMutationConfig(cfg), metrics, time, threadNamePrefix, (Option<Plugin<ClientQuotaCallback>>)clientQuotaCallbackPluginOption), new ReplicationQuotaManager(QuotaFactory.replicationConfig(cfg), metrics, QuotaType.LEADER_REPLICATION, time), new ReplicationQuotaManager(QuotaFactory.replicationConfig(cfg), metrics, QuotaType.FOLLOWER_REPLICATION, time), new ReplicationQuotaManager(QuotaFactory.alterLogDirsReplicationConfig(cfg), metrics, QuotaType.ALTER_LOG_DIRS_REPLICATION, time), clientQuotaCallbackPlugin);
    }

    private static Optional<Plugin<ClientQuotaCallback>> createClientQuotaCallback(KafkaConfig cfg, Metrics metrics, String role) {
        ClientQuotaCallback clientQuotaCallback = (ClientQuotaCallback)cfg.getConfiguredInstance("client.quota.callback.class", ClientQuotaCallback.class);
        return clientQuotaCallback == null ? Optional.empty() : Optional.of(Plugin.wrapInstance((Object)clientQuotaCallback, (Metrics)metrics, (String)"client.quota.callback.class", (String)"role", (String)role));
    }

    private static ClientQuotaManagerConfig clientConfig(KafkaConfig cfg) {
        return new ClientQuotaManagerConfig(cfg.quotaConfig().numQuotaSamples(), cfg.quotaConfig().quotaWindowSizeSeconds());
    }

    private static ClientQuotaManagerConfig clientControllerMutationConfig(KafkaConfig cfg) {
        return new ClientQuotaManagerConfig(cfg.quotaConfig().numControllerQuotaSamples(), cfg.quotaConfig().controllerQuotaWindowSizeSeconds());
    }

    private static ReplicationQuotaManagerConfig replicationConfig(KafkaConfig cfg) {
        return new ReplicationQuotaManagerConfig(cfg.quotaConfig().numReplicationQuotaSamples(), cfg.quotaConfig().replicationQuotaWindowSizeSeconds());
    }

    private static ReplicationQuotaManagerConfig alterLogDirsReplicationConfig(KafkaConfig cfg) {
        return new ReplicationQuotaManagerConfig(cfg.quotaConfig().numAlterLogDirsReplicationQuotaSamples(), cfg.quotaConfig().alterLogDirsReplicationQuotaWindowSizeSeconds());
    }

    public static class QuotaManagers {
        private final ClientQuotaManager fetch;
        private final ClientQuotaManager produce;
        private final ClientRequestQuotaManager request;
        private final ControllerMutationQuotaManager controllerMutation;
        private final ReplicationQuotaManager leader;
        private final ReplicationQuotaManager follower;
        private final ReplicationQuotaManager alterLogDirs;
        private final Optional<Plugin<ClientQuotaCallback>> clientQuotaCallbackPlugin;

        public QuotaManagers(ClientQuotaManager fetch, ClientQuotaManager produce, ClientRequestQuotaManager request, ControllerMutationQuotaManager controllerMutation, ReplicationQuotaManager leader, ReplicationQuotaManager follower, ReplicationQuotaManager alterLogDirs, Optional<Plugin<ClientQuotaCallback>> clientQuotaCallbackPlugin) {
            this.fetch = fetch;
            this.produce = produce;
            this.request = request;
            this.controllerMutation = controllerMutation;
            this.leader = leader;
            this.follower = follower;
            this.alterLogDirs = alterLogDirs;
            this.clientQuotaCallbackPlugin = clientQuotaCallbackPlugin;
        }

        public ClientQuotaManager fetch() {
            return this.fetch;
        }

        public ClientQuotaManager produce() {
            return this.produce;
        }

        public ClientRequestQuotaManager request() {
            return this.request;
        }

        public ControllerMutationQuotaManager controllerMutation() {
            return this.controllerMutation;
        }

        public ReplicationQuotaManager leader() {
            return this.leader;
        }

        public ReplicationQuotaManager follower() {
            return this.follower;
        }

        public ReplicationQuotaManager alterLogDirs() {
            return this.alterLogDirs;
        }

        public Optional<Plugin<ClientQuotaCallback>> clientQuotaCallbackPlugin() {
            return this.clientQuotaCallbackPlugin;
        }

        public void shutdown() {
            this.fetch.shutdown();
            this.produce.shutdown();
            this.request.shutdown();
            this.controllerMutation.shutdown();
            this.clientQuotaCallbackPlugin.ifPresent(plugin -> Utils.closeQuietly((AutoCloseable)plugin, (String)"client quota callback plugin"));
        }
    }
}

