/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.Acceptor;
import kafka.network.ConnectionQuotas;
import kafka.network.DataPlaneAcceptor;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.memory.SimpleMemoryPool;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.security.CredentialProvider;
import org.apache.kafka.server.ApiVersionManager;
import org.apache.kafka.server.ServerSocketFactory;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.network.ConnectionDisconnectListener;
import org.apache.kafka.server.util.FutureUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r}b\u0001B$I\u00015C\u0001\u0002\u0019\u0001\u0003\u0006\u0004%\t!\u0019\u0005\tK\u0002\u0011\t\u0011)A\u0005E\"Aa\r\u0001BC\u0002\u0013\u0005q\r\u0003\u0005u\u0001\t\u0005\t\u0015!\u0003i\u0011!)\bA!b\u0001\n\u00031\b\u0002\u0003?\u0001\u0005\u0003\u0005\u000b\u0011B<\t\u0011u\u0004!Q1A\u0005\u0002yD\u0011\"a\u0003\u0001\u0005\u0003\u0005\u000b\u0011B@\t\u0015\u00055\u0001A!b\u0001\n\u0003\ty\u0001\u0003\u0006\u0002\u001c\u0001\u0011\t\u0011)A\u0005\u0003#A!\"!\b\u0001\u0005\u000b\u0007I\u0011AA\u0010\u0011)\t9\u0003\u0001B\u0001B\u0003%\u0011\u0011\u0005\u0005\u000b\u0003S\u0001!Q1A\u0005\u0002\u0005-\u0002BCA\"\u0001\t\u0005\t\u0015!\u0003\u0002.!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003\"CA.\u0001\t\u0007I\u0011BA/\u0011!\tI\u0007\u0001Q\u0001\n\u0005}\u0003\"CA6\u0001\t\u0007I\u0011BA7\u0011!\ty\b\u0001Q\u0001\n\u0005=\u0004\"CAA\u0001\t\u0007I\u0011CAB\u0011!\tY\t\u0001Q\u0001\n\u0005\u0015\u0005\"CAG\u0001\t\u0007I\u0011BAH\u0011!\t9\n\u0001Q\u0001\n\u0005E\u0005\"CAM\u0001\t\u0007I\u0011BAN\u0011!\t\u0019\u000b\u0001Q\u0001\n\u0005u\u0005\"CAS\u0001\t\u0007I\u0011BAT\u0011!\t\t\f\u0001Q\u0001\n\u0005%\u0006\"CAZ\u0001\t\u0007I\u0011BAT\u0011!\t)\f\u0001Q\u0001\n\u0005%\u0006\"CA\\\u0001\t\u0007I\u0011BA]\u0011!\t9\r\u0001Q\u0001\n\u0005m\u0006BCAe\u0001\t\u0007I\u0011\u0001%\u0002L\"A\u0011\u0011\u001e\u0001!\u0002\u0013\ti\rC\u0005\u0002l\u0002\u0011\r\u0011\"\u0001\u0002n\"A\u0011Q\u001f\u0001!\u0002\u0013\ty\u000f\u0003\u0005\u0002x\u0002\u0001\u000b\u0011BA}\u0011%\u0011)\u0001\u0001b\u0001\n\u0003\u00119\u0001\u0003\u0005\u0003\u0010\u0001\u0001\u000b\u0011\u0002B\u0005\u0011%\u0011\t\u0002\u0001b\u0001\n\u0013\u0011\u0019\u0002\u0003\u0005\u0003\"\u0001\u0001\u000b\u0011\u0002B\u000b\u0011%\u0011\u0019\u0003\u0001a\u0001\n\u0013\u0011)\u0003C\u0005\u0003.\u0001\u0001\r\u0011\"\u0003\u00030!A!1\b\u0001!B\u0013\u00119\u0003C\u0004\u0002x\u0002!\tA!\u0010\t\u000f\t}\u0002\u0001\"\u0001\u0003B!9!Q\n\u0001\u0005\n\t=\u0003b\u0002B+\u0001\u0011%!q\u000b\u0005\b\u0005[\u0002A\u0011\u0003B8\u0011\u001d\u0011i\b\u0001C\u0001\u0005\u007fBqA!!\u0001\t\u0003\u0011y\bC\u0004\u0003\u0004\u0002!\tA!\"\t\u000f\t-\u0005\u0001\"\u0001\u0003\u000e\"9!Q\u0013\u0001\u0005\u0002\t]\u0005b\u0002BO\u0001\u0011\u0005#q\u0014\u0005\b\u0005{\u0003A\u0011\tB`\u0011\u001d\u0011)\r\u0001C!\u0005\u000fD\u0001Ba4\u0001\t\u0003A%\u0011\u001b\u0005\b\u0005G\u0004A\u0011\u0001Bs\u000f\u001d\u0011y\u000f\u0013E\u0001\u0005c4aa\u0012%\t\u0002\tM\bbBA#y\u0011\u0005!Q\u001f\u0005\n\u0005od$\u0019!C\u0001\u0005sD\u0001Ba@=A\u0003%!1 \u0005\n\u0007\u0003a$\u0019!C\u0001\u0005?C\u0001ba\u0001=A\u0003%!\u0011\u0015\u0005\n\u0007\u000ba$\u0019!C\u0001\u0005?C\u0001ba\u0002=A\u0003%!\u0011\u0015\u0005\b\u0007\u0013aD\u0011AB\u0006\u0011%\u0019\t\u0003PI\u0001\n\u0003\u0019\u0019\u0003C\u0005\u0004:q\n\n\u0011\"\u0001\u0004<\ta1k\\2lKR\u001cVM\u001d<fe*\u0011\u0011JS\u0001\b]\u0016$xo\u001c:l\u0015\u0005Y\u0015!B6bM.\f7\u0001A\n\u0005\u00019#&\f\u0005\u0002P%6\t\u0001KC\u0001R\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0006K\u0001\u0004B]f\u0014VM\u001a\t\u0003+bk\u0011A\u0016\u0006\u0003/*\u000bQ!\u001e;jYNL!!\u0017,\u0003\u000f1{wmZ5oOB\u00111LX\u0007\u00029*\u0011QLS\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005}c&\u0001\u0006\"s_.,'OU3d_:4\u0017nZ;sC\ndW-\u0001\u0004d_:4\u0017nZ\u000b\u0002EB\u00111lY\u0005\u0003Ir\u00131bS1gW\u0006\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013aB7fiJL7m]\u000b\u0002QB\u0011\u0011N]\u0007\u0002U*\u0011am\u001b\u0006\u0003Y6\faaY8n[>t'BA&o\u0015\ty\u0007/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002c\u0006\u0019qN]4\n\u0005MT'aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005!A/[7f+\u00059\bC\u0001={\u001b\u0005I(BA,l\u0013\tY\u0018P\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013AE2sK\u0012,g\u000e^5bYB\u0013xN^5eKJ,\u0012a \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA7\u0002\u0011M,7-\u001e:jifLA!!\u0003\u0002\u0004\t\u00112I]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s\u0003M\u0019'/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:!\u0003E\t\u0007/\u001b,feNLwN\\'b]\u0006<WM]\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u00185\u0011\u0011Q\u0003\u0006\u0003;6LA!!\u0007\u0002\u0016\t\t\u0012\t]5WKJ\u001c\u0018n\u001c8NC:\fw-\u001a:\u0002%\u0005\u0004\u0018NV3sg&|g.T1oC\u001e,'\u000fI\u0001\u000eg>\u001c7.\u001a;GC\u000e$xN]=\u0016\u0005\u0005\u0005\u0002\u0003BA\n\u0003GIA!!\n\u0002\u0016\t\u00192+\u001a:wKJ\u001cvnY6fi\u001a\u000b7\r^8ss\u0006q1o\\2lKR4\u0015m\u0019;pef\u0004\u0013!H2p]:,7\r^5p]\u0012K7oY8o]\u0016\u001cG\u000fT5ti\u0016tWM]:\u0016\u0005\u00055\u0002CBA\u0018\u0003k\tI$\u0004\u0002\u00022)\u0019\u00111\u0007)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00028\u0005E\"aA*fcB!\u00111HA \u001b\t\tiDC\u0002J\u0003+IA!!\u0011\u0002>\ta2i\u001c8oK\u000e$\u0018n\u001c8ESN\u001cwN\u001c8fGRd\u0015n\u001d;f]\u0016\u0014\u0018AH2p]:,7\r^5p]\u0012K7oY8o]\u0016\u001cG\u000fT5ti\u0016tWM]:!\u0003\u0019a\u0014N\\5u}Q\u0001\u0012\u0011JA'\u0003\u001f\n\t&a\u0015\u0002V\u0005]\u0013\u0011\f\t\u0004\u0003\u0017\u0002Q\"\u0001%\t\u000b\u0001|\u0001\u0019\u00012\t\u000b\u0019|\u0001\u0019\u00015\t\u000bU|\u0001\u0019A<\t\u000bu|\u0001\u0019A@\t\u000f\u00055q\u00021\u0001\u0002\u0012!I\u0011QD\b\u0011\u0002\u0003\u0007\u0011\u0011\u0005\u0005\n\u0003Sy\u0001\u0013!a\u0001\u0003[\tA\"\\3ue&\u001c7o\u0012:pkB,\"!a\u0018\u0011\t\u0005\u0005\u0014QM\u0007\u0003\u0003GR1AZA\u000b\u0013\u0011\t9'a\u0019\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/A\u0007nKR\u0014\u0018nY:He>,\b\u000fI\u0001\u0012[\u0006D\u0018+^3vK\u0012\u0014V-];fgR\u001cXCAA8!\u0011\t\t(a\u001f\u000e\u0005\u0005M$\u0002BA;\u0003o\nA\u0001\\1oO*\u0011\u0011\u0011P\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002~\u0005M$aB%oi\u0016<WM]\u0001\u0013[\u0006D\u0018+^3vK\u0012\u0014V-];fgR\u001c\b%\u0001\u0004o_\u0012,\u0017\nZ\u000b\u0003\u0003\u000b\u00032aTAD\u0013\r\tI\t\u0015\u0002\u0004\u0013:$\u0018a\u00028pI\u0016LE\rI\u0001\u000bY><7i\u001c8uKb$XCAAI!\rA\u00181S\u0005\u0004\u0003+K(A\u0003'pO\u000e{g\u000e^3yi\u0006YAn\\4D_:$X\r\u001f;!\u0003AiW-\\8ssB{w\u000e\\*f]N|'/\u0006\u0002\u0002\u001eB\u0019\u0011.a(\n\u0007\u0005\u0005&N\u0001\u0004TK:\u001cxN]\u0001\u0012[\u0016lwN]=Q_>d7+\u001a8t_J\u0004\u0013aI7f[>\u0014\u0018\u0010U8pY\u0012+\u0007\u000f\\3uK\u0012\u0004VM]2f]RlU\r\u001e:jG:\u000bW.Z\u000b\u0003\u0003S\u0003B!a+\u0002.6\t1.C\u0002\u00020.\u0014!\"T3ue&\u001cg*Y7f\u0003\u0011jW-\\8ssB{w\u000e\u001c#fa2,G/\u001a3QKJ\u001cWM\u001c;NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013\u0001I7f[>\u0014\u0018\u0010U8pY\u0012+\u0007\u000f\\3uK\u0012$\u0016.\\3NKR\u0014\u0018n\u0019(b[\u0016\f\u0011%\\3n_JL\bk\\8m\t\u0016\u0004H.\u001a;fIRKW.Z'fiJL7MT1nK\u0002\n!\"\\3n_JL\bk\\8m+\t\tY\f\u0005\u0003\u0002>\u0006\rWBAA`\u0015\r\t\tm[\u0001\u0007[\u0016lwN]=\n\t\u0005\u0015\u0017q\u0018\u0002\u000b\u001b\u0016lwN]=Q_>d\u0017aC7f[>\u0014\u0018\u0010U8pY\u0002\n!\u0003Z1uCBc\u0017M\\3BG\u000e,\u0007\u000f^8sgV\u0011\u0011Q\u001a\t\t\u0003\u001f\fI.!8\u0002d6\u0011\u0011\u0011\u001b\u0006\u0005\u0003'\f).\u0001\u0006d_:\u001cWO\u001d:f]RTA!a6\u0002x\u0005!Q\u000f^5m\u0013\u0011\tY.!5\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0003\u0002,\u0006}\u0017bAAqW\nAQI\u001c3q_&tG\u000f\u0005\u0003\u0002L\u0005\u0015\u0018bAAt\u0011\n\tB)\u0019;b!2\fg.Z!dG\u0016\u0004Ho\u001c:\u0002'\u0011\fG/\u0019)mC:,\u0017iY2faR|'o\u001d\u0011\u0002/\u0011\fG/\u0019)mC:,'+Z9vKN$8\t[1o]\u0016dWCAAx!\u0011\tY%!=\n\u0007\u0005M\bJ\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\u00021\u0011\fG/\u0019)mC:,'+Z9vKN$8\t[1o]\u0016d\u0007%A\boKb$\bK]8dKN\u001cxN]%e!\u0011\tYP!\u0001\u000e\u0005\u0005u(\u0002BA\u0000\u0003#\fa!\u0019;p[&\u001c\u0017\u0002\u0002B\u0002\u0003{\u0014Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018\u0001E2p]:,7\r^5p]F+x\u000e^1t+\t\u0011I\u0001\u0005\u0003\u0002L\t-\u0011b\u0001B\u0007\u0011\n\u00012i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m]\u0001\u0012G>tg.Z2uS>t\u0017+^8uCN\u0004\u0013\u0001H1mY\u0006+H\u000f[8sSj,'OR;ukJ,7oQ8na2,G/Z\u000b\u0003\u0005+\u0001b!a4\u0003\u0018\tm\u0011\u0002\u0002B\r\u0003#\u0014\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!\u0011\t\tH!\b\n\t\t}\u00111\u000f\u0002\u0005->LG-A\u000fbY2\fU\u000f\u001e5pe&TXM\u001d$viV\u0014Xm]\"p[BdW\r^3!\u0003\u001d\u0019Ho\u001c9qK\u0012,\"Aa\n\u0011\u0007=\u0013I#C\u0002\u0003,A\u0013qAQ8pY\u0016\fg.A\u0006ti>\u0004\b/\u001a3`I\u0015\fH\u0003\u0002B\u0019\u0005o\u00012a\u0014B\u001a\u0013\r\u0011)\u0004\u0015\u0002\u0005+:LG\u000fC\u0005\u0003:)\n\t\u00111\u0001\u0003(\u0005\u0019\u0001\u0010J\u0019\u0002\u0011M$x\u000e\u001d9fI\u0002\"\"!!\"\u0002/\u0015t\u0017M\u00197f%\u0016\fX/Z:u!J|7-Z:tS:<G\u0003\u0002B\u000b\u0005\u0007BqA!\u0012.\u0001\u0004\u00119%A\tbkRDwN]5{KJ4U\u000f^;sKN\u0004\u0002\"a\f\u0003J\u0005u'QC\u0005\u0005\u0005\u0017\n\tDA\u0002NCB\fAe\u0019:fCR,G)\u0019;b!2\fg.Z!dG\u0016\u0004Ho\u001c:B]\u0012\u0004&o\\2fgN|'o\u001d\u000b\u0005\u0005c\u0011\t\u0006C\u0004\u0003T9\u0002\r!!8\u0002\u0011\u0015tG\r]8j]R\f\u0011\"\u001a8ea>Lg\u000e^:\u0016\u0005\te\u0003\u0003\u0003B.\u0005C\u0012\u0019'!8\u000e\u0005\tu#\u0002\u0002B0\u0003c\t\u0011\"[7nkR\f'\r\\3\n\t\t-#Q\f\t\u0005\u0005K\u0012I'\u0004\u0002\u0003h)\u0011\u0011j[\u0005\u0005\u0005W\u00129G\u0001\u0007MSN$XM\\3s\u001d\u0006lW-A\fde\u0016\fG/\u001a#bi\u0006\u0004F.\u00198f\u0003\u000e\u001cW\r\u001d;peRA\u00111\u001dB9\u0005k\u0012I\bC\u0004\u0003tA\u0002\r!!8\u0002\u0011\u0015tG\rU8j]RDqAa\u001e1\u0001\u0004\u00119#\u0001\u000bjgB\u0013\u0018N^5mK\u001e,G\rT5ti\u0016tWM\u001d\u0005\b\u0005w\u0002\u0004\u0019AAx\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2\fac\u001d;paB\u0013xnY3tg&twMU3rk\u0016\u001cHo\u001d\u000b\u0003\u0005c\t\u0001b\u001d5vi\u0012|wO\\\u0001\nE>,h\u000e\u001a)peR$B!!\"\u0003\b\"9!\u0011R\u001aA\u0002\t\r\u0014\u0001\u00047jgR,g.\u001a:OC6,\u0017\u0001D1eI2K7\u000f^3oKJ\u001cH\u0003\u0002B\u0019\u0005\u001fCqA!%5\u0001\u0004\u0011\u0019*\u0001\bmSN$XM\\3sg\u0006#G-\u001a3\u0011\r\u0005=\u0012QGAo\u0003=\u0011X-\\8wK2K7\u000f^3oKJ\u001cH\u0003\u0002B\u0019\u00053CqAa'6\u0001\u0004\u0011\u0019*\u0001\tmSN$XM\\3sgJ+Wn\u001c<fI\u0006)\"/Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001cXC\u0001BQ!\u0019\tyCa)\u0003(&!!QUA\u0019\u0005\r\u0019V\r\u001e\t\u0005\u0005S\u00139L\u0004\u0003\u0003,\nM\u0006c\u0001BW!6\u0011!q\u0016\u0006\u0004\u0005cc\u0015A\u0002\u001fs_>$h(C\u0002\u00036B\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002B]\u0005w\u0013aa\u0015;sS:<'b\u0001B[!\u00069b/\u00197jI\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0005\u0005c\u0011\t\r\u0003\u0004\u0003D^\u0002\rAY\u0001\n]\u0016<8i\u001c8gS\u001e\f1B]3d_:4\u0017nZ;sKR1!\u0011\u0007Be\u0005\u001bDaAa39\u0001\u0004\u0011\u0017!C8mI\u000e{gNZ5h\u0011\u0019\u0011\u0019\r\u000fa\u0001E\u0006y1m\u001c8oK\u000e$\u0018n\u001c8D_VtG\u000f\u0006\u0003\u0002\u0006\nM\u0007b\u0002Bks\u0001\u0007!q[\u0001\bC\u0012$'/Z:t!\u0011\u0011INa8\u000e\u0005\tm'\u0002\u0002Bo\u0003o\n1A\\3u\u0013\u0011\u0011\tOa7\u0003\u0017%sW\r^!eIJ,7o]\u0001\u0012I\u0006$\u0018\r\u00157b]\u0016\f5mY3qi>\u0014H\u0003\u0002Bt\u0005[\u0004Ra\u0014Bu\u0003GL1Aa;Q\u0005\u0019y\u0005\u000f^5p]\"9!\u0011\u0012\u001eA\u0002\t\u001d\u0016\u0001D*pG.,GoU3sm\u0016\u0014\bcAA&yM\u0011AH\u0014\u000b\u0003\u0005c\fA\"T3ue&\u001c7o\u0012:pkB,\"Aa?\u0011\t\u0005E$Q`\u0005\u0005\u0005s\u000b\u0019(A\u0007NKR\u0014\u0018nY:He>,\b\u000fI\u0001\u0016%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t\u0003Y\u0011VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\u0004\u0013!\b'jgR,g.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0002=1K7\u000f^3oKJ\u0014VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\u0004\u0013aC2m_N,7k\\2lKR$BA!\r\u0004\u000e!91q\u0002#A\u0002\rE\u0011aB2iC:tW\r\u001c\t\u0005\u0007'\u0019i\"\u0004\u0002\u0004\u0016)!1qCB\r\u0003!\u0019\u0007.\u00198oK2\u001c(\u0002BB\u000e\u0003o\n1A\\5p\u0013\u0011\u0019yb!\u0006\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u00111Q\u0005\u0016\u0005\u0003C\u00199c\u000b\u0002\u0004*A!11FB\u001b\u001b\t\u0019iC\u0003\u0003\u00040\rE\u0012!C;oG\",7m[3e\u0015\r\u0019\u0019\u0004U\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u001c\u0007[\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u00111Q\b\u0016\u0005\u0003[\u00199\u0003")
public class SocketServer
implements Logging,
BrokerReconfigurable {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final Time time;
    private final CredentialProvider credentialProvider;
    private final ApiVersionManager apiVersionManager;
    private final ServerSocketFactory socketFactory;
    private final Seq<ConnectionDisconnectListener> connectionDisconnectListeners;
    private final KafkaMetricsGroup metricsGroup;
    private final Integer maxQueuedRequests;
    private final int nodeId;
    private final LogContext logContext;
    private final Sensor memoryPoolSensor;
    private final MetricName memoryPoolDepletedPercentMetricName;
    private final MetricName memoryPoolDepletedTimeMetricName;
    private final MemoryPool memoryPool;
    private final ConcurrentHashMap<Endpoint, DataPlaneAcceptor> dataPlaneAcceptors;
    private final RequestChannel dataPlaneRequestChannel;
    private final AtomicInteger nextProcessorId;
    private final ConnectionQuotas connectionQuotas;
    private final CompletableFuture<Void> allAuthorizerFuturesComplete;
    private boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Seq<ConnectionDisconnectListener> $lessinit$greater$default$7() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static ServerSocketFactory $lessinit$greater$default$6() {
        return ServerSocketFactory.INSTANCE;
    }

    public static void closeSocket(SocketChannel channel) {
        SocketServer$.MODULE$.closeSocket(channel);
    }

    public static Set<String> ListenerReconfigurableConfigs() {
        return SocketServer$.MODULE$.ListenerReconfigurableConfigs();
    }

    public static Set<String> ReconfigurableConfigs() {
        return SocketServer$.MODULE$.ReconfigurableConfigs();
    }

    public static String MetricsGroup() {
        return SocketServer$.MODULE$.MetricsGroup();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Time time() {
        return this.time;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public ApiVersionManager apiVersionManager() {
        return this.apiVersionManager;
    }

    public ServerSocketFactory socketFactory() {
        return this.socketFactory;
    }

    public Seq<ConnectionDisconnectListener> connectionDisconnectListeners() {
        return this.connectionDisconnectListeners;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private Integer maxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    public int nodeId() {
        return this.nodeId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private Sensor memoryPoolSensor() {
        return this.memoryPoolSensor;
    }

    private MetricName memoryPoolDepletedPercentMetricName() {
        return this.memoryPoolDepletedPercentMetricName;
    }

    private MetricName memoryPoolDepletedTimeMetricName() {
        return this.memoryPoolDepletedTimeMetricName;
    }

    private MemoryPool memoryPool() {
        return this.memoryPool;
    }

    public ConcurrentHashMap<Endpoint, DataPlaneAcceptor> dataPlaneAcceptors() {
        return this.dataPlaneAcceptors;
    }

    public RequestChannel dataPlaneRequestChannel() {
        return this.dataPlaneRequestChannel;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private CompletableFuture<Void> allAuthorizerFuturesComplete() {
        return this.allAuthorizerFuturesComplete;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public int nextProcessorId() {
        return this.nextProcessorId.getAndIncrement();
    }

    public synchronized CompletableFuture<Void> enableRequestProcessing(Map<Endpoint, CompletableFuture<Void>> authorizerFutures) {
        if (this.stopped()) {
            throw new RuntimeException("Can't enable request processing: SocketServer is stopped.");
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Enabling request processing.");
        this.dataPlaneAcceptors().values().forEach(acceptor -> this.chainAcceptorFuture$1((Acceptor)acceptor, (Map)authorizerFutures));
        FutureUtils.chainFuture(CompletableFuture.allOf((CompletableFuture[])authorizerFutures.values().toArray(ClassTag$.MODULE$.apply(CompletableFuture.class))), this.allAuthorizerFuturesComplete());
        CompletableFuture<Void> enableFuture = new CompletableFuture<Void>();
        FutureUtils.chainFuture(CompletableFuture.allOf((CompletableFuture[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])CollectionConverters$.MODULE$.CollectionHasAsScala(this.dataPlaneAcceptors().values()).asScala().toArray(ClassTag$.MODULE$.apply(DataPlaneAcceptor.class))), (Function1 & Serializable)x$2 -> x$2.startedFuture(), ClassTag$.MODULE$.apply(CompletableFuture.class))), enableFuture);
        return enableFuture;
    }

    private synchronized void createDataPlaneAcceptorAndProcessors(Endpoint endpoint) {
        if (this.stopped()) {
            throw new RuntimeException("Can't create new data plane acceptor and processors: SocketServer is stopped.");
        }
        ListenerName listenerName = ListenerName.normalised((String)endpoint.listener());
        java.util.Map<String, Object> parsedConfigs = this.config().valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
        this.connectionQuotas().addListener(this.config(), listenerName);
        ListenerName listenerName2 = this.config().interBrokerListenerName();
        boolean isPrivilegedListener = listenerName2 != null && listenerName2.equals(listenerName);
        DataPlaneAcceptor dataPlaneAcceptor = this.createDataPlaneAcceptor(endpoint, isPrivilegedListener, this.dataPlaneRequestChannel());
        this.config().addReconfigurable((Reconfigurable)dataPlaneAcceptor);
        dataPlaneAcceptor.configure(parsedConfigs);
        this.dataPlaneAcceptors().put(endpoint, dataPlaneAcceptor);
        this.info((Function0<String>)(Function0 & Serializable)() -> "Created data-plane acceptor and processors for endpoint : " + listenerName);
    }

    private scala.collection.immutable.Map<ListenerName, Endpoint> endpoints() {
        return ((IterableOnceOps)this.config().listeners().map((Function1 & Serializable)l -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ListenerName.normalised((String)l.listener())), l))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public DataPlaneAcceptor createDataPlaneAcceptor(Endpoint endPoint, boolean isPrivilegedListener, RequestChannel requestChannel) {
        return new DataPlaneAcceptor(this, endPoint, this.config(), this.nodeId(), this.connectionQuotas(), this.time(), isPrivilegedListener, requestChannel, this.metrics(), this.credentialProvider(), this.logContext(), this.memoryPool(), this.apiVersionManager());
    }

    public synchronized void stopProcessingRequests() {
        if (!this.stopped()) {
            this.stopped_$eq(true);
            this.info((Function0<String>)(Function0 & Serializable)() -> "Stopping socket server request processors");
            CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.dataPlaneAcceptors()).asScala().values().foreach((Function1 & Serializable)x$3 -> {
                x$3.beginShutdown();
                return BoxedUnit.UNIT;
            });
            CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.dataPlaneAcceptors()).asScala().values().foreach((Function1 & Serializable)x$4 -> {
                x$4.close();
                return BoxedUnit.UNIT;
            });
            this.dataPlaneRequestChannel().clear();
            this.info((Function0<String>)(Function0 & Serializable)() -> "Stopped socket server request processors");
            return;
        }
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down socket server");
        this.allAuthorizerFuturesComplete().completeExceptionally(new TimeoutException("The socket server was shut down before the Authorizer could be completely initialized."));
        synchronized (this) {
            this.stopProcessingRequests();
            this.dataPlaneRequestChannel().shutdown();
            this.connectionQuotas().close();
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown completed");
    }

    public int boundPort(ListenerName listenerName) {
        int n;
        try {
            DataPlaneAcceptor acceptor = this.dataPlaneAcceptors().get(this.endpoints().apply((Object)listenerName));
            if (acceptor == null) {
                throw new KafkaException("Could not find listenerName : " + listenerName + " in data-plane.");
            }
            n = acceptor.localPort();
        }
        catch (Exception e) {
            throw new KafkaException("Tried to check for port of non-existing protocol", (Throwable)e);
        }
        return n;
    }

    public synchronized void addListeners(Seq<Endpoint> listenersAdded) {
        if (this.stopped()) {
            throw new RuntimeException("can't add new listeners: SocketServer is stopped.");
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Adding data-plane listeners for endpoints " + listenersAdded);
        listenersAdded.foreach((Function1 & Serializable)endpoint -> {
            this.createDataPlaneAcceptorAndProcessors((Endpoint)endpoint);
            DataPlaneAcceptor acceptor = this.dataPlaneAcceptors().get(endpoint);
            return this.allAuthorizerFuturesComplete().whenComplete((x$5, e) -> {
                if (e != null) {
                    acceptor.startedFuture().completeExceptionally((Throwable)e);
                    return;
                }
                acceptor.start();
            });
        });
    }

    public synchronized void removeListeners(Seq<Endpoint> listenersRemoved) {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Removing data-plane listeners for endpoints " + listenersRemoved);
        listenersRemoved.foreach((Function1 & Serializable)endpoint -> {
            SocketServer.$anonfun$removeListeners$2(this, endpoint);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return SocketServer$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Integer maxConnectionRate;
        Integer maxConnections;
        Map<String, Object> maxConnectionsPerIpOverrides;
        Integer maxConnectionsPerIp;
        Integer n = maxConnectionsPerIp = newConfig.maxConnectionsPerIp();
        Integer n2 = oldConfig.maxConnectionsPerIp();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Updating maxConnectionsPerIp: " + maxConnectionsPerIp);
            this.connectionQuotas().updateMaxConnectionsPerIp(Predef$.MODULE$.Integer2int(maxConnectionsPerIp));
        }
        Map<String, Object> map = maxConnectionsPerIpOverrides = newConfig.maxConnectionsPerIpOverrides();
        Map<String, Object> map2 = oldConfig.maxConnectionsPerIpOverrides();
        if (map == null ? map2 != null : !map.equals(map2)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Updating maxConnectionsPerIpOverrides: " + ((IterableOnceOps)maxConnectionsPerIpOverrides.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String k = (String)x0$1._1();
                    int v = x0$1._2$mcI$sp();
                    return k + "=" + v;
                }
                throw new MatchError(null);
            })).mkString(","));
            this.connectionQuotas().updateMaxConnectionsPerIpOverride(maxConnectionsPerIpOverrides);
        }
        Integer n3 = maxConnections = newConfig.maxConnections();
        Integer n4 = oldConfig.maxConnections();
        if (n3 == null ? n4 != null : !((Object)n3).equals(n4)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Updating broker-wide maxConnections: " + maxConnections);
            this.connectionQuotas().updateBrokerMaxConnections(Predef$.MODULE$.Integer2int(maxConnections));
        }
        Integer n5 = maxConnectionRate = newConfig.maxConnectionCreationRate();
        Integer n6 = oldConfig.maxConnectionCreationRate();
        if (n5 == null ? n6 != null : !((Object)n5).equals(n6)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Updating broker-wide maxConnectionCreationRate: " + maxConnectionRate);
            this.connectionQuotas().updateBrokerMaxConnectionRate(Predef$.MODULE$.Integer2int(maxConnectionRate));
            return;
        }
    }

    public int connectionCount(InetAddress address) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.connectionQuotas()).fold((Function0)(JFunction0.mcI.sp & Serializable)() -> 0, (Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.get(address))));
    }

    public Option<DataPlaneAcceptor> dataPlaneAcceptor(String listenerName) {
        Object object = new Object();
        try {
            CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.dataPlaneAcceptors()).asScala().foreach((Function1 & Serializable)x0$1 -> {
                SocketServer.$anonfun$dataPlaneAcceptor$1(listenerName, object, x0$1);
                return BoxedUnit.UNIT;
            });
            return None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ double $anonfun$new$6(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    public static final /* synthetic */ double $anonfun$new$4(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (Function1 & Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$6(m))));
    }

    public static final /* synthetic */ double $anonfun$new$1(SocketServer $this) {
        synchronized ($this) {
            Iterable dataPlaneProcessors = (Iterable)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala($this.dataPlaneAcceptors()).asScala().values().flatMap((Function1 & Serializable)a -> a.processors());
            Iterable ioWaitRatioMetricNames = (Iterable)dataPlaneProcessors.map((Function1 & Serializable)p -> {
                void metricName_tags;
                void metricName_group;
                void metricName_name;
                Metrics metrics = $this.metrics();
                java.util.Map<String, String> map = p.metricTags();
                String string = SocketServer$.MODULE$.MetricsGroup();
                String string2 = "io-wait-ratio";
                if (metrics == null) {
                    throw null;
                }
                return metrics.metricName((String)metricName_name, (String)metricName_group, "", (java.util.Map)metricName_tags);
            });
            double d = dataPlaneProcessors.isEmpty() ? 1.0 : BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)ioWaitRatioMetricNames.map((Function1 & Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$4($this, metricName)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)dataPlaneProcessors.size();
            return d;
        }
    }

    public static final /* synthetic */ long $anonfun$new$7(SocketServer $this) {
        return $this.memoryPool().availableMemory();
    }

    public static final /* synthetic */ long $anonfun$new$8(SocketServer $this) {
        return $this.memoryPool().size() - $this.memoryPool().availableMemory();
    }

    public static final /* synthetic */ double $anonfun$new$14(KafkaMetric m) {
        return BoxesRunTime.unboxToDouble((Object)m.metricValue());
    }

    public static final /* synthetic */ double $anonfun$new$12(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (Function1 & Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$14(m))));
    }

    public static final /* synthetic */ double $anonfun$new$9(SocketServer $this) {
        synchronized ($this) {
            double d = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((Iterable)((Iterable)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala($this.dataPlaneAcceptors()).asScala().values().flatMap((Function1 & Serializable)a -> a.processors())).map((Function1 & Serializable)p -> {
                void metricName_tags;
                void metricName_group;
                void metricName_name;
                Metrics metrics = $this.metrics();
                java.util.Map<String, String> map = p.metricTags();
                String string = SocketServer$.MODULE$.MetricsGroup();
                String string2 = "expired-connections-killed-count";
                if (metrics == null) {
                    throw null;
                }
                return metrics.metricName((String)metricName_name, (String)metricName_group, "", (java.util.Map)metricName_tags);
            })).map((Function1 & Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$12($this, metricName)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            return d;
        }
    }

    public static final /* synthetic */ boolean $anonfun$enableRequestProcessing$1(Acceptor acceptor$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            Endpoint endpoint = (Endpoint)x0$1._1();
            return acceptor$1.endPoint().listener().equals(endpoint.listener());
        }
        throw new MatchError(null);
    }

    private final void chainAcceptorFuture$1(Acceptor acceptor, Map authorizerFutures$1) {
        Tuple2 tuple2;
        CompletableFuture completableFuture;
        Option option = authorizerFutures$1.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SocketServer.$anonfun$enableRequestProcessing$1(acceptor, x0$1)));
        if (None$.MODULE$.equals(option)) {
            completableFuture = this.allAuthorizerFuturesComplete();
        } else if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            completableFuture = (CompletableFuture)tuple2._2();
        } else {
            throw new MatchError((Object)option);
        }
        completableFuture.whenComplete((x$1, e) -> {
            if (e != null) {
                acceptor.startedFuture().completeExceptionally((Throwable)e);
                return;
            }
            acceptor.start();
        });
    }

    public static final /* synthetic */ void $anonfun$removeListeners$3(SocketServer $this, DataPlaneAcceptor acceptor) {
        acceptor.beginShutdown();
        acceptor.close();
        $this.config().removeReconfigurable((Reconfigurable)acceptor);
    }

    public static final /* synthetic */ void $anonfun$removeListeners$2(SocketServer $this, Endpoint endpoint) {
        $this.connectionQuotas().removeListener($this.config(), ListenerName.normalised((String)endpoint.listener()));
        CollectionConverters$.MODULE$.ConcurrentMapHasAsScala($this.dataPlaneAcceptors()).asScala().remove((Object)endpoint).foreach((Function1 & Serializable)acceptor -> {
            SocketServer.$anonfun$removeListeners$3($this, acceptor);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$dataPlaneAcceptor$1(String listenerName$2, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        block5: {
            block8: {
                DataPlaneAcceptor acceptor;
                block7: {
                    String string;
                    block6: {
                        if (x0$1 == null) break block5;
                        Endpoint endPoint = (Endpoint)x0$1._1();
                        acceptor = (DataPlaneAcceptor)x0$1._2();
                        string = endPoint.listener();
                        if (string != null) break block6;
                        if (listenerName$2 != null) {
                            return;
                        }
                        break block7;
                    }
                    if (!string.equals(listenerName$2)) break block8;
                }
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)acceptor));
            }
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public SocketServer(KafkaConfig config, Metrics metrics, Time time, CredentialProvider credentialProvider, ApiVersionManager apiVersionManager, ServerSocketFactory socketFactory, Seq<ConnectionDisconnectListener> connectionDisconnectListeners) {
        void add_stat;
        void sensor_name;
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.credentialProvider = credentialProvider;
        this.apiVersionManager = apiVersionManager;
        this.socketFactory = socketFactory;
        this.connectionDisconnectListeners = connectionDisconnectListeners;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.maxQueuedRequests = config.queuedMaxRequests();
        this.nodeId = config.brokerId();
        this.logContext = new LogContext("[SocketServer listenerType=" + apiVersionManager.listenerType() + ", nodeId=" + this.nodeId() + "] ");
        this.logIdent_$eq(this.logContext().logPrefix());
        String string = "MemoryPoolUtilization";
        if (metrics == null) {
            throw null;
        }
        Sensor.RecordingLevel sensor_recordingLevel = Sensor.RecordingLevel.INFO;
        Object var10_9 = null;
        string = null;
        this.memoryPoolSensor = metrics.sensor((String)sensor_name, null, sensor_recordingLevel, (Sensor[])null);
        this.memoryPoolDepletedPercentMetricName = metrics.metricName("MemoryPoolAvgDepletedPercent", SocketServer$.MODULE$.MetricsGroup());
        this.memoryPoolDepletedTimeMetricName = metrics.metricName("MemoryPoolDepletedTimeTotal", SocketServer$.MODULE$.MetricsGroup());
        Sensor sensor = this.memoryPoolSensor();
        Meter meter = new Meter(TimeUnit.MILLISECONDS, this.memoryPoolDepletedPercentMetricName(), this.memoryPoolDepletedTimeMetricName());
        if (sensor == null) {
            throw null;
        }
        sensor.add((CompoundStat)add_stat, null);
        meter = null;
        this.memoryPool = Predef$.MODULE$.Long2long(config.queuedMaxBytes()) > 0L ? new SimpleMemoryPool(Predef$.MODULE$.Long2long(config.queuedMaxBytes()), Predef$.MODULE$.Integer2int(config.socketRequestMaxBytes()), false, this.memoryPoolSensor()) : MemoryPool.NONE;
        this.dataPlaneAcceptors = new ConcurrentHashMap();
        this.dataPlaneRequestChannel = new RequestChannel(Predef$.MODULE$.Integer2int(this.maxQueuedRequests()), time, apiVersionManager.newRequestMetrics());
        this.nextProcessorId = new AtomicInteger(0);
        this.connectionQuotas = new ConnectionQuotas(config, time, metrics);
        this.allAuthorizerFuturesComplete = new CompletableFuture();
        this.stopped = false;
        this.metricsGroup().newGauge("NetworkProcessorAvgIdlePercent", () -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$1(this)));
        this.metricsGroup().newGauge("MemoryPoolAvailable", () -> BoxesRunTime.boxToLong((long)SocketServer.$anonfun$new$7(this)));
        this.metricsGroup().newGauge("MemoryPoolUsed", () -> BoxesRunTime.boxToLong((long)SocketServer.$anonfun$new$8(this)));
        this.metricsGroup().newGauge("ExpiredConnectionsKilledCount", () -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$9(this)));
        if (apiVersionManager.listenerType().equals((Object)ApiMessageType.ListenerType.CONTROLLER)) {
            config.controllerListeners().foreach((Function1 & Serializable)endpoint -> {
                this.createDataPlaneAcceptorAndProcessors(endpoint);
                return BoxedUnit.UNIT;
            });
            return;
        }
        config.dataPlaneListeners().foreach((Function1 & Serializable)endpoint -> {
            this.createDataPlaneAcceptorAndProcessors(endpoint);
            return BoxedUnit.UNIT;
        });
    }
}

