/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal;

import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.spi.HeaderDelegateProvider;

public class RuntimeDelegateDecorator {
    public static RuntimeDelegate configured(Configuration configuration) {
        return new ConfigurableRuntimeDelegate(RuntimeDelegate.getInstance(), configuration);
    }

    private static class ConfigurableRuntimeDelegate
    extends RuntimeDelegate {
        private final RuntimeDelegate runtimeDelegate;
        private final Configuration configuration;
        private static final Set<HeaderDelegateProvider> headerDelegateProviders;

        private ConfigurableRuntimeDelegate(RuntimeDelegate runtimeDelegate, Configuration configuration) {
            this.runtimeDelegate = runtimeDelegate;
            this.configuration = configuration;
        }

        public UriBuilder createUriBuilder() {
            return this.runtimeDelegate.createUriBuilder();
        }

        public Response.ResponseBuilder createResponseBuilder() {
            return this.runtimeDelegate.createResponseBuilder();
        }

        public Variant.VariantListBuilder createVariantListBuilder() {
            return this.runtimeDelegate.createVariantListBuilder();
        }

        public <T> T createEndpoint(Application application, Class<T> endpointType) throws IllegalArgumentException, UnsupportedOperationException {
            return (T)this.runtimeDelegate.createEndpoint(application, endpointType);
        }

        public <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Class<T> type) throws IllegalArgumentException {
            RuntimeDelegate.HeaderDelegate headerDelegate = null;
            if (this.configuration == null || PropertiesHelper.isMetaInfServicesEnabled(this.configuration.getProperties(), this.configuration.getRuntimeType())) {
                headerDelegate = this._createHeaderDelegate(type);
            }
            if (headerDelegate == null) {
                headerDelegate = this.runtimeDelegate.createHeaderDelegate(type);
            }
            return headerDelegate;
        }

        public Link.Builder createLinkBuilder() {
            return this.runtimeDelegate.createLinkBuilder();
        }

        public SeBootstrap.Configuration.Builder createConfigurationBuilder() {
            return this.runtimeDelegate.createConfigurationBuilder();
        }

        public CompletionStage<SeBootstrap.Instance> bootstrap(Application application, SeBootstrap.Configuration configuration) {
            return this.runtimeDelegate.bootstrap(application, configuration);
        }

        public CompletionStage<SeBootstrap.Instance> bootstrap(Class<? extends Application> applicationClass, SeBootstrap.Configuration configuration) {
            return this.runtimeDelegate.bootstrap(applicationClass, configuration);
        }

        public EntityPart.Builder createEntityPartBuilder(String partName) throws IllegalArgumentException {
            return this.runtimeDelegate.createEntityPartBuilder(partName);
        }

        private <T> RuntimeDelegate.HeaderDelegate<T> _createHeaderDelegate(Class<T> type) {
            for (HeaderDelegateProvider hp : headerDelegateProviders) {
                if (!hp.supports(type)) continue;
                return hp;
            }
            return null;
        }

        static {
            HashSet<HeaderDelegateProvider> hps = new HashSet<HeaderDelegateProvider>();
            for (HeaderDelegateProvider provider : ServiceFinder.find(HeaderDelegateProvider.class, true)) {
                hps.add(provider);
            }
            headerDelegateProviders = Collections.unmodifiableSet(hps);
        }
    }
}

