/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.isolation.ClassLoaderFactory;
import org.apache.kafka.connect.runtime.isolation.DelegatingClassLoader;
import org.apache.kafka.connect.runtime.isolation.LoaderSwap;
import org.apache.kafka.connect.runtime.isolation.PluginClassLoader;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.PluginDiscoveryMode;
import org.apache.kafka.connect.runtime.isolation.PluginScanResult;
import org.apache.kafka.connect.runtime.isolation.PluginSource;
import org.apache.kafka.connect.runtime.isolation.PluginType;
import org.apache.kafka.connect.runtime.isolation.PluginUtils;
import org.apache.kafka.connect.runtime.isolation.ReflectionScanner;
import org.apache.kafka.connect.runtime.isolation.ServiceLoaderScanner;
import org.apache.kafka.connect.runtime.isolation.VersionedPluginLoadingException;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.ConverterType;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.predicates.Predicate;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plugins {
    private static final Logger log = LoggerFactory.getLogger(Plugins.class);
    private final DelegatingClassLoader delegatingLoader;
    private final PluginScanResult scanResult;

    public Plugins(Map<String, String> props) {
        this(props, Plugins.class.getClassLoader(), new ClassLoaderFactory());
    }

    Plugins(Map<String, String> props, ClassLoader parent, ClassLoaderFactory factory) {
        String pluginPath = WorkerConfig.pluginPath(props);
        PluginDiscoveryMode discoveryMode = WorkerConfig.pluginDiscovery(props);
        Set<Path> pluginLocations = PluginUtils.pluginLocations(pluginPath, false);
        this.delegatingLoader = factory.newDelegatingClassLoader(parent);
        Set<PluginSource> pluginSources = PluginUtils.pluginSources(pluginLocations, this.delegatingLoader, factory);
        this.scanResult = this.initLoaders(pluginSources, discoveryMode);
    }

    public PluginScanResult initLoaders(Set<PluginSource> pluginSources, PluginDiscoveryMode discoveryMode) {
        PluginScanResult serviceLoadingScanResult;
        PluginScanResult empty = new PluginScanResult(Collections.emptyList());
        try {
            serviceLoadingScanResult = discoveryMode.serviceLoad() ? new ServiceLoaderScanner().discoverPlugins(pluginSources) : empty;
        }
        catch (Throwable t) {
            throw new ConnectException(String.format("Unable to perform ServiceLoader scanning as requested by %s=%s. It may be possible to fix this issue by reconfiguring %s=%s", new Object[]{"plugin.discovery", discoveryMode, "plugin.discovery", PluginDiscoveryMode.ONLY_SCAN}), t);
        }
        PluginScanResult reflectiveScanResult = discoveryMode.reflectivelyScan() ? new ReflectionScanner().discoverPlugins(pluginSources) : empty;
        PluginScanResult scanResult = new PluginScanResult(Arrays.asList(reflectiveScanResult, serviceLoadingScanResult));
        Plugins.maybeReportHybridDiscoveryIssue(discoveryMode, serviceLoadingScanResult, scanResult);
        this.delegatingLoader.installDiscoveredPlugins(scanResult);
        return scanResult;
    }

    static void maybeReportHybridDiscoveryIssue(PluginDiscoveryMode discoveryMode, PluginScanResult serviceLoadingScanResult, PluginScanResult mergedResult) {
        TreeSet missingPlugins = new TreeSet();
        mergedResult.forEach(missingPlugins::add);
        serviceLoadingScanResult.forEach(missingPlugins::remove);
        if (missingPlugins.isEmpty()) {
            if (discoveryMode == PluginDiscoveryMode.HYBRID_WARN || discoveryMode == PluginDiscoveryMode.HYBRID_FAIL) {
                log.warn("All plugins have ServiceLoader manifests, consider reconfiguring {}={}", (Object)"plugin.discovery", (Object)PluginDiscoveryMode.SERVICE_LOAD);
            }
        } else {
            String message = String.format("One or more plugins are missing ServiceLoader manifests may not be usable with %s=%s: %s%nRead the documentation at %s for instructions on migrating your plugins to take advantage of the performance improvements of %s mode.", new Object[]{"plugin.discovery", PluginDiscoveryMode.SERVICE_LOAD, missingPlugins.stream().map(pluginDesc -> pluginDesc.location() + "\t" + pluginDesc.className() + "\t" + String.valueOf((Object)pluginDesc.type()) + "\t" + pluginDesc.version()).collect(Collectors.joining("\n", "[\n", "\n]")), "https://kafka.apache.org/documentation.html#connect_plugindiscovery", PluginDiscoveryMode.SERVICE_LOAD});
            if (discoveryMode == PluginDiscoveryMode.HYBRID_WARN) {
                log.warn("{} To silence this warning, set {}={} in the worker config.", new Object[]{message, "plugin.discovery", PluginDiscoveryMode.ONLY_SCAN});
            } else if (discoveryMode == PluginDiscoveryMode.HYBRID_FAIL) {
                throw new ConnectException(String.format("%s To silence this error, set %s=%s in the worker config.", new Object[]{message, "plugin.discovery", PluginDiscoveryMode.HYBRID_WARN}));
            }
        }
    }

    private static <T> String pluginNames(Collection<PluginDesc<T>> plugins) {
        return plugins.stream().map(PluginDesc::toString).collect(Collectors.joining(", "));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T newPlugin(Class<T> klass) {
        try (LoaderSwap loaderSwap = this.withClassLoader(klass.getClassLoader());){
            Object object = Utils.newInstance(klass);
            return (T)object;
        }
        catch (Throwable t) {
            throw new ConnectException("Instantiation error", t);
        }
    }

    protected <U> Class<? extends U> pluginClassFromConfig(AbstractConfig config, String propertyName, Class<U> pluginClass, Collection<PluginDesc<U>> plugins) {
        Class klass = config.getClass(propertyName);
        if (pluginClass.isAssignableFrom(klass)) {
            return klass;
        }
        throw new ConnectException("Failed to find any class that implements " + pluginClass.getSimpleName() + " for the config " + propertyName + ", available classes are: " + Plugins.pluginNames(plugins));
    }

    protected static <U> Class<? extends U> pluginClass(DelegatingClassLoader loader, String classOrAlias, Class<U> pluginClass) throws ClassNotFoundException {
        return Plugins.pluginClass(loader, classOrAlias, pluginClass, null);
    }

    protected static <U> Class<? extends U> pluginClass(DelegatingClassLoader loader, String classOrAlias, Class<U> pluginClass, VersionRange range) throws VersionedPluginLoadingException, ClassNotFoundException {
        Class<?> klass = loader.loadVersionedPluginClass(classOrAlias, range, false);
        if (pluginClass.isAssignableFrom(klass)) {
            return klass;
        }
        throw new ClassNotFoundException("Requested class: " + classOrAlias + " does not extend " + pluginClass.getSimpleName());
    }

    public Class<?> pluginClass(String classOrAlias) throws ClassNotFoundException {
        return Plugins.pluginClass(this.delegatingLoader, classOrAlias, Object.class);
    }

    public Class<?> pluginClass(String classOrAlias, VersionRange range) throws VersionedPluginLoadingException, ClassNotFoundException {
        return Plugins.pluginClass(this.delegatingLoader, classOrAlias, Object.class, range);
    }

    public static ClassLoader compareAndSwapLoaders(ClassLoader loader) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        if (!current.equals(loader)) {
            Thread.currentThread().setContextClassLoader(loader);
        }
        return current;
    }

    public ClassLoader compareAndSwapWithDelegatingLoader() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        if (!current.equals(this.delegatingLoader)) {
            Thread.currentThread().setContextClassLoader(this.delegatingLoader);
        }
        return current;
    }

    public LoaderSwap withClassLoader(ClassLoader loader) {
        ClassLoader savedLoader = Plugins.compareAndSwapLoaders(loader);
        try {
            return new LoaderSwap(savedLoader);
        }
        catch (Throwable t) {
            Plugins.compareAndSwapLoaders(savedLoader);
            throw t;
        }
    }

    public Runnable withClassLoader(ClassLoader classLoader, Runnable operation) {
        return () -> {
            try (LoaderSwap loaderSwap = this.withClassLoader(classLoader);){
                operation.run();
            }
        };
    }

    public Function<ClassLoader, LoaderSwap> safeLoaderSwapper() {
        return loader -> {
            if (!(loader instanceof PluginClassLoader)) {
                loader = this.delegatingLoader;
            }
            return this.withClassLoader((ClassLoader)loader);
        };
    }

    public String latestVersion(String classOrAlias, PluginType ... allowedTypes) {
        return this.pluginVersion(classOrAlias, null, allowedTypes);
    }

    public String pluginVersion(String classOrAlias, ClassLoader sourceLoader, PluginType ... allowedTypes) {
        String location = sourceLoader instanceof PluginClassLoader ? ((PluginClassLoader)sourceLoader).location() : null;
        PluginDesc<?> desc = this.delegatingLoader.pluginDesc(classOrAlias, location, new HashSet<PluginType>(Arrays.asList(allowedTypes)));
        if (desc != null) {
            return desc.version();
        }
        return null;
    }

    public DelegatingClassLoader delegatingLoader() {
        return this.delegatingLoader;
    }

    public ClassLoader connectorLoader(String connectorClassOrAlias) {
        return this.delegatingLoader.loader(connectorClassOrAlias);
    }

    public ClassLoader pluginLoader(String classOrAlias, VersionRange range) {
        return this.delegatingLoader.loader(classOrAlias, range);
    }

    public ClassLoader pluginLoader(String classOrAlias) {
        return this.delegatingLoader.loader(classOrAlias);
    }

    public Set<PluginDesc<Connector>> connectors() {
        TreeSet<PluginDesc<Connector>> connectors = new TreeSet<PluginDesc<Connector>>(this.sinkConnectors());
        connectors.addAll(this.sourceConnectors());
        return connectors;
    }

    public Set<PluginDesc<SinkConnector>> sinkConnectors() {
        return this.scanResult.sinkConnectors();
    }

    Set<PluginDesc<SinkConnector>> sinkConnectors(String connectorClassOrAlias) {
        return this.pluginsOfClass(connectorClassOrAlias, this.scanResult.sinkConnectors());
    }

    public Set<PluginDesc<SourceConnector>> sourceConnectors() {
        return this.scanResult.sourceConnectors();
    }

    Set<PluginDesc<SourceConnector>> sourceConnectors(String connectorClassOrAlias) {
        return this.pluginsOfClass(connectorClassOrAlias, this.scanResult.sourceConnectors());
    }

    public Set<PluginDesc<Converter>> converters() {
        return this.scanResult.converters();
    }

    Set<PluginDesc<Converter>> converters(String converterClassOrAlias) {
        return this.pluginsOfClass(converterClassOrAlias, this.scanResult.converters());
    }

    public Set<PluginDesc<HeaderConverter>> headerConverters() {
        return this.scanResult.headerConverters();
    }

    Set<PluginDesc<HeaderConverter>> headerConverters(String headerConverterClassOrAlias) {
        return this.pluginsOfClass(headerConverterClassOrAlias, this.scanResult.headerConverters());
    }

    public Set<PluginDesc<Transformation<?>>> transformations() {
        return this.scanResult.transformations();
    }

    Set<PluginDesc<Transformation<?>>> transformations(String transformationClassOrAlias) {
        return this.pluginsOfClass(transformationClassOrAlias, this.scanResult.transformations());
    }

    public Set<PluginDesc<Predicate<?>>> predicates() {
        return this.scanResult.predicates();
    }

    Set<PluginDesc<Predicate<?>>> predicates(String predicateClassOrAlias) {
        return this.pluginsOfClass(predicateClassOrAlias, this.scanResult.predicates());
    }

    public Set<PluginDesc<ConnectorClientConfigOverridePolicy>> connectorClientConfigPolicies() {
        return this.scanResult.connectorClientConfigPolicies();
    }

    private <T> Set<PluginDesc<T>> pluginsOfClass(String classNameOrAlias, Set<PluginDesc<T>> allPluginsOfType) {
        String className = this.delegatingLoader.resolveFullClassName(classNameOrAlias);
        TreeSet<PluginDesc<T>> plugins = new TreeSet<PluginDesc<T>>();
        for (PluginDesc<T> desc : allPluginsOfType) {
            if (!desc.className().equals(className)) continue;
            plugins.add(desc);
        }
        return plugins;
    }

    public Object newPlugin(String classOrAlias) throws ClassNotFoundException {
        Class<Object> klass = Plugins.pluginClass(this.delegatingLoader, classOrAlias, Object.class);
        return this.newPlugin(klass);
    }

    public Object newPlugin(String classOrAlias, VersionRange range) throws VersionedPluginLoadingException, ClassNotFoundException {
        Class<Object> klass = Plugins.pluginClass(this.delegatingLoader, classOrAlias, Object.class, range);
        return this.newPlugin(klass);
    }

    public Object newPlugin(String classOrAlias, VersionRange range, ClassLoader sourceLoader) throws ClassNotFoundException {
        if (range == null && sourceLoader instanceof PluginClassLoader) {
            return this.newPlugin(sourceLoader.loadClass(classOrAlias));
        }
        return this.newPlugin(classOrAlias, range);
    }

    public Connector newConnector(String connectorClassOrAlias) {
        Class<? extends Connector> klass = this.connectorClass(connectorClassOrAlias);
        return this.newPlugin(klass);
    }

    public Connector newConnector(String connectorClassOrAlias, VersionRange range) throws VersionedPluginLoadingException {
        Class<? extends Connector> klass = this.connectorClass(connectorClassOrAlias, range);
        return this.newPlugin(klass);
    }

    public Class<? extends Connector> connectorClass(String connectorClassOrAlias, VersionRange range) throws VersionedPluginLoadingException {
        Class<Object> klass;
        try {
            klass = Plugins.pluginClass(this.delegatingLoader, connectorClassOrAlias, Connector.class, range);
        }
        catch (ClassNotFoundException e) {
            ArrayList<PluginDesc<Connector>> matches = new ArrayList<PluginDesc<Connector>>();
            Set<PluginDesc<Connector>> connectors = this.connectors();
            for (PluginDesc<Connector> plugin : connectors) {
                Class<Connector> pluginClass = plugin.pluginClass();
                String simpleName = pluginClass.getSimpleName();
                if (!simpleName.equals(connectorClassOrAlias) && !simpleName.equals(connectorClassOrAlias + "Connector")) continue;
                matches.add(plugin);
            }
            if (matches.isEmpty()) {
                throw new ConnectException("Failed to find any class that implements Connector and which name matches " + connectorClassOrAlias + ", available connectors are: " + connectors.stream().map(PluginDesc::toString).collect(Collectors.joining(", ")));
            }
            if (matches.size() > 1) {
                throw new ConnectException("More than one connector matches alias " + connectorClassOrAlias + ". Please use full package and class name instead. Classes found: " + connectors.stream().map(PluginDesc::toString).collect(Collectors.joining(", ")));
            }
            PluginDesc entry = (PluginDesc)matches.get(0);
            klass = entry.pluginClass();
        }
        return klass;
    }

    public Class<? extends Connector> connectorClass(String connectorClassOrAlias) {
        return this.connectorClass(connectorClassOrAlias, null);
    }

    public Task newTask(Class<? extends Task> taskClass) {
        return this.newPlugin(taskClass);
    }

    public Converter newConverter(AbstractConfig config, String classPropertyName, ClassLoaderUsage classLoaderUsage) {
        return this.newConverter(config, classPropertyName, null, classLoaderUsage);
    }

    public Converter newConverter(AbstractConfig config, String classPropertyName, String versionPropertyName) {
        ClassLoaderUsage classLoader = config.getString(versionPropertyName) == null ? ClassLoaderUsage.CURRENT_CLASSLOADER : ClassLoaderUsage.PLUGINS;
        return this.newConverter(config, classPropertyName, versionPropertyName, classLoader);
    }

    private Converter newConverter(AbstractConfig config, String classPropertyName, String versionPropertyName, ClassLoaderUsage classLoaderUsage) {
        if (!config.originals().containsKey(classPropertyName)) {
            return null;
        }
        boolean isKeyConverter = "key.converter".equals(classPropertyName);
        String configPrefix = classPropertyName + ".";
        Map converterConfig = config.originalsWithPrefix(configPrefix);
        log.debug("Configuring the {} converter with configuration keys:{}{}", new Object[]{isKeyConverter ? "key" : "value", System.lineSeparator(), converterConfig.keySet()});
        Converter plugin = (Converter)this.newVersionedPlugin(config, classPropertyName, versionPropertyName, Converter.class, classLoaderUsage, this.scanResult.converters());
        try (LoaderSwap loaderSwap = this.safeLoaderSwapper().apply(plugin.getClass().getClassLoader());){
            plugin.configure(converterConfig, isKeyConverter);
        }
        return plugin;
    }

    public Converter newInternalConverter(boolean isKey, String className, Map<String, String> converterConfig) {
        Converter plugin;
        Class<Converter> klass;
        try {
            klass = Plugins.pluginClass(this.delegatingLoader, className, Converter.class);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectException("Failed to load internal converter class " + className);
        }
        try (LoaderSwap loaderSwap = this.withClassLoader(klass.getClassLoader());){
            plugin = this.newPlugin(klass);
            plugin.configure(converterConfig, isKey);
        }
        return plugin;
    }

    public HeaderConverter newHeaderConverter(AbstractConfig config, String classPropertyName, ClassLoaderUsage classLoaderUsage) {
        return this.newHeaderConverter(config, classPropertyName, null, classLoaderUsage);
    }

    public HeaderConverter newHeaderConverter(AbstractConfig config, String classPropertyName, String versionPropertyName) {
        ClassLoaderUsage classLoader = config.getString(versionPropertyName) == null ? ClassLoaderUsage.CURRENT_CLASSLOADER : ClassLoaderUsage.PLUGINS;
        return this.newHeaderConverter(config, classPropertyName, versionPropertyName, classLoader);
    }

    private HeaderConverter newHeaderConverter(AbstractConfig config, String classPropertyName, String versionPropertyName, ClassLoaderUsage classLoaderUsage) {
        if (config.getClass(classPropertyName) == null && classLoaderUsage == ClassLoaderUsage.CURRENT_CLASSLOADER) {
            return null;
        }
        HeaderConverter plugin = (HeaderConverter)this.newVersionedPlugin(config, classPropertyName, versionPropertyName, HeaderConverter.class, classLoaderUsage, this.scanResult.headerConverters());
        String configPrefix = classPropertyName + ".";
        Map converterConfig = config.originalsWithPrefix(configPrefix);
        converterConfig.put("converter.type", ConverterType.HEADER.getName());
        log.debug("Configuring the header converter with configuration keys:{}{}", (Object)System.lineSeparator(), converterConfig.keySet());
        try (LoaderSwap loaderSwap = this.safeLoaderSwapper().apply(plugin.getClass().getClassLoader());){
            plugin.configure(converterConfig);
        }
        return plugin;
    }

    private <U> U newVersionedPlugin(AbstractConfig config, String classPropertyName, String versionPropertyName, Class basePluginClass, ClassLoaderUsage classLoaderUsage, SortedSet<PluginDesc<U>> availablePlugins) {
        U plugin;
        String version = versionPropertyName == null ? null : config.getString(versionPropertyName);
        VersionRange range = null;
        if (version != null) {
            try {
                range = PluginUtils.connectorVersionRequirement(version);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new ConnectException(String.format("Invalid version range for %s: %s", classPropertyName, version), (Throwable)e);
            }
        }
        assert (range == null || classLoaderUsage == ClassLoaderUsage.PLUGINS);
        Class<U> klass = null;
        String basePluginClassName = basePluginClass.getSimpleName();
        switch (classLoaderUsage.ordinal()) {
            case 0: {
                klass = this.pluginClassFromConfig(config, classPropertyName, basePluginClass, availablePlugins);
                break;
            }
            case 1: {
                String classOrAlias = (String)config.originalsStrings().get(classPropertyName);
                if (classOrAlias == null) {
                    classOrAlias = config.getClass(classPropertyName) == null ? null : config.getClass(classPropertyName).getName();
                }
                try {
                    klass = Plugins.pluginClass(this.delegatingLoader, classOrAlias, basePluginClass, range);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new ConnectException("Failed to find any class that implements " + basePluginClassName + " and which name matches " + classOrAlias + ", available plugins are: " + Plugins.pluginNames(availablePlugins));
                }
            }
        }
        if (klass == null) {
            throw new ConnectException("Unable to initialize the " + basePluginClassName + " specified in " + classPropertyName);
        }
        try (LoaderSwap loaderSwap = this.withClassLoader(klass.getClassLoader());){
            plugin = this.newPlugin(klass);
        }
        return plugin;
    }

    public ConfigProvider newConfigProvider(AbstractConfig config, String providerPrefix, ClassLoaderUsage classLoaderUsage) {
        String classPropertyName = providerPrefix + ".class";
        Map originalConfig = config.originalsStrings();
        if (!originalConfig.containsKey(classPropertyName)) {
            return null;
        }
        ConfigProvider plugin = (ConfigProvider)this.newVersionedPlugin(config, classPropertyName, null, ConfigProvider.class, classLoaderUsage, this.scanResult.configProviders());
        String configPrefix = providerPrefix + ".param.";
        Map configProviderConfig = config.originalsWithPrefix(configPrefix);
        try (LoaderSwap loaderSwap = this.safeLoaderSwapper().apply(plugin.getClass().getClassLoader());){
            plugin.configure(configProviderConfig);
        }
        return plugin;
    }

    public <T> List<T> newPlugins(List<String> klassNames, AbstractConfig config, Class<T> pluginKlass) {
        ArrayList<T> plugins = new ArrayList<T>();
        if (klassNames != null) {
            for (String klassName : klassNames) {
                plugins.add(this.newPlugin(klassName, config, pluginKlass));
            }
        }
        return plugins;
    }

    public <T> T newPlugin(String klassName, AbstractConfig config, Class<T> pluginKlass) {
        T plugin;
        Class<T> klass;
        try {
            klass = Plugins.pluginClass(this.delegatingLoader, klassName, pluginKlass);
        }
        catch (ClassNotFoundException e) {
            String msg = String.format("Failed to find any class that implements %s and which name matches %s", pluginKlass, klassName);
            throw new ConnectException(msg);
        }
        try (LoaderSwap loaderSwap = this.withClassLoader(klass.getClassLoader());){
            Versioned versionedPlugin;
            plugin = this.newPlugin(klass);
            if (plugin instanceof Versioned && Utils.isBlank((String)(versionedPlugin = (Versioned)plugin).version())) {
                throw new ConnectException("Version not defined for '" + klassName + "'");
            }
            if (plugin instanceof Configurable) {
                ((Configurable)plugin).configure(config.originals());
            }
        }
        return plugin;
    }

    public static enum ClassLoaderUsage {
        CURRENT_CLASSLOADER,
        PLUGINS;

    }
}

