/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.runtime.AbstractStatus;

public class StateTracker {
    private final AtomicReference<StateChange> lastState = new AtomicReference<StateChange>(new StateChange());

    public void changeState(AbstractStatus.State newState, long now) {
        this.lastState.getAndUpdate(oldState -> oldState.newState(newState, now));
    }

    public double durationRatio(AbstractStatus.State ratioState, long now) {
        return this.lastState.get().durationRatio(ratioState, now);
    }

    public AbstractStatus.State currentState() {
        return this.lastState.get().state;
    }

    private static final class StateChange {
        private final AbstractStatus.State state;
        private final long startTime;
        private final long unassignedTotalTimeMs;
        private final long runningTotalTimeMs;
        private final long pausedTotalTimeMs;
        private final long stoppedTotalTimeMs;
        private final long failedTotalTimeMs;
        private final long destroyedTotalTimeMs;
        private final long restartingTotalTimeMs;

        StateChange() {
            this(null, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        }

        StateChange(AbstractStatus.State state, long startTime, long unassignedTotalTimeMs, long runningTotalTimeMs, long pausedTotalTimeMs, long stoppedTotalTimeMs, long failedTotalTimeMs, long destroyedTotalTimeMs, long restartingTotalTimeMs) {
            this.state = state;
            this.startTime = startTime;
            this.unassignedTotalTimeMs = unassignedTotalTimeMs;
            this.runningTotalTimeMs = runningTotalTimeMs;
            this.pausedTotalTimeMs = pausedTotalTimeMs;
            this.stoppedTotalTimeMs = stoppedTotalTimeMs;
            this.failedTotalTimeMs = failedTotalTimeMs;
            this.destroyedTotalTimeMs = destroyedTotalTimeMs;
            this.restartingTotalTimeMs = restartingTotalTimeMs;
        }

        public StateChange newState(AbstractStatus.State state, long now) {
            if (this.state == null) {
                return new StateChange(state, now, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
            }
            if (state == this.state) {
                return this;
            }
            long unassignedTime = this.unassignedTotalTimeMs;
            long runningTime = this.runningTotalTimeMs;
            long pausedTime = this.pausedTotalTimeMs;
            long stoppedTime = this.stoppedTotalTimeMs;
            long failedTime = this.failedTotalTimeMs;
            long destroyedTime = this.destroyedTotalTimeMs;
            long restartingTime = this.restartingTotalTimeMs;
            long duration = now - this.startTime;
            switch (this.state) {
                case UNASSIGNED: {
                    unassignedTime += duration;
                    break;
                }
                case RUNNING: {
                    runningTime += duration;
                    break;
                }
                case PAUSED: {
                    pausedTime += duration;
                    break;
                }
                case STOPPED: {
                    stoppedTime += duration;
                    break;
                }
                case FAILED: {
                    failedTime += duration;
                    break;
                }
                case DESTROYED: {
                    destroyedTime += duration;
                    break;
                }
                case RESTARTING: {
                    restartingTime += duration;
                }
            }
            return new StateChange(state, now, unassignedTime, runningTime, pausedTime, stoppedTime, failedTime, destroyedTime, restartingTime);
        }

        public double durationRatio(AbstractStatus.State ratioState, long now) {
            if (this.state == null) {
                return 0.0;
            }
            long durationCurrent = now - this.startTime;
            long durationDesired = ratioState == this.state ? durationCurrent : 0L;
            switch (ratioState) {
                case UNASSIGNED: {
                    durationDesired += this.unassignedTotalTimeMs;
                    break;
                }
                case RUNNING: {
                    durationDesired += this.runningTotalTimeMs;
                    break;
                }
                case PAUSED: {
                    durationDesired += this.pausedTotalTimeMs;
                    break;
                }
                case STOPPED: {
                    durationDesired += this.stoppedTotalTimeMs;
                    break;
                }
                case FAILED: {
                    durationDesired += this.failedTotalTimeMs;
                    break;
                }
                case DESTROYED: {
                    durationDesired += this.destroyedTotalTimeMs;
                    break;
                }
                case RESTARTING: {
                    durationDesired += this.restartingTotalTimeMs;
                }
            }
            long total = durationCurrent + this.unassignedTotalTimeMs + this.runningTotalTimeMs + this.pausedTotalTimeMs + this.failedTotalTimeMs + this.destroyedTotalTimeMs + this.restartingTotalTimeMs;
            return (double)total == 0.0 ? 0.0 : (double)durationDesired / (double)total;
        }
    }
}

