/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.purgatory;

import java.util.Optional;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.storage.internals.log.AsyncOffsetReadFutureHolder;
import org.apache.kafka.storage.internals.log.OffsetResultHolder;

public class ListOffsetsPartitionStatus {
    private final Optional<AsyncOffsetReadFutureHolder<OffsetResultHolder.FileRecordsOrError>> futureHolderOpt;
    private final Optional<Long> lastFetchableOffset;
    private final Optional<ApiException> maybeOffsetsError;
    private volatile Optional<ListOffsetsResponseData.ListOffsetsPartitionResponse> responseOpt;
    private volatile boolean completed = false;

    private ListOffsetsPartitionStatus(Optional<AsyncOffsetReadFutureHolder<OffsetResultHolder.FileRecordsOrError>> futureHolderOpt, Optional<Long> lastFetchableOffset, Optional<ApiException> maybeOffsetsError, Optional<ListOffsetsResponseData.ListOffsetsPartitionResponse> responseOpt) {
        this.futureHolderOpt = futureHolderOpt;
        this.lastFetchableOffset = lastFetchableOffset;
        this.maybeOffsetsError = maybeOffsetsError;
        this.responseOpt = responseOpt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<AsyncOffsetReadFutureHolder<OffsetResultHolder.FileRecordsOrError>> futureHolderOpt() {
        return this.futureHolderOpt;
    }

    public Optional<Long> lastFetchableOffset() {
        return this.lastFetchableOffset;
    }

    public Optional<ApiException> maybeOffsetsError() {
        return this.maybeOffsetsError;
    }

    public void responseOpt(Optional<ListOffsetsResponseData.ListOffsetsPartitionResponse> responseOpt) {
        this.responseOpt = responseOpt;
    }

    public Optional<ListOffsetsResponseData.ListOffsetsPartitionResponse> responseOpt() {
        return this.responseOpt;
    }

    public void completed(boolean completed) {
        this.completed = completed;
    }

    public boolean completed() {
        return this.completed;
    }

    public String toString() {
        return String.format("[responseOpt: %s, lastFetchableOffset: %s, maybeOffsetsError: %s, completed: %s]", this.responseOpt, this.lastFetchableOffset, this.maybeOffsetsError, this.completed);
    }

    public static class Builder {
        private Optional<AsyncOffsetReadFutureHolder<OffsetResultHolder.FileRecordsOrError>> futureHolderOpt = Optional.empty();
        private Optional<Long> lastFetchableOffset = Optional.empty();
        private Optional<ApiException> maybeOffsetsError = Optional.empty();
        private volatile Optional<ListOffsetsResponseData.ListOffsetsPartitionResponse> responseOpt = Optional.empty();

        public Builder futureHolderOpt(Optional<AsyncOffsetReadFutureHolder<OffsetResultHolder.FileRecordsOrError>> futureHolder) {
            this.futureHolderOpt = futureHolder;
            return this;
        }

        public Builder lastFetchableOffset(Optional<Long> lastFetchableOffset) {
            this.lastFetchableOffset = lastFetchableOffset;
            return this;
        }

        public Builder maybeOffsetsError(Optional<ApiException> maybeOffsetsError) {
            this.maybeOffsetsError = maybeOffsetsError;
            return this;
        }

        public Builder responseOpt(Optional<ListOffsetsResponseData.ListOffsetsPartitionResponse> responseOpt) {
            this.responseOpt = responseOpt;
            return this;
        }

        public ListOffsetsPartitionStatus build() {
            return new ListOffsetsPartitionStatus(this.futureHolderOpt, this.lastFetchableOffset, this.maybeOffsetsError, this.responseOpt);
        }
    }
}

