/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage.generated;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import java.util.ArrayList;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.server.log.remote.metadata.storage.generated.ProducerSnapshot;

public class ProducerSnapshotJsonConverter {
    public static ProducerSnapshot read(JsonNode _node, short _version) {
        ProducerSnapshot _object = new ProducerSnapshot();
        JsonNode _crcNode = _node.get("crc");
        if (_crcNode == null) {
            throw new RuntimeException("ProducerSnapshot: unable to locate field 'crc', which is mandatory in version " + _version);
        }
        _object.crc = MessageUtil.jsonNodeToUnsignedInt((JsonNode)_crcNode, (String)"ProducerSnapshot");
        JsonNode _producerEntriesNode = _node.get("producerEntries");
        if (_producerEntriesNode == null) {
            throw new RuntimeException("ProducerSnapshot: unable to locate field 'producerEntries', which is mandatory in version " + _version);
        }
        if (!_producerEntriesNode.isArray()) {
            throw new RuntimeException("ProducerSnapshot expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<ProducerSnapshot.ProducerEntry> _collection = new ArrayList<ProducerSnapshot.ProducerEntry>(_producerEntriesNode.size());
        _object.producerEntries = _collection;
        for (JsonNode _element : _producerEntriesNode) {
            _collection.add(ProducerEntryJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(ProducerSnapshot _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("crc", (JsonNode)new LongNode(_object.crc));
        ArrayNode _producerEntriesArray = new ArrayNode(JsonNodeFactory.instance);
        for (ProducerSnapshot.ProducerEntry _element : _object.producerEntries) {
            _producerEntriesArray.add(ProducerEntryJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("producerEntries", (JsonNode)_producerEntriesArray);
        return _node;
    }

    public static JsonNode write(ProducerSnapshot _object, short _version) {
        return ProducerSnapshotJsonConverter.write(_object, _version, true);
    }

    public static class ProducerEntryJsonConverter {
        public static ProducerSnapshot.ProducerEntry read(JsonNode _node, short _version) {
            ProducerSnapshot.ProducerEntry _object = new ProducerSnapshot.ProducerEntry();
            JsonNode _producerIdNode = _node.get("producerId");
            if (_producerIdNode == null) {
                throw new RuntimeException("ProducerEntry: unable to locate field 'producerId', which is mandatory in version " + _version);
            }
            _object.producerId = MessageUtil.jsonNodeToLong((JsonNode)_producerIdNode, (String)"ProducerEntry");
            JsonNode _epochNode = _node.get("epoch");
            if (_epochNode == null) {
                throw new RuntimeException("ProducerEntry: unable to locate field 'epoch', which is mandatory in version " + _version);
            }
            _object.epoch = MessageUtil.jsonNodeToShort((JsonNode)_epochNode, (String)"ProducerEntry");
            JsonNode _lastSequenceNode = _node.get("lastSequence");
            if (_lastSequenceNode == null) {
                throw new RuntimeException("ProducerEntry: unable to locate field 'lastSequence', which is mandatory in version " + _version);
            }
            _object.lastSequence = MessageUtil.jsonNodeToInt((JsonNode)_lastSequenceNode, (String)"ProducerEntry");
            JsonNode _lastOffsetNode = _node.get("lastOffset");
            if (_lastOffsetNode == null) {
                throw new RuntimeException("ProducerEntry: unable to locate field 'lastOffset', which is mandatory in version " + _version);
            }
            _object.lastOffset = MessageUtil.jsonNodeToLong((JsonNode)_lastOffsetNode, (String)"ProducerEntry");
            JsonNode _offsetDeltaNode = _node.get("offsetDelta");
            if (_offsetDeltaNode == null) {
                throw new RuntimeException("ProducerEntry: unable to locate field 'offsetDelta', which is mandatory in version " + _version);
            }
            _object.offsetDelta = MessageUtil.jsonNodeToInt((JsonNode)_offsetDeltaNode, (String)"ProducerEntry");
            JsonNode _timestampNode = _node.get("timestamp");
            if (_timestampNode == null) {
                throw new RuntimeException("ProducerEntry: unable to locate field 'timestamp', which is mandatory in version " + _version);
            }
            _object.timestamp = MessageUtil.jsonNodeToLong((JsonNode)_timestampNode, (String)"ProducerEntry");
            JsonNode _coordinatorEpochNode = _node.get("coordinatorEpoch");
            if (_coordinatorEpochNode == null) {
                throw new RuntimeException("ProducerEntry: unable to locate field 'coordinatorEpoch', which is mandatory in version " + _version);
            }
            _object.coordinatorEpoch = MessageUtil.jsonNodeToInt((JsonNode)_coordinatorEpochNode, (String)"ProducerEntry");
            JsonNode _currentTxnFirstOffsetNode = _node.get("currentTxnFirstOffset");
            if (_currentTxnFirstOffsetNode == null) {
                throw new RuntimeException("ProducerEntry: unable to locate field 'currentTxnFirstOffset', which is mandatory in version " + _version);
            }
            _object.currentTxnFirstOffset = MessageUtil.jsonNodeToLong((JsonNode)_currentTxnFirstOffsetNode, (String)"ProducerEntry");
            return _object;
        }

        public static JsonNode write(ProducerSnapshot.ProducerEntry _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("producerId", (JsonNode)new LongNode(_object.producerId));
            _node.set("epoch", (JsonNode)new ShortNode(_object.epoch));
            _node.set("lastSequence", (JsonNode)new IntNode(_object.lastSequence));
            _node.set("lastOffset", (JsonNode)new LongNode(_object.lastOffset));
            _node.set("offsetDelta", (JsonNode)new IntNode(_object.offsetDelta));
            _node.set("timestamp", (JsonNode)new LongNode(_object.timestamp));
            _node.set("coordinatorEpoch", (JsonNode)new IntNode(_object.coordinatorEpoch));
            _node.set("currentTxnFirstOffset", (JsonNode)new LongNode(_object.currentTxnFirstOffset));
            return _node;
        }

        public static JsonNode write(ProducerSnapshot.ProducerEntry _object, short _version) {
            return ProducerEntryJsonConverter.write(_object, _version, true);
        }
    }
}

