/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import jakarta.annotation.Nullable;
import java.awt.Image;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledTiledMapRenderer;

public final class ImageCache {
    private final boolean isDirty;
    private final StyledTiledMapRenderer.TileLoader imageFuture;
    private final Image image;

    ImageCache(Image image, StyledTiledMapRenderer.TileLoader imageFuture, boolean isDirty) {
        this.image = image;
        this.imageFuture = imageFuture;
        this.isDirty = isDirty;
        if (image == null && imageFuture == null) {
            throw new IllegalArgumentException("Either image or imageFuture must be non-null");
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public ImageCache becomeDirty() {
        if (this.isDirty) {
            return this;
        }
        return new ImageCache(this.image, this.imageFuture, true);
    }

    @Nullable
    public Image image() {
        return this.image;
    }

    @Nullable
    StyledTiledMapRenderer.TileLoader imageFuture() {
        return this.imageFuture;
    }
}

