/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3;

import java.util.Properties;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.access.GroupCacheAccess;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.commons.jcs3.log.LogManager;

public abstract class JCS {
    private static String configFilename;
    private static Properties configProps;
    private static CompositeCacheManager cacheMgr;

    public static void setConfigFilename(String configFilename) {
        JCS.configFilename = configFilename;
    }

    public static void setConfigProperties(Properties configProps) {
        JCS.configProps = configProps;
    }

    public static void setLogSystem(String logSystem) {
        LogManager.setLogSystem(logSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Class<JCS> clazz = JCS.class;
        synchronized (JCS.class) {
            if (cacheMgr != null && cacheMgr.isInitialized()) {
                cacheMgr.shutDown();
            }
            cacheMgr = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompositeCacheManager getCacheManager() throws CacheException {
        Class<JCS> clazz = JCS.class;
        synchronized (JCS.class) {
            if (cacheMgr == null || !cacheMgr.isInitialized()) {
                if (configProps != null) {
                    cacheMgr = CompositeCacheManager.getUnconfiguredInstance();
                    cacheMgr.configure(configProps);
                } else if (configFilename != null) {
                    cacheMgr = CompositeCacheManager.getUnconfiguredInstance();
                    cacheMgr.configure(configFilename);
                } else {
                    cacheMgr = CompositeCacheManager.getInstance();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return cacheMgr;
        }
    }

    public static <K, V> CacheAccess<K, V> getInstance(String region) throws CacheException {
        CompositeCache cache = JCS.getCacheManager().getCache(region);
        return new CacheAccess(cache);
    }

    public static <K, V> CacheAccess<K, V> getInstance(String region, ICompositeCacheAttributes icca) throws CacheException {
        CompositeCache cache = JCS.getCacheManager().getCache(region, icca);
        return new CacheAccess(cache);
    }

    public static <K, V> CacheAccess<K, V> getInstance(String region, ICompositeCacheAttributes icca, IElementAttributes eattr) throws CacheException {
        CompositeCache cache = JCS.getCacheManager().getCache(region, icca, eattr);
        return new CacheAccess(cache);
    }

    public static <K, V> GroupCacheAccess<K, V> getGroupCacheInstance(String region) throws CacheException {
        CompositeCache cache = JCS.getCacheManager().getCache(region);
        return new GroupCacheAccess(cache);
    }

    public static <K, V> GroupCacheAccess<K, V> getGroupCacheInstance(String region, ICompositeCacheAttributes icca) throws CacheException {
        CompositeCache cache = JCS.getCacheManager().getCache(region, icca);
        return new GroupCacheAccess(cache);
    }

    public static <K, V> GroupCacheAccess<K, V> getGroupCacheInstance(String region, ICompositeCacheAttributes icca, IElementAttributes eattr) throws CacheException {
        CompositeCache cache = JCS.getCacheManager().getCache(region, icca, eattr);
        return new GroupCacheAccess(cache);
    }
}

