/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import java.util.zip.CRC32;
import javajs.img.ImageEncoder;
import javajs.util.AU;

abstract class CRCEncoder
extends ImageEncoder {
    protected int startPos;
    protected int bytePos;
    private CRC32 crc;
    protected byte[] pngBytes;
    protected int dataLen;
    private byte[] int2 = new byte[2];
    private byte[] int4 = new byte[4];

    CRCEncoder() {
        this.pngBytes = new byte[250];
        this.crc = new CRC32();
    }

    protected void setData(byte[] byArray, int n) {
        this.pngBytes = byArray;
        this.dataLen = byArray.length;
        this.startPos = this.bytePos = n;
    }

    protected byte[] getBytes() {
        return this.dataLen == this.pngBytes.length ? this.pngBytes : AU.arrayCopyByte(this.pngBytes, this.dataLen);
    }

    protected void writeCRC() {
        this.crc.reset();
        this.crc.update(this.pngBytes, this.startPos, this.bytePos - this.startPos);
        this.writeInt4((int)this.crc.getValue());
    }

    protected void writeInt2(int n) {
        this.int2[0] = (byte)(n >> 8 & 0xFF);
        this.int2[1] = (byte)(n & 0xFF);
        this.writeBytes(this.int2);
    }

    protected void writeInt4(int n) {
        CRCEncoder.getInt4(n, this.int4);
        this.writeBytes(this.int4);
    }

    protected static void getInt4(int n, byte[] byArray) {
        byArray[0] = (byte)(n >> 24 & 0xFF);
        byArray[1] = (byte)(n >> 16 & 0xFF);
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
    }

    protected void writeByte(int n) {
        byte[] byArray = new byte[]{(byte)n};
        this.writeBytes(byArray);
    }

    protected void writeString(String string) {
        this.writeBytes(string.getBytes());
    }

    protected void writeBytes(byte[] byArray) {
        int n = this.bytePos + byArray.length;
        this.dataLen = Math.max(this.dataLen, n);
        if (n > this.pngBytes.length) {
            this.pngBytes = AU.arrayCopyByte(this.pngBytes, n + 16);
        }
        System.arraycopy(byArray, 0, this.pngBytes, this.bytePos, byArray.length);
        this.bytePos = n;
    }
}

