/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ExceptionUtilRt;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.gradle.api.Project;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.MessageBuilder;

@ApiStatus.Internal
public final class DefaultMessageBuilder
implements MessageBuilder {
    @Nullable
    private String myTitle = null;
    @Nullable
    private String myText = null;
    @Nullable
    private String myGroup = null;
    @Nullable
    private Exception myException = null;
    @Nullable
    private Message.Kind myKind = null;
    @Nullable
    private Message.FilePosition myFilePosition = null;
    @Nullable
    private Project myProject = null;
    private boolean myInternal = false;

    @Override
    @NotNull
    public MessageBuilder withTitle(String title) {
        this.myTitle = title;
        DefaultMessageBuilder defaultMessageBuilder = this;
        if (defaultMessageBuilder == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(0);
        }
        return defaultMessageBuilder;
    }

    @Override
    @NotNull
    public MessageBuilder withText(String text) {
        this.myText = text;
        DefaultMessageBuilder defaultMessageBuilder = this;
        if (defaultMessageBuilder == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(1);
        }
        return defaultMessageBuilder;
    }

    @Override
    @NotNull
    public MessageBuilder withKind(Message.Kind kind) {
        this.myKind = kind;
        DefaultMessageBuilder defaultMessageBuilder = this;
        if (defaultMessageBuilder == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(2);
        }
        return defaultMessageBuilder;
    }

    @Override
    @NotNull
    public MessageBuilder withGroup(String group) {
        this.myGroup = group;
        DefaultMessageBuilder defaultMessageBuilder = this;
        if (defaultMessageBuilder == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(3);
        }
        return defaultMessageBuilder;
    }

    @Override
    @NotNull
    public MessageBuilder withException(Exception e) {
        this.myException = e;
        DefaultMessageBuilder defaultMessageBuilder = this;
        if (defaultMessageBuilder == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(4);
        }
        return defaultMessageBuilder;
    }

    @Override
    @NotNull
    public MessageBuilder withLocation(Message.FilePosition filePosition) {
        this.myFilePosition = filePosition;
        DefaultMessageBuilder defaultMessageBuilder = this;
        if (defaultMessageBuilder == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(5);
        }
        return defaultMessageBuilder;
    }

    @Override
    @NotNull
    public MessageBuilder withLocation(String filePath, int line, int column) {
        MessageBuilder messageBuilder = this.withLocation(new Message.FilePosition(filePath, line, column));
        if (messageBuilder == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(6);
        }
        return messageBuilder;
    }

    @Override
    @NotNull
    public MessageBuilder withProject(Project project) {
        this.myProject = project;
        DefaultMessageBuilder defaultMessageBuilder = this;
        if (defaultMessageBuilder == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(7);
        }
        return defaultMessageBuilder;
    }

    @Override
    @NotNull
    public MessageBuilder withInternal(boolean isInternal) {
        this.myInternal = isInternal;
        DefaultMessageBuilder defaultMessageBuilder = this;
        if (defaultMessageBuilder == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(8);
        }
        return defaultMessageBuilder;
    }

    @Override
    @NotNull
    public Message build() {
        String title = this.buildTitle();
        String text = this.buildText();
        String group = this.buildGroup();
        Message.Kind kind = this.buildKind();
        Message.FilePosition filePosition = this.buildFilePosition();
        return new Message(title, text, group, kind, filePosition, this.myInternal);
    }

    @NotNull
    private String buildTitle() {
        String title = this.myTitle;
        if (title == null && this.myException != null) {
            title = DefaultMessageBuilder.getRootCauseExceptionMessage(this.myException);
        }
        if (title == null) {
            title = this.myText;
        }
        if (title == null) {
            assert (this.myGroup != null);
            title = this.myGroup;
        }
        if (this.myProject != null) {
            String projectDisplayName = this.myProject.getDisplayName();
            title = projectDisplayName + ": " + title;
        }
        String string = title;
        if (string == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private String buildText() {
        String text = this.myText;
        if (this.myException != null) {
            text = text == null ? DefaultMessageBuilder.buildExceptionStacktrace(this.myException) : text + "\n\n" + DefaultMessageBuilder.buildExceptionStacktrace(this.myException);
        }
        if (text == null) {
            text = this.myTitle;
        }
        if (text == null) {
            assert (this.myGroup != null);
            text = this.myGroup;
        }
        String string = text;
        if (string == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private String buildGroup() {
        assert (this.myGroup != null);
        String string = this.myGroup;
        if (string == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private Message.Kind buildKind() {
        Message.Kind kind = this.myKind;
        if (kind == null) {
            kind = Message.Kind.INFO;
        }
        Message.Kind kind2 = kind;
        if (kind2 == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(12);
        }
        return kind2;
    }

    @Nullable
    private Message.FilePosition buildFilePosition() {
        Message.FilePosition filePosition = this.myFilePosition;
        if (filePosition == null && this.myProject != null) {
            String buildScriptPath = this.myProject.getBuildFile().getPath();
            filePosition = new Message.FilePosition(buildScriptPath, 0, 0);
        }
        return filePosition;
    }

    @NotNull
    private static String buildExceptionStacktrace(@NotNull Throwable exception) {
        if (exception == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(13);
        }
        if (exception.getStackTrace().length == 0) {
            return DefaultMessageBuilder.getRootCauseExceptionMessage(exception);
        }
        return DefaultMessageBuilder.getExceptionStacktrace(exception);
    }

    @Nullable
    private static String getExceptionOriginalReason(@NotNull Throwable exception) {
        String originalReason;
        ExternalSystemException esException;
        if (exception == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(14);
        }
        if ((esException = (ExternalSystemException)ExceptionUtilRt.findCause((Throwable)exception, ExternalSystemException.class)) != null && esException != exception && !StringUtilRt.isEmptyOrSpaces((CharSequence)(originalReason = esException.getOriginalReason()))) {
            return originalReason;
        }
        return null;
    }

    @NotNull
    private static String getExceptionStacktrace(@NotNull Throwable exception) {
        if (exception == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(15);
        }
        StringWriter sw = new StringWriter();
        exception.printStackTrace(new PrintWriter(sw));
        String originalReason = DefaultMessageBuilder.getExceptionOriginalReason(exception);
        if (originalReason != null) {
            sw.append("\nCaused by: ").append(originalReason);
        }
        String string = sw.toString();
        if (string == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String getRootCauseExceptionMessage(@NotNull Throwable exception) {
        if (exception == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(17);
        }
        Throwable rootCauseException = exception;
        while (rootCauseException.getCause() != null) {
            rootCauseException = rootCauseException.getCause();
        }
        String message = rootCauseException.getMessage();
        if (message == null) {
            message = exception.getMessage();
        }
        if (message == null) {
            message = exception.getClass().getName();
        }
        String string = message;
        if (string == null) {
            DefaultMessageBuilder.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/tooling/DefaultMessageBuilder";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "withTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withKind";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withGroup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withException";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withLocation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withInternal";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTitle";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGroup";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildKind";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/DefaultMessageBuilder";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionStacktrace";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootCauseExceptionMessage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildExceptionStacktrace";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionOriginalReason";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionStacktrace";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRootCauseExceptionMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

