/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build.output;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.build.output.JavacOutputParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0\fH\u0016J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00110\fH\u0002\u00a8\u0006\u0014\u00b2\u0006\n\u0010\u0015\u001a\u00020\u0016X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/plugins/gradle/execution/build/output/GradleCompilationReportParser;", "Lcom/intellij/build/output/BuildOutputParser;", "<init>", "()V", "parse", "", "line", "", "Lcom/intellij/openapi/util/NlsSafe;", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "drainCompilationErrors", "", "errorConsumer", "", "Companion", "ErrorHolder", "intellij.gradle", "parser", "Lcom/intellij/build/output/JavacOutputParser;"})
public final class GradleCompilationReportParser
implements BuildOutputParser {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final String GROUPED_COMPILATION_ERROR = "> Compilation failed; see the compiler output below.";
    @NotNull
    private static final String ERROR_CURSOR = "^";
    @NotNull
    private static final String MESSAGE_GROUP_TERMINATOR = "* Try:";
    @NotNull
    private static final Regex ERROR_GROUP_TERMINATOR = new Regex("(\\d+ error(s)?)");

    public boolean parse(@NotNull String line, @NotNull BuildOutputInstantReader reader, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        if (!Intrinsics.areEqual((Object)GROUPED_COMPILATION_ERROR, (Object)line)) {
            return false;
        }
        Lazy parser$delegate = LazyKt.lazy(GradleCompilationReportParser::parse$lambda$0);
        Ref.BooleanRef parsed = new Ref.BooleanRef();
        this.drainCompilationErrors(reader, arg_0 -> GradleCompilationReportParser.parse$lambda$2(parsed, reader, parser$delegate, messageConsumer, arg_0));
        return parsed.element;
    }

    private final void drainCompilationErrors(BuildOutputInstantReader reader, Consumer<List<String>> errorConsumer) {
        List buffer = new ArrayList();
        while (true) {
            String line = reader.readLine();
            if (line == null || Intrinsics.areEqual((Object)line, (Object)MESSAGE_GROUP_TERMINATOR) || ERROR_GROUP_TERMINATOR.matches((CharSequence)((Object)StringsKt.trim((CharSequence)line)).toString())) {
                errorConsumer.accept(buffer);
                return;
            }
            if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)line)).toString(), (Object)ERROR_CURSOR)) {
                buffer.add(line);
                errorConsumer.accept(buffer);
                buffer.clear();
                continue;
            }
            buffer.add(line);
        }
    }

    private static final JavacOutputParser parse$lambda$0() {
        return new JavacOutputParser();
    }

    private static final JavacOutputParser parse$lambda$1(Lazy<JavacOutputParser> $parser$delegate) {
        Lazy<JavacOutputParser> lazy = $parser$delegate;
        return (JavacOutputParser)lazy.getValue();
    }

    private static final void parse$lambda$2(Ref.BooleanRef $parsed, BuildOutputInstantReader $reader, Lazy $parser$delegate, Consumer $messageConsumer, List error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        $parsed.element = true;
        if (!((Collection)error).isEmpty()) {
            JavacOutputParser javacOutputParser = GradleCompilationReportParser.parse$lambda$1((Lazy<JavacOutputParser>)$parser$delegate);
            String string = (String)CollectionsKt.first((List)error);
            Object object = $reader.getParentEventId();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getParentEventId(...)");
            javacOutputParser.parse(string, (BuildOutputInstantReader)new ErrorHolder(error, object), arg_0 -> GradleCompilationReportParser.parse$lambda$2$1(arg_0 -> GradleCompilationReportParser.parse$lambda$2$0($messageConsumer, arg_0), arg_0));
        }
    }

    private static final Unit parse$lambda$2$0(Consumer $messageConsumer, BuildEvent event) {
        Intrinsics.checkNotNull((Object)event);
        $messageConsumer.accept(event);
        return Unit.INSTANCE;
    }

    private static final void parse$lambda$2$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gradle/execution/build/output/GradleCompilationReportParser$Companion;", "", "<init>", "()V", "GROUPED_COMPILATION_ERROR", "", "ERROR_CURSOR", "MESSAGE_GROUP_TERMINATOR", "ERROR_GROUP_TERMINATOR", "Lkotlin/text/Regex;", "intellij.gradle"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0006H\u0016J\u000f\u0010\u0010\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/execution/build/output/GradleCompilationReportParser$ErrorHolder;", "Lcom/intellij/build/output/BuildOutputInstantReader;", "errors", "", "", "parentId", "", "<init>", "(Ljava/util/List;Ljava/lang/Object;)V", "getErrors", "()Ljava/util/List;", "getParentId", "()Ljava/lang/Object;", "index", "", "getParentEventId", "readLine", "Lcom/intellij/openapi/util/NlsSafe;", "pushBack", "", "numberOfLines", "intellij.gradle"})
    private static final class ErrorHolder
    implements BuildOutputInstantReader {
        @NotNull
        private final List<String> errors;
        @NotNull
        private final Object parentId;
        private int index;

        public ErrorHolder(@NotNull List<String> errors, @NotNull Object parentId) {
            Intrinsics.checkNotNullParameter(errors, (String)"errors");
            Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
            this.errors = errors;
            this.parentId = parentId;
        }

        @NotNull
        public final List<String> getErrors() {
            return this.errors;
        }

        @NotNull
        public final Object getParentId() {
            return this.parentId;
        }

        @NotNull
        public Object getParentEventId() {
            return this.parentId;
        }

        @Nullable
        public String readLine() {
            if (this.index + 1 < this.errors.size()) {
                int n = this.index;
                this.index = n + 1;
                return this.errors.get(this.index);
            }
            return null;
        }

        public void pushBack() {
            int n = this.index;
            this.index = n + -1;
        }

        public void pushBack(int numberOfLines) {
            this.index -= numberOfLines;
        }
    }
}

