/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.javaee.ExternalResourceManagerExBaseKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.io.URLUtil;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0000\u00a2\u0006\u0004\b\b\u0010\u000bJ\u0006\u0010\r\u001a\u00020\u0003J\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/javaee/ExternalResource;", "", "file", "", "aClass", "Ljava/lang/Class;", "classLoader", "Ljava/lang/ClassLoader;", "<init>", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/ClassLoader;)V", "baseResource", "(Ljava/lang/String;Lcom/intellij/javaee/ExternalResource;)V", "resolvedResourcePath", "directoryName", "getResourceUrl", "equals", "", "o", "hashCode", "", "toString", "intellij.xml.psi.impl"})
@ApiStatus.Internal
public final class ExternalResource {
    @NotNull
    private final String file;
    @Nullable
    private final ClassLoader classLoader;
    @Nullable
    private final Class<?> aClass;
    @Nullable
    private volatile String resolvedResourcePath;

    public ExternalResource(@NotNull String file, @Nullable Class<?> aClass, @Nullable ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.classLoader = classLoader;
        this.aClass = aClass;
    }

    public ExternalResource(@NotNull String file, @NotNull ExternalResource baseResource) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)baseResource, (String)"baseResource");
        this(file, baseResource.aClass, baseResource.classLoader);
    }

    @NotNull
    public final String directoryName() {
        String string;
        int i = StringsKt.lastIndexOf$default((CharSequence)this.file, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (i > 0) {
            String string2 = this.file.substring(0, i);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = this.file;
        }
        return string;
    }

    @Nullable
    public final String getResourceUrl() {
        String path;
        URL resource;
        String string = this.resolvedResourcePath;
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        if (this.aClass == null) {
            ClassLoader classLoader = this.classLoader;
            Intrinsics.checkNotNull((Object)classLoader);
            v1 = classLoader.getResource(this.file);
        } else {
            v1 = resource = this.aClass.getResource(this.file);
        }
        if (resource == null) {
            String message = "Cannot find standard resource. filename:" + this.file + " class=" + this.aClass + ", classLoader:" + this.classLoader;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ExternalResourceManagerExBaseKt.access$getLOG$p().warn(message);
            } else {
                ExternalResourceManagerExBaseKt.access$getLOG$p().warn(message);
            }
            this.resolvedResourcePath = null;
            return null;
        }
        String string2 = resource.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = URLUtil.unescapePercentSequences((String)StringsKt.replace$default((String)string2, (char)'\\', (char)'/', (boolean)false, (int)4, null));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"unescapePercentSequences(...)");
        this.resolvedResourcePath = path = string3;
        return path;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Intrinsics.areEqual(this.getClass(), o.getClass())) {
            return false;
        }
        ExternalResource resource = (ExternalResource)o;
        return Intrinsics.areEqual((Object)this.classLoader, (Object)resource.classLoader) && Intrinsics.areEqual(this.aClass, resource.aClass) && Intrinsics.areEqual((Object)this.file, (Object)resource.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @NotNull
    public String toString() {
        return this.file + " for " + this.classLoader;
    }
}

