/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.FileCollectionFactory;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.module.JpsModule;

@ApiStatus.Internal
public abstract class JVMModuleBuildTarget<R extends BuildRootDescriptor>
extends ModuleBasedTarget<R> {
    public JVMModuleBuildTarget(@NotNull ModuleBasedBuildTargetType<? extends JVMModuleBuildTarget<R>> targetType, JpsModule module) {
        if (targetType == null) {
            JVMModuleBuildTarget.$$$reportNull$$$0(0);
        }
        super(targetType, module);
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.getModule().getName();
        if (string == null) {
            JVMModuleBuildTarget.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected final Set<Path> computeRootExcludes(Path root, ModuleExcludeIndex index) {
        Collection<Path> moduleExcludes = index.getModuleExcludes(this.getModule());
        if (moduleExcludes.isEmpty()) {
            Set<Path> set = Collections.emptySet();
            if (set == null) {
                JVMModuleBuildTarget.$$$reportNull$$$0(2);
            }
            return set;
        }
        Set excludes = FileCollectionFactory.createCanonicalPathSet();
        for (Path excluded : moduleExcludes) {
            if (!FileUtil.isAncestor((String)root.toString(), (String)excluded.toString(), (boolean)true)) continue;
            excludes.add(excluded);
        }
        Set set = excludes.isEmpty() ? Collections.emptySet() : excludes;
        if (set == null) {
            JVMModuleBuildTarget.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    public R findRootDescriptor(@NotNull String rootId, @NotNull BuildRootIndex rootIndex) {
        List descriptors;
        if (rootId == null) {
            JVMModuleBuildTarget.$$$reportNull$$$0(4);
        }
        if (rootIndex == null) {
            JVMModuleBuildTarget.$$$reportNull$$$0(5);
        }
        return (R)((descriptors = rootIndex.getRootDescriptors(new File(rootId), List.of(this.getTargetType()), null)).isEmpty() ? null : (BuildRootDescriptor)descriptors.get(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/JVMModuleBuildTarget";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/JVMModuleBuildTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootExcludes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findRootDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

