/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.DecHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class SequenceStatement
extends Statement {
    private SequenceStatement() {
        super(Statement.StatementType.SEQUENCE);
    }

    public SequenceStatement(List<? extends Statement> lst) {
        this();
        this.lastBasicType = lst.get(lst.size() - 1).getLastBasicType();
        for (Statement statement : lst) {
            this.stats.addWithKey(statement, statement.id);
        }
        this.first = (Statement)this.stats.get(0);
    }

    private SequenceStatement(Statement head, Statement tail) {
        this(Arrays.asList(head, tail));
        StatEdge edge;
        List<StatEdge> lstSuccs = tail.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
        if (!lstSuccs.isEmpty() && (edge = lstSuccs.get(0)).getType() == StatEdge.EdgeType.REGULAR && edge.getDestination() != head) {
            this.post = edge.getDestination();
        }
    }

    public static Statement isHead2Block(Statement head) {
        Statement stat;
        if (head.getLastBasicType() != Statement.StatementType.GENERAL) {
            return null;
        }
        StatEdge edge = null;
        List<StatEdge> lstSuccs = head.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
        if (!lstSuccs.isEmpty()) {
            edge = lstSuccs.get(0);
        }
        if (edge != null && edge.getType() == StatEdge.EdgeType.REGULAR && (stat = edge.getDestination()) != head && stat.getPredecessorEdges(StatEdge.EdgeType.REGULAR).size() == 1 && !stat.isMonitorEnter() && stat.getLastBasicType() == Statement.StatementType.GENERAL && DecHelper.checkStatementExceptions(Arrays.asList(head, stat))) {
            return new SequenceStatement(head, stat);
        }
        return null;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        TextBuffer buf = new TextBuffer();
        boolean isLabeled = this.isLabeled();
        buf.append(ExprProcessor.listToJava(this.varDefinitions, indent, tracer));
        if (isLabeled) {
            buf.appendIndent(indent++).append("label").append(Integer.toString(this.id)).append(": {").appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
        boolean notEmpty = false;
        for (int i = 0; i < this.stats.size(); ++i) {
            Statement stat = (Statement)this.stats.get(i);
            if (i > 0 && notEmpty) {
                buf.appendLineSeparator();
                tracer.incrementCurrentSourceLine();
            }
            TextBuffer str = ExprProcessor.jmpWrapper(stat, indent, false, tracer);
            buf.append(str);
            notEmpty = !str.containsOnlyWhitespaces();
        }
        if (isLabeled) {
            buf.appendIndent(indent - 1).append("}").appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
        return buf;
    }

    @Override
    public Statement getSimpleCopy() {
        return new SequenceStatement();
    }
}

