/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.component.internal;

import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ModelInstantiationException;
import org.gradle.platform.base.component.internal.AbstractComponentSpec;
import org.gradle.platform.base.internal.ComponentSpecIdentifier;

public class DefaultComponentSpec
extends AbstractComponentSpec {
    private static final ThreadLocal<ComponentInfo> NEXT_COMPONENT_INFO = new ThreadLocal();

    public static <T extends DefaultComponentSpec> T create(Class<? extends ComponentSpec> publicType, Class<T> implementationType, ComponentSpecIdentifier identifier, MutableModelNode modelNode) {
        NEXT_COMPONENT_INFO.set(new ComponentInfo(identifier, modelNode, publicType));
        try {
            DefaultComponentSpec defaultComponentSpec = (DefaultComponentSpec)DirectInstantiator.INSTANCE.newInstance(implementationType, new Object[0]);
            return (T)defaultComponentSpec;
        }
        catch (ObjectInstantiationException e) {
            throw new ModelInstantiationException(String.format("Could not create component of type %s", publicType.getSimpleName()), e.getCause());
        }
        finally {
            NEXT_COMPONENT_INFO.set(null);
        }
    }

    protected static ComponentInfo getInfo() {
        return NEXT_COMPONENT_INFO.get();
    }

    public DefaultComponentSpec() {
        this(DefaultComponentSpec.getInfo());
    }

    public DefaultComponentSpec(ComponentInfo info) {
        super(DefaultComponentSpec.validate((ComponentInfo)info).componentIdentifier, info.publicType);
    }

    private static ComponentInfo validate(ComponentInfo info) {
        if (info == null) {
            throw new ModelInstantiationException("Direct instantiation of a BaseComponentSpec is not permitted. Use a @ComponentType rule instead.");
        }
        return info;
    }

    protected static class ComponentInfo {
        public final ComponentSpecIdentifier componentIdentifier;
        public final MutableModelNode modelNode;
        public final Class<?> publicType;

        private ComponentInfo(ComponentSpecIdentifier componentIdentifier, MutableModelNode modelNode, Class<?> publicType) {
            this.componentIdentifier = componentIdentifier;
            this.modelNode = modelNode;
            this.publicType = publicType;
        }
    }
}

