/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import org.jspecify.annotations.Nullable;

public enum PropertyAccessorType {
    IS_GETTER(2){

        @Override
        public Class<?> propertyTypeFor(Method method) {
            return method.getReturnType();
        }

        @Override
        public Type genericPropertyTypeFor(Method method) {
            return method.getGenericReturnType();
        }
    }
    ,
    GET_GETTER(3){

        @Override
        public Class<?> propertyTypeFor(Method method) {
            return method.getReturnType();
        }

        @Override
        public Type genericPropertyTypeFor(Method method) {
            return method.getGenericReturnType();
        }
    }
    ,
    SETTER(3){

        @Override
        public Class<?> propertyTypeFor(Method method) {
            this.requireSingleParam(method);
            return method.getParameterTypes()[0];
        }

        @Override
        public Type genericPropertyTypeFor(Method method) {
            this.requireSingleParam(method);
            return method.getGenericParameterTypes()[0];
        }

        private void requireSingleParam(Method method) {
            if (!3.takesSingleParameter(method)) {
                throw new IllegalArgumentException("Setter method should take one parameter: " + method);
            }
        }
    };

    private final int prefixLength;

    private PropertyAccessorType(int prefixLength) {
        this.prefixLength = prefixLength;
    }

    public String propertyNameFor(Method method) {
        return this.propertyNameFor(method.getName());
    }

    public String propertyNameFor(String methodName) {
        String methodNamePrefixRemoved = methodName.substring(this.prefixLength);
        return Introspector.decapitalize(methodNamePrefixRemoved);
    }

    public abstract Class<?> propertyTypeFor(Method var1);

    public abstract Type genericPropertyTypeFor(Method var1);

    public static @Nullable PropertyAccessorType of(Method method) {
        if (PropertyAccessorType.isStatic(method)) {
            return null;
        }
        String methodName = method.getName();
        if (!PropertyAccessorType.hasVoidReturnType(method) && PropertyAccessorType.takesNoParameter(method)) {
            if (PropertyAccessorType.isGetGetterName(methodName)) {
                return GET_GETTER;
            }
            if (PropertyAccessorType.isIsGetterName(methodName)) {
                if (method.getReturnType().equals(Boolean.TYPE)) {
                    return IS_GETTER;
                }
                if (method.getReturnType().equals(Boolean.class)) {
                    return IS_GETTER;
                }
            }
        }
        if (PropertyAccessorType.takesSingleParameter(method) && PropertyAccessorType.isSetterName(methodName)) {
            return SETTER;
        }
        return null;
    }

    public static PropertyAccessorType fromName(String methodName) {
        if (PropertyAccessorType.isGetGetterName(methodName)) {
            return GET_GETTER;
        }
        if (PropertyAccessorType.isIsGetterName(methodName)) {
            return IS_GETTER;
        }
        if (PropertyAccessorType.isSetterName(methodName)) {
            return SETTER;
        }
        return null;
    }

    private static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static boolean hasVoidReturnType(Method method) {
        return Void.TYPE.equals(method.getReturnType());
    }

    public static boolean takesNoParameter(Method method) {
        return method.getParameterTypes().length == 0;
    }

    public static boolean takesSingleParameter(Method method) {
        return method.getParameterCount() == 1;
    }

    private static boolean isGetGetterName(String methodName) {
        return methodName.startsWith("get") && methodName.length() > 3;
    }

    private static boolean isIsGetterName(String methodName) {
        return methodName.startsWith("is") && methodName.length() > 2;
    }

    private static boolean isSetterName(String methodName) {
        return methodName.startsWith("set") && methodName.length() > 3;
    }

    public static boolean hasGetter(Collection<PropertyAccessorType> accessorTypes) {
        return accessorTypes.contains((Object)GET_GETTER) || accessorTypes.contains((Object)IS_GETTER);
    }

    public static boolean hasSetter(Collection<PropertyAccessorType> accessorTypes) {
        return accessorTypes.contains((Object)SETTER);
    }
}

