/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth.data;

import tim.prune.function.filesleuth.SearchResult;
import tim.prune.function.filesleuth.data.DateRange;
import tim.prune.function.filesleuth.data.LocationFilter;
import tim.prune.function.filesleuth.data.TrackFile;

public class Filter {
    private final String _filterString;
    private final DateRange _dateRange;
    private final LocationFilter _locationFilter;
    public static final Filter EMPTY_FILTER = new Filter(null, null, null);

    public Filter(String string) {
        this(string, null, null);
    }

    public Filter(String string, String string2, LocationFilter locationFilter) {
        this._filterString = string == null ? "" : string.trim().toLowerCase();
        this._dateRange = DateRange.parseString(string2);
        this._locationFilter = locationFilter;
    }

    public String getString() {
        return this._filterString;
    }

    public static Comparison compare(Filter filter, Filter filter2) {
        boolean bl;
        boolean bl2 = filter == null || filter.isEmpty();
        boolean bl3 = bl = filter2 == null || filter2.isEmpty();
        if (bl2) {
            return bl ? Comparison.SAME : Comparison.NARROWER;
        }
        if (bl) {
            return Comparison.WIDER;
        }
        Comparison comparison = Filter.compareTextFilters(filter, filter2);
        Comparison comparison2 = Filter.compareDateFilters(filter, filter2);
        Comparison comparison3 = Filter.compareLocationFilters(filter, filter2);
        return Filter.combineComparisons(Filter.combineComparisons(comparison, comparison2), comparison3);
    }

    private static Comparison combineComparisons(Comparison comparison, Comparison comparison2) {
        if (comparison == Comparison.SAME || comparison == comparison2) {
            return comparison2;
        }
        if (comparison2 == Comparison.SAME) {
            return comparison;
        }
        return Comparison.DIFFERENT;
    }

    private static Comparison compareTextFilters(Filter filter, Filter filter2) {
        boolean bl;
        boolean bl2 = !filter.hasTextFilter();
        boolean bl3 = bl = !filter2.hasTextFilter();
        if (bl2 && !bl) {
            return Comparison.NARROWER;
        }
        if (!bl2 && bl) {
            return Comparison.WIDER;
        }
        String string = filter.getString();
        String string2 = filter2.getString();
        if (string2.equals(string)) {
            return Comparison.SAME;
        }
        if (string.contains(string2)) {
            return Comparison.WIDER;
        }
        if (string2.contains(string)) {
            return Comparison.NARROWER;
        }
        return Comparison.DIFFERENT;
    }

    private static Comparison compareDateFilters(Filter filter, Filter filter2) {
        DateRange dateRange;
        boolean bl;
        boolean bl2 = !filter.hasDateFilter();
        boolean bl3 = bl = !filter2.hasDateFilter();
        if (bl2 && bl) {
            return Comparison.SAME;
        }
        if (bl2 && !bl) {
            return Comparison.NARROWER;
        }
        if (!bl2 && bl) {
            return Comparison.WIDER;
        }
        DateRange dateRange2 = filter.getDateFilter();
        if (dateRange2.equals(dateRange = filter2.getDateFilter())) {
            return Comparison.SAME;
        }
        if (dateRange2.includes(dateRange)) {
            return Comparison.NARROWER;
        }
        if (dateRange.includes(dateRange2)) {
            return Comparison.WIDER;
        }
        return Comparison.DIFFERENT;
    }

    private static Comparison compareLocationFilters(Filter filter, Filter filter2) {
        boolean bl;
        boolean bl2 = !filter.hasLocationFilter();
        boolean bl3 = bl = !filter2.hasLocationFilter();
        if (bl2 && bl) {
            return Comparison.SAME;
        }
        if (bl2 && !bl) {
            return Comparison.NARROWER;
        }
        if (!bl2 && bl) {
            return Comparison.WIDER;
        }
        if (filter._locationFilter.equals(filter2._locationFilter)) {
            return Comparison.SAME;
        }
        return Comparison.DIFFERENT;
    }

    private boolean isEmpty() {
        return !this.hasTextFilter() && !this.hasDateFilter() && !this.hasLocationFilter();
    }

    private boolean hasTextFilter() {
        return !this._filterString.isEmpty();
    }

    private boolean hasDateFilter() {
        return this._dateRange != null && this._dateRange.isValid();
    }

    public DateRange getDateFilter() {
        return this._dateRange == null ? DateRange.EMPTY_RANGE : this._dateRange;
    }

    public boolean hasLocationFilter() {
        return this._locationFilter != null;
    }

    public LocationFilter getLocationFilter() {
        return this._locationFilter;
    }

    public void apply(SearchResult searchResult) {
        TrackFile trackFile = searchResult.getTrackFile();
        boolean bl = true;
        if (this.hasTextFilter()) {
            bl = trackFile.matchesStringFilter(this._filterString, searchResult) || trackFile.matchesFilename(this._filterString);
        } else {
            searchResult.setContents(trackFile.getNameOrDescription());
        }
        if (this.hasDateFilter() && trackFile.hasContents()) {
            boolean bl2 = bl = bl && trackFile.matchesDateFilter(this._dateRange);
        }
        if (this.hasLocationFilter() && trackFile.hasContents()) {
            bl = bl && trackFile.matchesLocationFilter(this._locationFilter);
        }
        searchResult.setIsMatch(bl);
    }

    public static enum Comparison {
        SAME,
        DIFFERENT,
        WIDER,
        NARROWER;

    }
}

