#@local M6, L6, M4, L4, M8, L8, L, A, M3, L3, M5, L5;
##############################################################################
##
#W  matrix.tst                   Utils Package                    
##
#Y  Copyright (C) 2015-2023, The GAP Group 
##  

gap> ReadPackage( "utils", "tst/loadall.g" );;
gap> UtilsLoadingComplete;
true

## SubSection 9.1.1
gap> M6 := [ [1,2,0,0,0,0], [3,4,0,0,0,0], [5,6,0,0,0,0],                       
>            [0,0,9,0,0,0], [0,0,0,1,2,3], [0,0,0,4,5,6] ];;
gap> Display( M6 );
[ [  1,  2,  0,  0,  0,  0 ],
  [  3,  4,  0,  0,  0,  0 ],
  [  5,  6,  0,  0,  0,  0 ],
  [  0,  0,  9,  0,  0,  0 ],
  [  0,  0,  0,  1,  2,  3 ],
  [  0,  0,  0,  4,  5,  6 ] ]
gap> L6 := DirectSumDecompositionMatrices( M6 );
[ [ [ [ 1, 2 ], [ 3, 4 ], [ 5, 6 ] ], [ [ 9 ] ], [ [ 1, 2, 3 ], [ 4, 5, 6 ] ] 
     ] ]

gap> M4 := [ [0,3,0,0], [0,0,0,0], [0,0,0,0], [0,0,4,0] ];;
gap> Display( M4 );
[ [  0,  3,  0,  0 ],
  [  0,  0,  0,  0 ],
  [  0,  0,  0,  0 ],
  [  0,  0,  4,  0 ] ]
gap> L4 := DirectSumDecompositionMatrices( M4 );
[ [ [ [ 0, 3 ] ], [ [ 0, 0 ], [ 0, 0 ], [ 4, 0 ] ] ], 
  [ [ [ 0, 3 ], [ 0, 0 ] ], [ [ 0, 0 ], [ 4, 0 ] ] ], 
  [ [ [ 0, 3 ], [ 0, 0 ], [ 0, 0 ] ], [ [ 4, 0 ] ] ] ]
gap> for L in L4 do 
>        A := DirectSumMat( L );; 
>        if ( A = M4 ) then Print( "yes, A = M4\n" ); fi; 
>    od;
yes, A = M4
yes, A = M4
yes, A = M4

gap> M8 := DirectSumMat( M4, M4 );; 
gap> Display( M8 );
[ [  0,  3,  0,  0,  0,  0,  0,  0 ],
  [  0,  0,  0,  0,  0,  0,  0,  0 ],
  [  0,  0,  0,  0,  0,  0,  0,  0 ],
  [  0,  0,  4,  0,  0,  0,  0,  0 ],
  [  0,  0,  0,  0,  0,  3,  0,  0 ],
  [  0,  0,  0,  0,  0,  0,  0,  0 ],
  [  0,  0,  0,  0,  0,  0,  0,  0 ],
  [  0,  0,  0,  0,  0,  0,  4,  0 ] ]
gap> L8 := DirectSumDecompositionMatrices( M8 );;
gap> Length( L8 ); 
16

gap> M3 := [ [0,0,0,7,0,0,0], [0,0,0,0,8,0,0], [0,0,0,0,0,9,0] ];;
gap> Display( M3 );  
[ [  0,  0,  0,  7,  0,  0,  0 ],
  [  0,  0,  0,  0,  8,  0,  0 ],
  [  0,  0,  0,  0,  0,  9,  0 ] ]
gap> L3 := DirectSumDecompositionMatrices( M3 );                  
[ [ [ [ 0, 0, 0, 7 ] ], [ [ 8 ] ], [ [ 9, 0 ] ] ] ]

gap> M5 := [ [1,2,0,0,0], [3,4,0,0,0], [0,0,0,0,0],
>            [0,0,0,6,7], [0,0,0,8,9] ];;
gap> Display(M5);
[ [  1,  2,  0,  0,  0 ],
  [  3,  4,  0,  0,  0 ],
  [  0,  0,  0,  0,  0 ],
  [  0,  0,  0,  6,  7 ],
  [  0,  0,  0,  8,  9 ] ]
gap> L5 := DirectSumDecompositionMatrices( M5 ); 
[ [ [ [ 1, 2 ], [ 3, 4 ] ], [ [ 0 ] ], [ [ 6, 7 ], [ 8, 9 ] ] ] ]

#############################################################################
##
#E  matrix.tst  . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
