/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IElementDOMHandler;
import org.freeplane.core.io.IElementHandler;
import org.freeplane.core.io.IExtensionElementWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.MapExtensions;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.n3.nanoxml.XMLElement;

public abstract class PersistentNodeHook {
    public PersistentNodeHook() {
        ModeController modeController;
        Class<? extends IExtension> extensionClass = this.getExtensionClass();
        if (this.getHookAnnotation().onceForMap()) {
            MapExtensions.registerMapExtension(extensionClass);
        }
        if ((modeController = Controller.getCurrentModeController()).supportsHookActions()) {
            this.registerActions();
        }
        MapController mapController = modeController.getMapController();
        mapController.getReadManager().addElementHandler("hook", this.createXmlReader());
        IExtensionElementWriter xmlWriter = this.createXmlWriter();
        if (xmlWriter != null) {
            mapController.getWriteManager().addExtensionElementWriter(extensionClass, xmlWriter);
        }
        if (this instanceof IExtension) {
            modeController.addExtension(this.getClass(), (IExtension)((Object)this));
        }
    }

    protected void registerActions() {
        Class<? extends IExtension> extensionClass = this.getExtensionClass();
        if (extensionClass.isEnum()) {
            Class<? extends IExtension> enumClass = extensionClass;
            EnumSet<? extends IExtension> all = EnumSet.allOf(enumClass);
            for (Enum enum_ : all) {
                this.registerAction(new SelectableEnumAction(this.getClass().getSimpleName() + "Action", enum_));
            }
            this.registerAction(new SelectableEnumAction(this.getClass().getSimpleName() + "Action", null));
        } else {
            HookAction selectableHookAction = this.createHookAction();
            if (selectableHookAction != null) {
                this.registerAction(selectableHookAction);
            }
        }
    }

    protected void add(NodeModel node, IExtension extension) {
        assert (this.getExtensionClass().equals(extension.getClass()));
        node.addExtension(extension);
    }

    protected IExtension createExtension(NodeModel node) {
        return this.createExtension(node, null);
    }

    protected IExtension createExtension(NodeModel node, XMLElement element) {
        try {
            Class<? extends IExtension> extensionClass = this.getExtensionClass();
            if (extensionClass.isEnum()) {
                String value = element.getAttribute("VALUE");
                Method factory = extensionClass.getMethod("valueOf", String.class);
                return (IExtension)factory.invoke(null, value);
            }
            return extensionClass.newInstance();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected HookAction createHookAction() {
        return new SelectableHookAction(this.getClass().getSimpleName() + "Action");
    }

    protected IElementHandler createXmlReader() {
        return new XmlReader();
    }

    protected IExtensionElementWriter createXmlWriter() {
        return new XmlWriter();
    }

    protected Class<? extends IExtension> getExtensionClass() {
        return this.getClass();
    }

    private NodeHookDescriptor getHookAnnotation() {
        NodeHookDescriptor annotation = this.getClass().getAnnotation(NodeHookDescriptor.class);
        return annotation;
    }

    protected String getHookName() {
        return this.getHookAnnotation().hookName();
    }

    public IExtension getMapHook(MapModel map) {
        NodeModel rootNode = map.getRootNode();
        return rootNode.getExtension(this.getExtensionClass());
    }

    protected NodeModel[] getNodesForSelection() {
        if (this.getHookAnnotation().onceForMap()) {
            return this.getRootNodeForSelection();
        }
        return this.getSelectedNodes();
    }

    protected NodeModel[] getRootNodeForSelection() {
        NodeModel[] nodes = new NodeModel[]{Controller.getCurrentController().getMap().getRootNode()};
        return nodes;
    }

    protected NodeModel[] getSelectedNodes() {
        IMapSelection mapSelection = Controller.getCurrentController().getSelection();
        if (mapSelection != null) {
            Set<NodeModel> selection = mapSelection.getSelection();
            int size = selection.size();
            NodeModel[] nodes = new NodeModel[size];
            Iterator iterator = selection.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                nodes[i++] = (NodeModel)iterator.next();
            }
            return nodes;
        }
        return new NodeModel[0];
    }

    public boolean isActive(NodeModel nodeModel) {
        if (!nodeModel.isRoot() && this.getHookAnnotation().onceForMap()) {
            return this.isActive(nodeModel.getMap().getRootNode());
        }
        return nodeModel.containsExtension(this.getExtensionClass());
    }

    public IExtension getExtension(NodeModel nodeModel) {
        if (!nodeModel.isRoot() && this.getHookAnnotation().onceForMap()) {
            return this.getExtension(nodeModel.getMap().getRootNode());
        }
        return nodeModel.getExtension(this.getExtensionClass());
    }

    protected boolean isActiveForSelection() {
        NodeModel[] nodes = this.getNodesForSelection();
        for (int i = 0; i < nodes.length; ++i) {
            NodeModel nodeModel = nodes[i];
            if (!nodeModel.containsExtension(this.getExtensionClass())) continue;
            return true;
        }
        return false;
    }

    private boolean isActiveForSelection(Enum<?> value) {
        NodeModel[] nodes = this.getNodesForSelection();
        for (int i = 0; i < nodes.length; ++i) {
            NodeModel nodeModel = nodes[i];
            IExtension nodeValue = nodeModel.getExtension(this.getExtensionClass());
            if ((value != null || nodeValue == null) && (value == null || value.equals(nodeValue))) continue;
            return false;
        }
        return true;
    }

    protected void registerAction(AFreeplaneAction action) {
        Controller.getCurrentModeController().addAction(action);
    }

    protected void remove(NodeModel node, IExtension extension) {
        node.removeExtension(extension);
    }

    protected void saveExtension(IExtension extension, XMLElement element) {
        element.setAttribute("NAME", this.getHookName());
        if (extension instanceof Enum) {
            element.setAttribute("VALUE", extension.toString());
        }
    }

    public void undoableActivateHook(NodeModel node, IExtension extension) {
        if (!node.containsExtension(extension.getClass())) {
            this.undoableToggleHook(node, extension);
        }
    }

    public void undoableDeactivateHook(NodeModel node) {
        IExtension extension = node.getExtension(this.getExtensionClass());
        if (extension != null) {
            this.undoableToggleHook(node, extension);
        }
    }

    public void undoableSetHookForSelection(boolean enable) {
        NodeModel[] nodes = this.getNodesForSelection();
        for (int i = 0; i < nodes.length; ++i) {
            NodeModel node = nodes[i];
            if (node.containsExtension(this.getExtensionClass()) == enable) continue;
            this.undoableToggleHook(node);
        }
    }

    public void undoableSetHookForSelection(IExtension extension) {
        NodeModel[] nodes = this.getNodesForSelection();
        for (int i = 0; i < nodes.length; ++i) {
            NodeModel node = nodes[i];
            if (extension == null && !node.containsExtension(this.getExtensionClass())) continue;
            this.undoableToggleHook(node, extension);
        }
    }

    public void undoableToggleHook(NodeModel node) {
        this.undoableToggleHook(node, node.getExtension(this.getExtensionClass()));
    }

    public void undoableToggleHook(NodeModel node, IExtension extension) {
        ToggleHookActor actor = new ToggleHookActor(node, extension);
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    protected IExtension toggle(NodeModel node, IExtension extension) {
        IExtension after;
        IExtension before;
        if (extension != null && node.containsExtension(extension.getClass())) {
            before = extension;
            after = null;
            this.remove(node, extension);
        } else {
            if (extension == null) {
                extension = this.createExtension(node);
            }
            if (extension != null) {
                this.add(node, extension);
            }
            before = null;
            after = extension;
        }
        Controller.getCurrentModeController().getMapController().nodeChanged(node, this.getExtensionClass(), before, after);
        return extension;
    }

    public static void removeMapExtensions(NodeModel node) {
        IExtension[] extensionArray;
        for (IExtension extension : extensionArray = node.getSharedExtensions().values().toArray(new IExtension[0])) {
            if (!MapExtensions.isMapExtension(extension.getClass())) continue;
            node.removeExtension(extension);
        }
    }

    public void moveExtension(ModeController modeController, MapModel sourceMap, MapModel targetMap) {
        NodeModel targetNode;
        IExtension targetExtension;
        Class<? extends IExtension> extensionClass;
        NodeModel sourceNode = sourceMap.getRootNode();
        final IExtension sourceExtension = sourceNode.getExtension(extensionClass = this.getExtensionClass());
        if (sourceExtension == (targetExtension = (targetNode = targetMap.getRootNode()).getExtension(extensionClass))) {
            return;
        }
        IActor actor = new IActor(){

            @Override
            public void act() {
                if (targetExtension != null) {
                    targetNode.removeExtension(targetExtension);
                }
                if (sourceExtension != null) {
                    targetNode.addExtension(sourceExtension);
                }
            }

            @Override
            public void undo() {
                if (sourceExtension != null) {
                    targetNode.removeExtension(sourceExtension);
                }
                if (targetExtension != null) {
                    targetNode.addExtension(targetExtension);
                }
            }

            @Override
            public String getDescription() {
                return "move extension " + extensionClass.getName();
            }
        };
        modeController.execute(actor, targetMap);
    }

    @SelectableAction(checkOnNodeChange=true)
    protected class SelectableEnumAction
    extends HookAction {
        private static final long serialVersionUID = 1L;
        final Enum<?> value;

        public SelectableEnumAction(String key, Enum<?> value) {
            super(key + "." + String.valueOf(value));
            this.value = value;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PersistentNodeHook.this.undoableSetHookForSelection(false);
            if (this.value != null) {
                PersistentNodeHook.this.undoableSetHookForSelection((IExtension)((Object)this.value));
            }
            this.setSelected(true);
        }

        @Override
        public void setSelected() {
            this.setSelected(PersistentNodeHook.this.isActiveForSelection(this.value));
        }
    }

    public abstract class HookAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;

        public HookAction(String key) {
            super(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PersistentNodeHook.this.undoableSetHookForSelection(!PersistentNodeHook.this.isActiveForSelection());
        }
    }

    @SelectableAction(checkOnNodeChange=true)
    protected class SelectableHookAction
    extends HookAction {
        private static final long serialVersionUID = 1L;

        public SelectableHookAction(String key) {
            super(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setSelected(!PersistentNodeHook.this.isActiveForSelection());
            super.actionPerformed(e);
            this.setSelected(PersistentNodeHook.this.isActiveForSelection());
        }

        @Override
        public void setSelected() {
            this.setSelected(PersistentNodeHook.this.isActiveForSelection());
        }
    }

    protected class XmlReader
    implements IElementDOMHandler {
        protected XmlReader() {
        }

        @Override
        public Object createElement(Object parent, String tag, XMLElement attributes) {
            if (attributes == null) {
                return null;
            }
            if (!PersistentNodeHook.this.getHookName().equals(attributes.getAttribute("NAME", null))) {
                return null;
            }
            return parent;
        }

        @Override
        public void endElement(Object parent, String tag, Object userObject, XMLElement lastBuiltElement) {
            if (PersistentNodeHook.this.getHookAnnotation().onceForMap() && !ReadManager.belongsToRootNode(lastBuiltElement)) {
                return;
            }
            NodeModel node = (NodeModel)userObject;
            if (node.getExtension(PersistentNodeHook.this.getExtensionClass()) != null) {
                return;
            }
            IExtension extension = PersistentNodeHook.this.createExtension(node, lastBuiltElement);
            if (extension == null) {
                return;
            }
            PersistentNodeHook.this.add(node, extension);
        }
    }

    protected class XmlWriter
    implements IExtensionElementWriter {
        protected XmlWriter() {
        }

        @Override
        public void writeContent(ITreeWriter writer, Object object, IExtension extension) throws IOException {
            XMLElement element = new XMLElement("hook");
            try {
                PersistentNodeHook.this.saveExtension(extension, element);
                writer.addElement(null, element);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private final class ToggleHookActor
    implements IActor {
        IExtension extension;
        private final NodeModel node;

        private ToggleHookActor(NodeModel node, IExtension extension) {
            this.node = node;
            this.extension = extension != null ? extension : node.getExtension(PersistentNodeHook.this.getExtensionClass());
        }

        @Override
        public void act() {
            this.extension = PersistentNodeHook.this.toggle(this.node, this.extension);
        }

        @Override
        public String getDescription() {
            return PersistentNodeHook.this.getHookName();
        }

        @Override
        public void undo() {
            this.act();
        }
    }
}

