/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.gui.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.panel.BaseContainer;
import net.infonode.gui.panel.BaseContainerUtil;
import net.infonode.properties.base.PropertyGroup;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapContainer;
import net.infonode.properties.propertymap.PropertyMapFactory;
import net.infonode.properties.propertymap.PropertyMapGroup;
import net.infonode.properties.propertymap.PropertyMapValueHandler;
import net.infonode.properties.types.BorderProperty;
import net.infonode.properties.types.ColorProperty;
import net.infonode.properties.types.FontProperty;
import net.infonode.properties.types.InsetsProperty;
import net.infonode.util.Direction;

public class ComponentProperties
extends PropertyMapContainer {
    public static final PropertyMapGroup PROPERTIES = new PropertyMapGroup("Component Properties", "");
    public static final BorderProperty BORDER = new BorderProperty((PropertyGroup)PROPERTIES, "Border", "Component border.", PropertyMapValueHandler.INSTANCE);
    public static final InsetsProperty INSETS = new InsetsProperty((PropertyGroup)PROPERTIES, "Insets", "Component insets inside the border.", PropertyMapValueHandler.INSTANCE);
    public static final ColorProperty FOREGROUND_COLOR = new ColorProperty((PropertyGroup)PROPERTIES, "Foreground Color", "Component foreground color.", PropertyMapValueHandler.INSTANCE);
    public static final FontProperty FONT = new FontProperty((PropertyGroup)PROPERTIES, "Font", "Component text font.", PropertyMapValueHandler.INSTANCE);
    public static final ColorProperty BACKGROUND_COLOR = new ColorProperty((PropertyGroup)PROPERTIES, "Background Color", "Component background color. A null value means that no background will be painted.", PropertyMapValueHandler.INSTANCE);

    static {
        ComponentProperties properties = new ComponentProperties(PROPERTIES.getDefaultMap());
        properties.setBackgroundColor(null).setBorder(null).setInsets(null);
    }

    public ComponentProperties() {
        super(PROPERTIES);
    }

    public ComponentProperties(PropertyMap map) {
        super(map);
    }

    public ComponentProperties(ComponentProperties inheritFrom) {
        super(PropertyMapFactory.create(inheritFrom.getMap()));
    }

    public ComponentProperties addSuperObject(ComponentProperties properties) {
        this.getMap().addSuperMap(properties.getMap());
        return this;
    }

    public ComponentProperties removeSuperObject() {
        this.getMap().removeSuperMap();
        return this;
    }

    public ComponentProperties removeSuperObject(ComponentProperties superObject) {
        this.getMap().removeSuperMap(superObject.getMap());
        return this;
    }

    public ComponentProperties setBorder(Border border) {
        BORDER.set(this.getMap(), border);
        return this;
    }

    public ComponentProperties setInsets(Insets insets) {
        INSETS.set(this.getMap(), insets);
        return this;
    }

    public ComponentProperties setBackgroundColor(Color color) {
        BACKGROUND_COLOR.set(this.getMap(), color);
        return this;
    }

    public Insets getInsets() {
        return INSETS.get(this.getMap());
    }

    public Border getBorder() {
        return BORDER.get(this.getMap());
    }

    public Color getBackgroundColor() {
        return BACKGROUND_COLOR.get(this.getMap());
    }

    public Font getFont() {
        return FONT.get(this.getMap());
    }

    public Color getForegroundColor() {
        return FOREGROUND_COLOR.get(this.getMap());
    }

    public ComponentProperties setForegroundColor(Color foregroundColor) {
        FOREGROUND_COLOR.set(this.getMap(), foregroundColor);
        return this;
    }

    public ComponentProperties setFont(Font font) {
        FONT.set(this.getMap(), font);
        return this;
    }

    public void applyTo(JComponent component) {
        this.applyTo(component, Direction.RIGHT);
    }

    public void applyTo(JComponent component, Direction insetsDirection) {
        EmptyBorder innerBorder;
        Insets insets = this.getInsets() == null ? null : InsetsUtil.rotate(insetsDirection, this.getInsets());
        EmptyBorder emptyBorder = innerBorder = insets == null ? null : new EmptyBorder(insets);
        component.setBorder(this.getBorder() == null ? innerBorder : (innerBorder == null ? this.getBorder() : new CompoundBorder(this.getBorder(), innerBorder)));
        if (component instanceof BaseContainer) {
            BaseContainer c = (BaseContainer)component;
            BaseContainerUtil.setOverridedBackground(c, this.getBackgroundColor());
            BaseContainerUtil.setOverridedForeground(c, this.getForegroundColor());
            BaseContainerUtil.setOverridedFont(c, this.getFont());
        } else {
            component.setBackground(this.getBackgroundColor());
            component.setFont(this.getFont());
            component.setForeground(this.getForegroundColor());
        }
    }
}

