/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.action;

import java.io.ObjectStreamException;
import javax.swing.Icon;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.TabWindow;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.icon.button.RestoreIcon;

public final class RestoreParentWithAbortWindowAction
extends DockingWindowAction {
    private static final long serialVersionUID = 1L;
    public static final RestoreParentWithAbortWindowAction INSTANCE = new RestoreParentWithAbortWindowAction();
    private static final Icon icon = new RestoreIcon(10);

    private RestoreParentWithAbortWindowAction() {
    }

    @Override
    public String getName() {
        return "Restore";
    }

    @Override
    public boolean isPerformable(DockingWindow window) {
        if (window.isMinimized() && window.isRestorable()) {
            return true;
        }
        TabWindow tabWindow = DockingUtil.getTabWindowFor(window);
        return tabWindow != null && tabWindow.isMaximized() && tabWindow.isRestorable();
    }

    @Override
    public void perform(DockingWindow window) {
        if (window != null && window.isMinimized()) {
            RestoreParentWithAbortWindowAction.restore(window);
        } else {
            TabWindow tabWindow = DockingUtil.getTabWindowFor(window);
            if (tabWindow != null && tabWindow.isMaximized()) {
                RestoreParentWithAbortWindowAction.restore(tabWindow);
            }
        }
    }

    @Override
    public Icon getIcon() {
        return icon;
    }

    private static void restore(DockingWindow window) {
        try {
            if (window != null && window.isRestorable()) {
                window.restoreWithAbort();
            }
        }
        catch (OperationAbortedException operationAbortedException) {
            // empty catch block
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

