/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import net.infonode.docking.AbstractTabWindow;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.WindowDragger;
import net.infonode.docking.WindowTab;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabDragEvent;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabbedPanel;

class TabWindowMover
extends TabAdapter {
    private AbstractTabWindow window;
    private TabbedPanel tabbedPanel;
    private WindowDragger dragger;

    TabWindowMover(AbstractTabWindow window, TabbedPanel tabbedPanel) {
        this.window = window;
        this.tabbedPanel = tabbedPanel;
    }

    @Override
    public void tabDragged(TabDragEvent event) {
        if (this.dragger == null) {
            DockingWindow w = ((WindowTab)event.getTab()).getWindow();
            if (!w.getWindowProperties().getDragEnabled()) {
                return;
            }
            this.dragger = new WindowDragger(w);
            this.window.setDraggedTabIndex(this.tabbedPanel.getTabIndex(event.getTab()));
        }
        this.dragger.dragWindow(event.getMouseEvent());
    }

    @Override
    public void tabDropped(TabDragEvent event) {
        if (this.dragger != null) {
            this.dragger.dropWindow(event.getMouseEvent());
            this.dragger = null;
        }
    }

    @Override
    public void tabDragAborted(TabEvent event) {
        if (this.dragger != null) {
            this.dragger.abortDrag();
            this.dragger = null;
        }
    }
}

