/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfBookmark;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfExternalGraphic;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFootnote;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfHyperLink;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfLeader;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfListItem;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfPageNumber;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfPageNumberCitation;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfParagraphBreak;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfSpaceManager;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfSpaceSplitter;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfString;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableCell;

public class RtfTextrun
extends RtfContainer {
    public static final int BREAK_NONE = 0;
    public static final int BREAK_PAGE = 1;
    public static final int BREAK_COLUMN = 2;
    public static final int BREAK_EVEN_PAGE = 3;
    public static final int BREAK_ODD_PAGE = 4;
    private boolean bSuppressLastPar;
    private RtfListItem rtfListItem;
    protected static final Log log = LogFactory.getLog(RtfTextrun.class);
    private RtfSpaceManager rtfSpaceManager = new RtfSpaceManager();

    RtfTextrun(RtfContainer parent, Writer w, RtfAttributes attrs) throws IOException {
        super(parent, w, attrs);
    }

    private void addOpenGroupMark(RtfAttributes attrs) throws IOException {
        RtfOpenGroupMark r = new RtfOpenGroupMark(this, this.writer, attrs);
    }

    private void addCloseGroupMark(int breakType) throws IOException {
        RtfCloseGroupMark r = new RtfCloseGroupMark(this, this.writer, breakType);
    }

    private void addCloseGroupMark() throws IOException {
        RtfCloseGroupMark r = new RtfCloseGroupMark(this, this.writer, 0);
    }

    public void pushBlockAttributes(RtfAttributes attrs) throws IOException {
        this.rtfSpaceManager.stopUpdatingSpaceBefore();
        RtfSpaceSplitter splitter = this.rtfSpaceManager.pushRtfSpaceSplitter(attrs);
        this.addOpenGroupMark(splitter.getCommonAttributes());
    }

    public void popBlockAttributes(int breakType) throws IOException {
        this.rtfSpaceManager.popRtfSpaceSplitter();
        this.rtfSpaceManager.stopUpdatingSpaceBefore();
        this.addCloseGroupMark(breakType);
    }

    public void pushInlineAttributes(RtfAttributes attrs) throws IOException {
        this.rtfSpaceManager.pushInlineAttributes(attrs);
        this.addOpenGroupMark(attrs);
    }

    public void addPageNumberCitation(String refId) throws IOException {
        RtfPageNumberCitation r = new RtfPageNumberCitation((RtfContainer)this, this.writer, refId);
    }

    public void popInlineAttributes() throws IOException {
        this.rtfSpaceManager.popInlineAttributes();
        this.addCloseGroupMark();
    }

    public void addString(String s) throws IOException {
        if (s.equals("")) {
            return;
        }
        RtfAttributes attrs = this.rtfSpaceManager.getLastInlineAttribute();
        this.rtfSpaceManager.pushRtfSpaceSplitter(attrs);
        this.rtfSpaceManager.setCandidate(attrs);
        new RtfString((RtfContainer)this, this.writer, s);
        this.rtfSpaceManager.popRtfSpaceSplitter();
    }

    public RtfFootnote addFootnote() throws IOException {
        return new RtfFootnote(this, this.writer);
    }

    public RtfParagraphBreak addParagraphBreak() throws IOException {
        List children = this.getChildren();
        Stack<Integer> tmp = new Stack<Integer>();
        RtfParagraphBreak par = null;
        int deletedCloseGroupCount = 0;
        ListIterator lit = children.listIterator(children.size());
        while (lit.hasPrevious() && lit.previous() instanceof RtfCloseGroupMark) {
            tmp.push(((RtfCloseGroupMark)lit.next()).getBreakType());
            lit.remove();
            ++deletedCloseGroupCount;
        }
        if (children.size() != 0) {
            this.setChildren(children);
            par = new RtfParagraphBreak(this, this.writer);
            for (int i = 0; i < deletedCloseGroupCount; ++i) {
                this.addCloseGroupMark((Integer)tmp.pop());
            }
        }
        return par;
    }

    public void addLeader(RtfAttributes attrs) throws IOException {
        new RtfLeader(this, this.writer, attrs);
    }

    public void addPageNumber(RtfAttributes attr) throws IOException {
        RtfPageNumber r = new RtfPageNumber(this, this.writer, attr);
    }

    public RtfHyperLink addHyperlink(RtfAttributes attr) throws IOException {
        return new RtfHyperLink(this, this.writer, attr);
    }

    public void addBookmark(String id) throws IOException {
        if (id.length() > 0) {
            new RtfBookmark((RtfContainer)this, this.writer, id);
        }
    }

    public RtfExternalGraphic newImage() throws IOException {
        return new RtfExternalGraphic(this, this.writer);
    }

    public static RtfTextrun getTextrun(RtfContainer container, Writer writer, RtfAttributes attrs) throws IOException {
        List list = container.getChildren();
        if (list.size() == 0) {
            RtfTextrun textrun = new RtfTextrun(container, writer, attrs);
            list.add(textrun);
            return textrun;
        }
        Object obj = list.get(list.size() - 1);
        if (obj instanceof RtfTextrun) {
            return (RtfTextrun)obj;
        }
        RtfTextrun textrun = new RtfTextrun(container, writer, attrs);
        list.add(textrun);
        return textrun;
    }

    public void setSuppressLastPar(boolean bSuppress) {
        this.bSuppressLastPar = bSuppress;
    }

    @Override
    protected void writeRtfContent() throws IOException {
        boolean bHasTableCellParent = this.getParentOfClass(RtfTableCell.class) != null;
        RtfAttributes attrBlockLevel = new RtfAttributes();
        boolean bLast = false;
        Iterator it = this.parent.getChildren().iterator();
        while (it.hasNext()) {
            if (it.next() != this) continue;
            bLast = !it.hasNext();
            break;
        }
        RtfParagraphBreak lastParagraphBreak = null;
        if (bLast) {
            RtfElement aBefore = null;
            for (Object o : this.getChildren()) {
                RtfElement e = (RtfElement)o;
                if (e instanceof RtfParagraphBreak) {
                    if (!(aBefore instanceof RtfParagraphBreak) && !(aBefore instanceof RtfBookmark)) {
                        lastParagraphBreak = (RtfParagraphBreak)e;
                    }
                } else if (!(e instanceof RtfOpenGroupMark) && !(e instanceof RtfCloseGroupMark) && e.isEmpty()) {
                    lastParagraphBreak = null;
                }
                aBefore = e;
            }
        }
        this.writeAttributes(this.attrib, null);
        if (this.rtfListItem != null) {
            this.rtfListItem.getRtfListStyle().writeParagraphPrefix(this);
        }
        boolean bPrevPar = false;
        boolean bBookmark = false;
        boolean bFirst = true;
        for (Object o : this.getChildren()) {
            RtfElement e = (RtfElement)o;
            boolean bRtfParagraphBreak = e instanceof RtfParagraphBreak;
            if (bHasTableCellParent) {
                attrBlockLevel.set(e.getRtfAttributes());
            }
            boolean bHide = false;
            bHide = bRtfParagraphBreak;
            boolean bl = bHide = bHide && (bPrevPar || bFirst || this.bSuppressLastPar && bLast && lastParagraphBreak != null && e == lastParagraphBreak || bBookmark) && ((RtfParagraphBreak)e).canHide();
            if (!bHide) {
                this.newLine();
                e.writeRtf();
                if (this.rtfListItem != null && e instanceof RtfParagraphBreak) {
                    this.rtfListItem.getRtfListStyle().writeParagraphPrefix(this);
                }
            }
            if (e instanceof RtfParagraphBreak) {
                bPrevPar = true;
                continue;
            }
            if (e instanceof RtfBookmark) {
                bBookmark = true;
                continue;
            }
            if (e instanceof RtfCloseGroupMark || e instanceof RtfOpenGroupMark) continue;
            bPrevPar = bPrevPar && e.isEmpty();
            bFirst = bFirst && e.isEmpty();
            bBookmark = false;
        }
        if (bHasTableCellParent) {
            this.writeAttributes(attrBlockLevel, null);
        }
    }

    public void setRtfListItem(RtfListItem listItem) {
        this.rtfListItem = listItem;
    }

    public RtfListItem getRtfListItem() {
        return this.rtfListItem;
    }

    private class RtfCloseGroupMark
    extends RtfElement {
        private int breakType;

        RtfCloseGroupMark(RtfContainer parent, Writer w, int breakType) throws IOException {
            super(parent, w);
            this.breakType = 0;
            this.breakType = breakType;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public int getBreakType() {
            return this.breakType;
        }

        @Override
        protected void writeRtfContent() throws IOException {
            boolean bHasTableCellParent;
            this.writeGroupMark(false);
            boolean bl = bHasTableCellParent = this.getParentOfClass(RtfTableCell.class) != null;
            if (this.breakType != 0) {
                if (!bHasTableCellParent) {
                    this.writeControlWord("sect");
                    switch (this.breakType) {
                        case 3: {
                            this.writeControlWord("sbkeven");
                            break;
                        }
                        case 4: {
                            this.writeControlWord("sbkodd");
                            break;
                        }
                        case 2: {
                            this.writeControlWord("sbkcol");
                            break;
                        }
                        default: {
                            this.writeControlWord("sbkpage");
                            break;
                        }
                    }
                } else {
                    log.warn((Object)"Cannot create break-after for a paragraph inside a table.");
                }
            }
        }
    }

    private class RtfOpenGroupMark
    extends RtfElement {
        RtfOpenGroupMark(RtfContainer parent, Writer w, RtfAttributes attr) throws IOException {
            super(parent, w, attr);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        protected void writeRtfContent() throws IOException {
            this.writeGroupMark(true);
            this.writeAttributes(this.getRtfAttributes(), null);
        }
    }
}

