/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.progress.mindmapmode;

import java.util.List;
import java.util.stream.Stream;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.view.swing.features.progress.mindmapmode.ProgressUtilities;

public class ProgressIcons {
    public static final String EXTENDED_PROGRESS_ICON_IDENTIFIER = ".*[Pp]rogress_(tenth|quarter)_[0-9]{2}\\.[a-zA-Z0-9]*";
    private static final String[] iconNames = new String[]{"0%", "25%", "50%", "75%", "100%"};
    private static final MindIcon[] progressIcons = (MindIcon[])Stream.of(iconNames).map(arg_0 -> ((IconStore)IconStoreFactory.ICON_STORE).getMindIcon(arg_0)).toArray(MindIcon[]::new);
    private static final MindIcon OKIcon = IconStoreFactory.ICON_STORE.getMindIcon("button_ok");

    public static void updateProgressIcons(NodeModel node, boolean up) {
        block18: {
            int iActiveIcon;
            MIconController iconController;
            block19: {
                String activeIcon;
                ProgressUtilities progUtil;
                block17: {
                    progUtil = new ProgressUtilities();
                    iconController = (MIconController)IconController.getController();
                    activeIcon = null;
                    List icons = node.getIcons();
                    if (progUtil.hasProgressIcons(node)) {
                        block13: for (int i = 0; i < icons.size(); ++i) {
                            for (int j = 0; j < iconNames.length; ++j) {
                                if (!((NamedIcon)icons.get(i)).getName().equals(iconNames[j])) continue;
                                activeIcon = iconNames[j];
                                continue block13;
                            }
                        }
                        ProgressIcons.removeProgressIcons(node);
                    }
                    if (activeIcon != null) break block17;
                    ProgressIcons.removeProgressIcons(node);
                    iconController.addIcon(node, progressIcons[0], 0);
                    break block18;
                }
                iActiveIcon = Integer.parseInt(activeIcon.substring(0, activeIcon.length() - 1));
                if (!up) break block19;
                switch (iActiveIcon) {
                    case 0: {
                        iconController.addIcon(node, progressIcons[1], 0);
                        break;
                    }
                    case 25: {
                        iconController.addIcon(node, progressIcons[2], 0);
                        break;
                    }
                    case 50: {
                        iconController.addIcon(node, progressIcons[3], 0);
                        break;
                    }
                    case 75: {
                        iconController.addIcon(node, progressIcons[4], 0);
                        if (!progUtil.hasOKIcon(node)) {
                            iconController.addIcon(node, OKIcon, 0);
                            break;
                        }
                        break block18;
                    }
                    case 100: {
                        iconController.addIcon(node, progressIcons[4], 0);
                        iconController.addIcon(node, OKIcon, 0);
                        break;
                    }
                }
                break block18;
            }
            switch (iActiveIcon) {
                case 25: {
                    iconController.addIcon(node, progressIcons[0], 0);
                    break;
                }
                case 50: {
                    iconController.addIcon(node, progressIcons[1], 0);
                    break;
                }
                case 75: {
                    iconController.addIcon(node, progressIcons[2], 0);
                    break;
                }
                case 100: {
                    iconController.addIcon(node, progressIcons[3], 0);
                    break;
                }
            }
        }
    }

    public static void updateExtendedProgressIcons(NodeModel node, String sFile) {
        if (sFile.matches(EXTENDED_PROGRESS_ICON_IDENTIFIER)) {
            MIconController iconController = (MIconController)IconController.getController();
            ProgressIcons.removeProgressIcons(node);
            if (sFile.matches(".*_quarter_.*")) {
                int fileNum = Integer.parseInt(sFile.substring(sFile.lastIndexOf("_") + 1, sFile.lastIndexOf("_") + 3));
                switch (fileNum) {
                    case 0: {
                        iconController.addIcon(node, progressIcons[0], 0);
                        break;
                    }
                    case 1: {
                        iconController.addIcon(node, progressIcons[1], 0);
                        break;
                    }
                    case 2: {
                        iconController.addIcon(node, progressIcons[2], 0);
                        break;
                    }
                    case 3: {
                        iconController.addIcon(node, progressIcons[3], 0);
                        break;
                    }
                    case 4: {
                        iconController.addIcon(node, progressIcons[4], 0);
                        iconController.addIcon(node, OKIcon, 0);
                        break;
                    }
                    default: {
                        iconController.addIcon(node, progressIcons[0], 0);
                        break;
                    }
                }
            } else if (sFile.matches(".*_tenth_.*")) {
                int fileNum = Integer.parseInt(sFile.substring(sFile.lastIndexOf("_") + 1, sFile.lastIndexOf("_") + 3));
                switch (fileNum) {
                    case 0: 
                    case 1: {
                        iconController.addIcon(node, progressIcons[0], 0);
                        break;
                    }
                    case 2: 
                    case 3: {
                        iconController.addIcon(node, progressIcons[1], 0);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        iconController.addIcon(node, progressIcons[2], 0);
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        iconController.addIcon(node, progressIcons[3], 0);
                        break;
                    }
                    case 10: {
                        iconController.addIcon(node, progressIcons[4], 0);
                        iconController.addIcon(node, OKIcon, 0);
                        break;
                    }
                    default: {
                        iconController.addIcon(node, progressIcons[0], 0);
                    }
                }
            }
        }
    }

    public static void removeProgressIcons(NodeModel node) {
        ProgressUtilities progUtil = new ProgressUtilities();
        if (progUtil.hasProgressIcons(node) || progUtil.hasOKIcon(node)) {
            MIconController iconController = (MIconController)IconController.getController();
            String[] progressIconNames = new String[]{"0%", "25%", "50%", "75%", "100%", "button_ok"};
            List icons = node.getIcons();
            block0: for (int i = 0; i < icons.size(); ++i) {
                String iconName = ((NamedIcon)icons.get(i)).getName();
                for (int j = 0; j < progressIconNames.length; ++j) {
                    if (!iconName.equals(progressIconNames[j])) continue;
                    iconController.removeIcon(node, i);
                    --i;
                    continue block0;
                }
            }
        }
    }
}

