/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;

public class NodeSorter {
    final Comparator<NodeModel> comparator;

    public NodeSorter(Comparator<NodeModel> comparator) {
        this.comparator = comparator;
    }

    public void sortNodes(NodeModel node) {
        this.sortNodes(node, 0);
    }

    private void sortNodes(NodeModel parent, int fromIndex) {
        int nodeIndex;
        int childCount = parent.getChildCount();
        if (fromIndex >= childCount) {
            return;
        }
        Vector<NodeModel> sortVector = new Vector<NodeModel>(childCount - fromIndex);
        for (nodeIndex = fromIndex; nodeIndex < childCount; ++nodeIndex) {
            NodeModel child = parent.getChildAt(nodeIndex);
            if (SummaryNode.isSummaryNode((NodeModel)child)) {
                this.sortNodes(child, 0);
                break;
            }
            if (SummaryNode.isFirstGroupNode((NodeModel)child)) break;
            sortVector.add(child);
        }
        Collections.sort(sortVector, this.comparator);
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        for (NodeModel child : sortVector) {
            ((FreeNode)Controller.getCurrentModeController().getExtension(FreeNode.class)).undoableDeactivateHook(child);
            mapController.moveNode(child, fromIndex++);
        }
        this.sortNodes(parent, nodeIndex);
    }
}

