/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryLevels;
import org.freeplane.features.map.mindmapmode.InsertionRelation;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.mindmapmode.NewNodeStyle;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;

public class NewParentNode
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public NewParentNode() {
        super("NewParentNode");
    }

    public void actionPerformed(ActionEvent e) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection == null) {
            return;
        }
        final NodeModel selectedNode = selection.getSelected();
        List unmodifyable = selection.getOrderedSelection();
        ArrayList<NodeModel> selectedNodes = new ArrayList<NodeModel>(unmodifyable.size());
        selectedNodes.addAll(unmodifyable);
        Controller.getCurrentModeController().getMapController().sortNodesByDepth(selectedNodes);
        if (selectedNode.isRoot()) {
            UITools.errorMessage((Object)TextUtils.getText((String)"cannot_add_parent_to_root"));
            return;
        }
        final NodeModel newNode = this.moveToNewParent(selection.getSelectionRoot(), selectedNode, selectedNodes);
        if (newNode == null) {
            return;
        }
        selection.selectAsTheOnlyOneSelected(newNode);
        Controller.getCurrentController().getViewController().invokeLater(new Runnable(){

            @Override
            public void run() {
                ((MTextController)TextController.getController()).edit(newNode, selectedNode, true, false, false);
            }
        });
    }

    private NodeModel moveToNewParent(NodeModel selectionRoot, NodeModel selectedNode, List<NodeModel> selectedNodes) {
        Collection summarizedNodes;
        NodeModel oldParent = selectedNode.getParentNode();
        for (NodeModel node2 : selectedNodes) {
            if (node2.getParentNode() != oldParent) {
                UITools.errorMessage((Object)TextUtils.getText((String)"cannot_add_parent_diff_parents"));
                return null;
            }
            if (!node2.isRoot()) continue;
            UITools.errorMessage((Object)TextUtils.getText((String)"cannot_add_parent_to_root"));
            return null;
        }
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        SummaryLevels summaryLevels = new SummaryLevels(selectionRoot, oldParent);
        int childPosition = selectedNode.getIndex();
        NodeModel summaryNode = summaryLevels.findSummaryNode(childPosition);
        if (summaryNode != null && selectedNodes.containsAll(summarizedNodes = summaryLevels.summarizedNodes(summaryNode))) {
            childPosition = summaryLevels.findGroupBeginNodeIndex(childPosition);
        }
        int index = childPosition;
        NodeModel newParent = mapController.addNewNode(oldParent, index, node -> {
            node.setSide(selectedNode.getSide());
            NewNodeStyle.assignStyleToNewNode(node);
        });
        mapController.moveNodes(selectedNodes, newParent, InsertionRelation.AS_CHILD);
        return newParent;
    }
}

