/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.explorer.mindmapmode;

import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.explorer.CopySuggestedReferenceAction;
import org.freeplane.features.explorer.GlobalNodes;
import org.freeplane.features.explorer.MapExplorerController;
import org.freeplane.features.explorer.NodeAlias;
import org.freeplane.features.explorer.mindmapmode.SetNodeAlias;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.text.TextController;

public class MMapExplorerController
extends MapExplorerController {
    public static void install(ModeController modeController, TextController textController) {
        MMapExplorerController explorer = new MMapExplorerController(modeController, textController);
        modeController.addExtension(MapExplorerController.class, (IExtension)explorer);
        modeController.addAction((AFreeplaneAction)new SetNodeAlias(explorer));
        modeController.addAction((AFreeplaneAction)new CopySuggestedReferenceAction((MapExplorerController)explorer));
        MapExplorerController.install((ModeController)modeController);
    }

    private MMapExplorerController(ModeController modeController, TextController textController) {
        super(modeController);
    }

    public void makeGlobal(final NodeModel node, final boolean isGlobal) {
        if (isGlobal == this.isGlobal(node)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                this.set(node, isGlobal);
            }

            public void undo() {
                this.set(node, !isGlobal);
            }

            private void set(NodeModel node2, boolean newValue) {
                MapModel map = node2.getMap();
                GlobalNodes.writeableOf((MapModel)map).makeGlobal(node2, newValue);
                MapController mapController = MMapExplorerController.this.modeController.getMapController();
                mapController.nodeChanged(node2);
                MMapExplorerController.this.fireGlobalNodeChangedEvent(map, mapController);
            }

            public String getDescription() {
                return "setGlobal";
            }
        };
        this.modeController.execute(actor, node.getMap());
    }

    private void fireGlobalNodeChangedEvent(MapModel map, MapController mapController) {
        mapController.fireMapChanged(new MapChangeEvent((Object)this, map, (Object)"GLOBAL_NODES", null, null, false));
    }

    public void setAlias(final NodeModel node, final String alias) {
        final String oldAlias = NodeAlias.getAlias((NodeModel)node);
        if (oldAlias == alias || oldAlias != null && oldAlias.equals(alias)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                NodeAlias.setAlias((NodeModel)node, (String)alias);
                MapController mapController = MMapExplorerController.this.modeController.getMapController();
                mapController.nodeChanged(node);
                if (MMapExplorerController.this.isGlobal(node)) {
                    MMapExplorerController.this.fireGlobalNodeChangedEvent(node.getMap(), mapController);
                }
            }

            public void undo() {
                NodeAlias.setAlias((NodeModel)node, (String)oldAlias);
                MMapExplorerController.this.modeController.getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setAlias";
            }
        };
        this.modeController.execute(actor, node.getMap());
    }
}

