/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.syntaxpane.actions;

import de.sciss.syntaxpane.SyntaxDocument;
import de.sciss.syntaxpane.Token;
import de.sciss.syntaxpane.TokenType;
import de.sciss.syntaxpane.actions.ActionUtils;
import de.sciss.syntaxpane.actions.DefaultSyntaxAction;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class JIndentAction
extends DefaultSyntaxAction {
    public JIndentAction() {
        super("JINDENT");
    }

    @Override
    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        int pos = target.getCaretPosition();
        int start = sDoc.getParagraphElement(pos).getStartOffset();
        String line = ActionUtils.getLine(target);
        String lineToPos = line.substring(0, pos - start);
        String prefix = ActionUtils.getIndent(line);
        Token t = sDoc.getTokenAt(pos);
        if (TokenType.isComment(t)) {
            String trimmed = line.trim();
            if (!trimmed.startsWith("/*") || !trimmed.endsWith("*/")) {
                if (trimmed.endsWith("*/")) {
                    try {
                        String commentStartLine = sDoc.getLineAt(t.start);
                        prefix = ActionUtils.getIndent(commentStartLine);
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(JIndentAction.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else if (trimmed.startsWith("*")) {
                    prefix = prefix + "* ";
                } else if (trimmed.startsWith("/**")) {
                    prefix = prefix + " * ";
                } else if (trimmed.startsWith("/*")) {
                    prefix = prefix + " ";
                }
            }
        } else if (lineToPos.trim().endsWith("{")) {
            prefix = prefix + ActionUtils.getTab(target);
        } else {
            String noComment = sDoc.getUncommentedText(start, pos);
            if (noComment.trim().endsWith("{")) {
                prefix = prefix + ActionUtils.getTab(target);
            }
        }
        target.replaceSelection("\n" + prefix);
    }
}

