/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import org.freeplane.api.ConditionalStyleNotFoundException;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.plugin.script.filter.ScriptCondition;
import org.freeplane.plugin.script.proxy.AConditionalStyleProxy;
import org.freeplane.plugin.script.proxy.NodeStyleProxy;

public class MapConditionalStyleProxy
extends AConditionalStyleProxy<MapModel> {
    public MapConditionalStyleProxy(MapModel mapModel, ConditionalStyleModel.Item item) {
        super(mapModel, item);
    }

    public MapConditionalStyleProxy(MapModel mapModel, boolean isActive, String script, String styleName, boolean isLast) {
        super(mapModel, isActive, script, styleName, isLast);
    }

    public MapConditionalStyleProxy(MapModel mapModel, boolean isActive, ASelectableCondition condition, IStyle style, boolean isLast) {
        super(mapModel, isActive, condition, style, isLast);
    }

    @Override
    ConditionalStyleModel getConditionalStyleModel() {
        return MapStyleModel.getExtension((MapModel)((MapModel)this.getDelegate())).getConditionalStyleModel();
    }

    public void setActive(boolean isActive) {
        MLogicalStyleController controller = (MLogicalStyleController)LogicalStyleController.getController();
        controller.setActiveForConditionalStyle((MapModel)this.getDelegate(), this.getConditionalStyleModel(), this.getIndex(), isActive);
        this.callDelayedRefresh((MapModel)this.getDelegate());
    }

    public void setScript(String script) {
        MLogicalStyleController controller = (MLogicalStyleController)LogicalStyleController.getController();
        ScriptCondition condition = script == null ? null : new ScriptCondition(script);
        controller.setConditionForConditionalStyle((MapModel)this.getDelegate(), this.getConditionalStyleModel(), this.getIndex(), (ASelectableCondition)condition);
        this.callDelayedRefresh((MapModel)this.getDelegate());
    }

    public void setStyleName(String styleName) {
        MLogicalStyleController controller = (MLogicalStyleController)LogicalStyleController.getController();
        IStyle style = NodeStyleProxy.styleByNameOrThrowException((MapModel)this.getDelegate(), styleName);
        controller.setStyleForConditionalStyle((MapModel)this.getDelegate(), this.getConditionalStyleModel(), this.getIndex(), style);
        this.callDelayedRefresh((MapModel)this.getDelegate());
    }

    public void setLast(boolean isLast) {
        MLogicalStyleController controller = (MLogicalStyleController)LogicalStyleController.getController();
        controller.setLastForConditionalStyle((MapModel)this.getDelegate(), this.getConditionalStyleModel(), this.getIndex(), isLast);
        this.callDelayedRefresh((MapModel)this.getDelegate());
    }

    public void moveTo(int toIndex) {
        int index = this.getIndex();
        if (index == -1) {
            throw new ConditionalStyleNotFoundException(this.toString());
        }
        if (toIndex == index) {
            return;
        }
        MLogicalStyleController.getController().moveConditionalStyle((MapModel)this.getDelegate(), this.getConditionalStyleModel(), index, toIndex);
        this.callDelayedRefresh((MapModel)this.getDelegate());
    }

    public MapConditionalStyleProxy remove() {
        int index = this.getIndex();
        if (index == -1) {
            throw new ConditionalStyleNotFoundException(this.toString());
        }
        ConditionalStyleModel.Item item = MLogicalStyleController.getController().removeConditionalStyle((MapModel)this.getDelegate(), this.getConditionalStyleModel(), index);
        this.callDelayedRefresh((MapModel)this.getDelegate());
        return new MapConditionalStyleProxy((MapModel)this.getDelegate(), item);
    }

    private void callDelayedRefresh(MapModel map) {
        LogicalStyleController.getController().refreshMapLaterUndoable(map);
    }
}

