/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.freeplane.plugin.script.NodeScript;
import org.freeplane.plugin.script.ScriptContext;

public class UniqueStack
implements Iterable<NodeScript> {
    private final ArrayList<NodeScript> nodeScriptStack = new ArrayList(8);
    private final ArrayList<ScriptContext> scriptContextStack = new ArrayList(8);
    private final HashSet<NodeScript> set = new HashSet(8);
    private boolean ignoreCycles;

    UniqueStack() {
    }

    boolean push(ScriptContext scriptContext) {
        NodeScript nodeScript = scriptContext.getNodeScript();
        if (this.set.add(nodeScript)) {
            this.nodeScriptStack.add(nodeScript);
            this.scriptContextStack.add(scriptContext);
            return true;
        }
        return false;
    }

    void pop() {
        if (!this.scriptContextStack.isEmpty()) {
            this.scriptContextStack.remove(this.scriptContextStack.size() - 1);
            NodeScript last = this.nodeScriptStack.remove(this.nodeScriptStack.size() - 1);
            this.set.remove(last);
        }
    }

    ScriptContext getCurrentContext() {
        return this.scriptContextStack.isEmpty() ? null : this.scriptContextStack.get(this.scriptContextStack.size() - 1);
    }

    @Override
    public Iterator<NodeScript> iterator() {
        return this.nodeScriptStack.iterator();
    }

    int size() {
        return this.nodeScriptStack.size();
    }

    public String toString() {
        return this.nodeScriptStack.toString();
    }

    List<NodeScript> findCycle(NodeScript element) {
        if (this.set.contains(element)) {
            int cycleBegin = this.nodeScriptStack.lastIndexOf(element);
            ArrayList<NodeScript> cycle = new ArrayList<NodeScript>(this.nodeScriptStack.size() - cycleBegin + 1);
            cycle.addAll(this.nodeScriptStack.subList(cycleBegin, this.nodeScriptStack.size()));
            cycle.add(element);
            return cycle;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <V> V ignoreCycles(Supplier<V> closure) {
        boolean oldSuppressWarningsOnCyclicDependencies = this.ignoreCycles;
        this.ignoreCycles = true;
        try {
            V v = closure.get();
            return v;
        }
        finally {
            this.ignoreCycles = oldSuppressWarningsOnCyclicDependencies;
        }
    }

    boolean ignoreCycles() {
        return this.ignoreCycles;
    }
}

