/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.freeplane.core.util.LogUtils;

class PrecompiledClasses {
    private static final String FILE = "file";
    private static final String COMPILED_FILES = "compiledFiles";
    private static final String UTF_8 = "utf-8";
    private static final String COMPILATION_TIME = "compilationTime";
    private final Set<String> filePaths;
    private final long compilationTime;

    void addAll(Collection<File> files) {
        for (File file : files) {
            this.filePaths.add(file.getAbsolutePath());
        }
    }

    PrecompiledClasses(long compilationTime, Set<String> filePaths) {
        this.compilationTime = compilationTime;
        this.filePaths = filePaths;
    }

    PrecompiledClasses(long compilationTime) {
        this.compilationTime = compilationTime;
        this.filePaths = new HashSet<String>();
    }

    Collection<File> filterNewAndNewer(Collection<File> files) {
        ArrayList<File> filteredFiles = new ArrayList<File>();
        for (File file : files) {
            if (this.filePaths.contains(file.getAbsolutePath()) && file.lastModified() < this.compilationTime) continue;
            filteredFiles.add(file);
        }
        return filteredFiles;
    }

    public void write(File output) {
        try {
            this.writeThrowExceptions(output);
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
        }
    }

    private void writeThrowExceptions(File output) throws FactoryConfigurationError, XMLStreamException, IOException, FileNotFoundException {
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), UTF_8));){
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            XMLEventWriter eventWriter = outputFactory.createXMLEventWriter(out);
            this.writeThrowExceptions(eventWriter);
        }
    }

    void writeThrowExceptions(XMLEventWriter writer) throws FactoryConfigurationError, XMLStreamException {
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        DTD eol = eventFactory.createDTD("\n");
        StartDocument startDocument = eventFactory.createStartDocument(UTF_8);
        writer.add(startDocument);
        StartElement configStartElement = eventFactory.createStartElement("", "", COMPILED_FILES);
        writer.add(configStartElement);
        Attribute compilationTimeAttribute = eventFactory.createAttribute(COMPILATION_TIME, Long.toString(this.compilationTime));
        writer.add(compilationTimeAttribute);
        writer.add(eol);
        for (String filePath : this.filePaths) {
            this.createNode(writer, FILE, filePath);
        }
        writer.add(eventFactory.createEndElement("", "", COMPILED_FILES));
        writer.add(eol);
        writer.add(eventFactory.createEndDocument());
        writer.close();
    }

    private void createNode(XMLEventWriter writer, String name, String value) throws XMLStreamException {
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        DTD eol = eventFactory.createDTD("\n");
        DTD tab = eventFactory.createDTD("\t");
        StartElement sElement = eventFactory.createStartElement("", "", name);
        writer.add(tab);
        writer.add(sElement);
        Characters characters = eventFactory.createCharacters(value);
        writer.add(characters);
        EndElement eElement = eventFactory.createEndElement("", "", name);
        writer.add(eElement);
        writer.add(eol);
    }

    static PrecompiledClasses readThrowExceptions(XMLEventReader eventReader) throws XMLStreamException {
        long compilationTime = 0L;
        HashSet<String> files = new HashSet<String>();
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (!event.isStartElement()) continue;
            StartElement startElement = event.asStartElement();
            if (startElement.getName().getLocalPart().equals(COMPILED_FILES)) {
                Iterator<Attribute> attributes = startElement.getAttributes();
                while (attributes.hasNext()) {
                    Attribute attribute = attributes.next();
                    if (!attribute.getName().toString().equals(COMPILATION_TIME)) continue;
                    String value = attribute.getValue();
                    compilationTime = Long.parseLong(value);
                }
            }
            if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().equals(FILE)) continue;
            event = eventReader.nextEvent();
            files.add(event.asCharacters().getData());
        }
        return new PrecompiledClasses(compilationTime, files);
    }

    public static PrecompiledClasses read(File input) {
        try {
            return PrecompiledClasses.readThrowExceptions(input);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (XMLStreamException e) {
            LogUtils.warn((Throwable)e);
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
        }
        return new PrecompiledClasses(0L, Collections.emptySet());
    }

    public static PrecompiledClasses readThrowExceptions(File input) throws XMLStreamException, IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(input), UTF_8));){
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
            PrecompiledClasses precompiledClasses = PrecompiledClasses.readThrowExceptions(eventReader);
            return precompiledClasses;
        }
    }
}

