define(["exports","./../emby-apiclient/connectionmanager.js","./../emby-apiclient/events.js","./../loading/loading.js","./globalize.js","./textencoding.js","./responsehelper.js","./servicelocator.js","./appsettings.js","./../layoutmanager.js"],function(_exports,_connectionmanager,_events,_loading,_globalize,_textencoding,_responsehelper,_servicelocator,_appsettings,_layoutmanager){function showAlert(options){return Emby.importModule("./modules/common/dialogs/alert.js").then(function(alert){return alert(options)})}function loadPlaybackManager(){return Emby.importModule("./modules/common/playback/playbackmanager.js")}function showAlertAndResolve(options){return showAlert(options).catch(function(){return Promise.resolve()})}function BaseAppRouter(){}function catchToResolve(err){return Promise.resolve()}function enableWelcome(result,options){return null!=options&&options.allowWelcome&&_servicelocator.appHost.supports("multiserver")&&(null==(options=result.Servers)||!options.length||"1"!==_appsettings.default.get("welcome_seen")&&(_appsettings.default.set("welcome_seen","1"),1))}function onChangeToUserErrorPublic(err){return _loading.default.hide(),Promise.reject(err)}function stopPlaying(playbackManager,forceStopAll){return!forceStopAll&&playbackManager.isPlayingAudio()||playbackManager.stop(),Promise.resolve()}function loadPlaybackManagerAndStopPlaying(forceStopAll){return loadPlaybackManager().then(function(playbackManager){return stopPlaying(playbackManager,forceStopAll)})}function changeToUserOnAppResume(instance,apiClient,userId){loadPlaybackManager().then(function(playbackManager){if(playbackManager.isInPictureInPicture())return Promise.resolve();(apiClient.getCurrentUserId()===userId?Promise.resolve():stopPlaying(!0)).then(function(){instance.showServerLogin({apiClient:apiClient}).then(function(){instance.changeToUser({apiClient:apiClient,userId:userId,forceShowProfilePinPrompt:!0})})})})}var dateAppPaused;Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,BaseAppRouter.prototype.setPinValidated=function(userId){this._pinValidated=userId},BaseAppRouter.prototype.isPinValidated=function(userId){return this._pinValidated===userId},BaseAppRouter.prototype.showServerLogin=function(options){var instance=this;return function(instance,options){var apiClient,userId=options.userId;return userId?(apiClient=options.apiClient).getUser(userId).then(function(user){return user.HasPassword?instance.showServerLogin({apiClient:apiClient,username:user.Name,loginType:"manual"}):instance.authenticateUser({serverId:user.ServerId,username:user.Name})}):Promise.reject()}(this,options).catch(function(){var apiClient=options.apiClient;return console.log("appRouter - showServerLogin: "+apiClient.serverId()),apiClient.getPublicUsersQueryResult({Limit:0}).then(function(result){return result.TotalRecordCount?options.loginType="visual":options.loginType="manual",instance.showServerLogin(options)})})},BaseAppRouter.prototype.showEnableProfilePinPrompt=function(options){var user=options.user;return function(options){return Emby.importModule("./modules/common/dialogs/confirm.js").then(function(confirm){return confirm(options)})}({title:_globalize.default.translate("TitleProfilePin"),cancelText:_globalize.default.translate("No"),confirmText:_globalize.default.translate("Yes"),text:_globalize.default.translate("RequireEnteringPinToReturnQuestion")}).then(function(){_appsettings.default.enableProfilePin(user.Id,!0)},function(){_appsettings.default.enableProfilePin(user.Id,!1)})},BaseAppRouter.prototype.authenticateUser=function(options){_loading.default.show();var instance=this,apiClient=_connectionmanager.default.getApiClient(options.serverId);return loadPlaybackManagerAndStopPlaying(!0).then(function(){return apiClient.authenticateUserByName(options.username,options.password).then(function(result){instance.setPinValidated(result.User.Id);var newAutoLoginValue,currentAutoLogin=_appsettings.default.autoLogin();return!0===options.rememberLogin?"none"===currentAutoLogin&&_appsettings.default.autoLogin("lastuser"):!1===options.rememberLogin&&(newAutoLoginValue=options.serverId+"|"+result.User.Id,"lastuser"!==currentAutoLogin&&currentAutoLogin!==newAutoLoginValue||_appsettings.default.autoLogin("showlogin")),("none"!==_appsettings.default.autoLogin()&&result.User.Configuration.ProfilePin?(_loading.default.hide(),instance.showEnableProfilePinPrompt({apiClient:apiClient,user:result.User}).catch(catchToResolve)):(result.User.Configuration.ProfilePin?_appsettings.default.enableProfilePin(result.User.Id,!0):_appsettings.default.enableProfilePin(result.User.Id,!1),Promise.resolve())).then(function(){return instance.handleConnectionResult({State:"SignedIn",ApiClient:apiClient},{enableProfilePin:!1})})},function(result){apiClient.isMinServerVersion("4.8.4")?(result.errorTitle=_globalize.default.translate("HeaderSignInError"),_responsehelper.default.handleErrorResponse(result)):(_loading.default.hide(),showAlert({text:_globalize.default.translate("MessageInvalidUser"),title:_globalize.default.translate("HeaderSignInError")}))})})},BaseAppRouter.prototype.showConnectionErrorAlert=function(result,options){var _result$Server=null==(_result$Server=result.Server)?void 0:_result$Server.Name;return showAlertAndResolve({text:result.ErrorMessage||_globalize.default.translate("MessageUnableToConnectToServer"),title:_result$Server?_globalize.default.translate("TitleUnableToReachName",_textencoding.default.htmlEncode(_result$Server)):_globalize.default.translate("TitleUnableToReachServer")})},BaseAppRouter.prototype.handleConnectionResult=function(result,options){switch(console.log("handleConnectionResult: "+(result.State||"")),result.State){case"SignedIn":this.isPinValidated(result.ApiClient.getCurrentUserId())||this.setPinValidated(null),this.handleSignedInResult(result,options);break;case"ServerSignIn":enableWelcome(result,options)?this.showWelcome():this.showServerLogin({apiClient:result.ApiClient});break;case"ServerSelection":_servicelocator.appHost.supports("multiserver")?enableWelcome(result,options)?this.showWelcome():this.showSelectServer():this.showServerLogin({apiClient:_connectionmanager.default.currentApiClient()});break;case"ConnectSignIn":!0===(null==options?void 0:options.allowWelcome)?this.showWelcome():this.showConnectLogin();break;case"ServerUpdateNeeded":!1===(null==options?void 0:options.allowServerUpdateNeedAlert)?this.showSelectServer():(_loading.default.hide(),function(instance){var html,text=_globalize.default.translate("ServerUpdateNeeded","https://emby.media");showAlertAndResolve({html:html=_servicelocator.appHost.supports("externallinks")&&_servicelocator.appHost.supports("targetblank")&&_servicelocator.appHost.supports("externalappinfo")?_globalize.default.translate("ServerUpdateNeeded",'<a is="emby-linkbutton" class="button-link" href="https://emby.media">https://emby.media</a>'):html,text:text}).then(function(){return instance.showSelectServer()})}(this));break;case"Unavailable":_loading.default.hide(),this.showConnectionErrorAlert(result,options)}},BaseAppRouter.prototype.promptForProfilePin=function(apiClient,userId,forceShow){var instance=this;return _connectionmanager.default.isLoggedIntoConnect()||!_appsettings.default.enableProfilePin(userId)||this.isPinValidated(userId)&&!forceShow?Promise.resolve():apiClient.getUser(userId).then(function(user){return user.Configuration.ProfilePin?function(instance,apiClient,user){return _loading.default.hide(),instance.showProfilePinPrompt({apiClient:apiClient,user:user}).then(function(result){return instance.setPinValidated(user.Id),Promise.resolve(result)})}(instance,apiClient,user):Promise.resolve()})},BaseAppRouter.prototype.forgotPin=function(options){return this.showServerLogin(options)},BaseAppRouter.prototype.changeToUser=function(options){var apiClient=options.apiClient,userId=options.userId,serverId=apiClient.serverId(),instance=(_loading.default.show(),this),boundOnError=function(err){_loading.default.hide();var errorName=((null==err?void 0:err.name)||"").toLowerCase(),instance=this.instance,apiClient=(options=this.options).apiClient,options=options.userId;return"forgotpin"!==errorName?Promise.reject(err):apiClient.getUser(options).then(function(user){user.HasPassword?instance.showServerLogin({apiClient:apiClient,username:user.Name,loginType:"manual"}):instance.showServerLogin({apiClient:apiClient})})}.bind({instance:instance,options:options});return _connectionmanager.default.validateCanChangeToUser(apiClient,userId).then(function(){return instance.promptForProfilePin(apiClient,userId,options.forceShowProfilePinPrompt).then(function(){return(apiClient.getCurrentUserId()===userId?Promise.resolve():loadPlaybackManagerAndStopPlaying(!0)).then(function(){return _connectionmanager.default.changeToUser(apiClient,userId).then(function(){var server=_connectionmanager.default.getSavedServers().filter(function(s){return s.Id===serverId})[0];return server?_connectionmanager.default.connectToServer(server,{userId:userId,autoLogin:"lastuser"}).then(function(result){switch(_loading.default.hide(),result.State){case"SignedIn":case"ServerUpdateNeeded":return instance.handleConnectionResult(result,{enableProfilePin:!1}),Promise.resolve();default:return Promise.reject(result)}}):Promise.reject("server not found")},boundOnError)},boundOnError)},boundOnError)},onChangeToUserErrorPublic)},BaseAppRouter.prototype.isDisplayingAuthenticatedContent=function(){return!1};function onAppPause(){dateAppPaused=Date.now()}function onAppResume(){_connectionmanager.default.onAppResume();var apiClient,userId,autoLoginMode;6e5<=Date.now()-(dateAppPaused||0)&&dateAppPaused&&this.isDisplayingAuthenticatedContent()&&(autoLoginMode=_appsettings.default.autoLogin(),null!=(apiClient=_connectionmanager.default.currentApiClient()))&&apiClient.isLoggedIn()&&("none"===autoLoginMode||"showlogin"===autoLoginMode?(console.log("redirecting back to login on app resume"),_layoutmanager.default.tv&&function(instance,apiClient){loadPlaybackManager().then(function(playbackManager){return playbackManager.isInPictureInPicture()?Promise.resolve():stopPlaying(playbackManager,!0).then(function(){return instance.showServerLogin({apiClient:apiClient})})})}(this,apiClient)):"lastuser"===autoLoginMode?(userId=apiClient.getCurrentUserId(),_appsettings.default.enableProfilePin(userId)&&_layoutmanager.default.tv&&changeToUserOnAppResume(this,apiClient,userId)):2===(apiClient=autoLoginMode.split("|")).length&&(userId=apiClient[0],autoLoginMode=_connectionmanager.default.getApiClient(userId))&&changeToUserOnAppResume(this,autoLoginMode,apiClient[1]))}BaseAppRouter.prototype.start=function(options){_events.default.on(_servicelocator.appHost,"pause",onAppPause),_events.default.on(_servicelocator.appHost,"resume",onAppResume.bind(this))};_exports.default=BaseAppRouter});