/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.commands;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLControlCommandHandler;
import org.jkiss.dbeaver.model.sql.SQLControlResult;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.commands.SQLCommandSet;
import org.jkiss.dbeaver.model.sql.parser.rules.ScriptParameterRule;

public class SQLCommandUnset
implements SQLControlCommandHandler {
    @Override
    @NotNull
    public SQLControlResult handleCommand(@NotNull DBRProgressMonitor monitor, @NotNull SQLControlCommand command, @NotNull SQLScriptContext scriptContext) throws DBException {
        String parameter;
        SQLDialect sqlDialect = scriptContext.getExecutionContext().getDataSource().getSQLDialect();
        int varNameEnd = ScriptParameterRule.tryConsumeParameterName(sqlDialect, parameter = command.getParameter().trim(), 0);
        if (varNameEnd != parameter.length()) {
            throw new DBCException("Invalid Unset command. Expected syntax:\n@unset varName");
        }
        String varName = SQLCommandSet.prepareVarName(sqlDialect, parameter.substring(0, varNameEnd));
        scriptContext.removeVariable(varName);
        return SQLControlResult.success();
    }
}

