/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.data.storage.StringContentStorage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.IOUtils;

public abstract class DBDDocumentContentProxy
implements DBDDocument {
    @NotNull
    protected final DBDContent content;
    protected final DBDDocument document;

    protected DBDDocumentContentProxy(@NotNull DBDContent content) throws DBException {
        this.content = content;
        this.document = this.createDocumentFromContent(content);
    }

    @NotNull
    protected abstract DBDDocument createDocumentFromContent(@NotNull DBDContent var1) throws DBException;

    @Override
    @Nullable
    public Object getDocumentId() {
        return this.document.getDocumentId();
    }

    @Override
    @Nullable
    public Object getDocumentProperty(String name) {
        return this.document.getDocumentProperty(name);
    }

    @Override
    @NotNull
    public String getDocumentContentType() {
        return this.document.getDocumentContentType();
    }

    @Override
    @NotNull
    public Object getRootNode() {
        return this.document.getRootNode();
    }

    @Override
    public void serializeDocument(@NotNull DBRProgressMonitor monitor, @NotNull Writer writer) throws IOException, DBException {
        DBDContentStorage contents = this.content.getContents(monitor);
        if (contents != null) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (Reader reader = contents.getContentReader();){
                reader.transferTo(writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @Override
    public void updateDocument(@NotNull DBRProgressMonitor monitor, @NotNull Reader reader) throws IOException, DBException {
        String data = IOUtils.readToString((Reader)reader);
        this.content.updateContents(monitor, new StringContentStorage(data));
        this.document.updateDocument(monitor, new StringReader(data));
    }

    @Override
    public Object getRawValue() {
        return this.document.getRawValue();
    }

    @Override
    public boolean isNull() {
        return this.document.isNull();
    }

    @Override
    public boolean isModified() {
        return this.document.isModified();
    }

    @Override
    public void release() {
        this.document.release();
    }
}

