/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class GlobalPropertyTester
extends PropertyTester {
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.global";
    public static final String PROP_STANDALONE = "standalone";
    public static final String PROP_DISTRIBUTED = "distributed";
    public static final String PROP_BUNDLE_INSTALLED = "bundleInstalled";
    public static final String PROP_HAS_PREFERENCE = "hasPreference";
    public static final String PROP_HAS_ENV_VARIABLE = "hasEnvVariable";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        return switch (property) {
            case PROP_STANDALONE -> DBWorkbench.getPlatform().getApplication().isStandalone();
            case PROP_DISTRIBUTED -> DBWorkbench.isDistributed();
            case PROP_BUNDLE_INSTALLED -> {
                if (Platform.getBundle((String)((String)args[0])) != null) {
                    yield true;
                }
                yield false;
            }
            case PROP_HAS_PREFERENCE -> {
                String prefName = CommonUtils.toString((Object)expectedValue);
                String prefValue = DBWorkbench.getPlatform().getPreferenceStore().getString(prefName);
                if (CommonUtils.isEmpty((String)prefValue) && (prefValue = System.getProperty(prefName)) != null && prefValue.isEmpty()) {
                    prefValue = Boolean.TRUE.toString();
                }
                yield CommonUtils.toBoolean((Object)prefValue);
            }
            case PROP_HAS_ENV_VARIABLE -> {
                String prefName = CommonUtils.toString((Object)expectedValue);
                String prefValue = System.getenv(prefName);
                if (!(prefValue != null && prefValue.isEmpty() || CommonUtils.toBoolean((Object)prefValue))) {
                    yield false;
                }
                yield true;
            }
            default -> false;
        };
    }
}

