/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data.type;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.data.type.PostgreTypeHandler;
import org.jkiss.utils.CommonUtils;

public class PostgreTimeTypeHandler
extends PostgreTypeHandler {
    public static final PostgreTimeTypeHandler INSTANCE = new PostgreTimeTypeHandler();

    private PostgreTimeTypeHandler() {
    }

    @Override
    public int getTypeModifiers(@NotNull PostgreDataType type, @NotNull String typeName, @NotNull String[] typmod) throws DBException {
        switch (typmod.length) {
            case 0: {
                return -1;
            }
            case 1: {
                return PostgreTimeTypeHandler.getTimeModifiers(CommonUtils.toInt((Object)typmod[0]));
            }
        }
        return super.getTypeModifiers(type, typeName, typmod);
    }

    @Override
    @NotNull
    public String getTypeModifiersString(@NotNull PostgreDataType type, int typmod) {
        Integer precision;
        StringBuilder sb = new StringBuilder();
        if (typmod >= 0 && (precision = this.getTypePrecision(type, typmod)) != null) {
            sb.append('(').append(precision).append(')');
        }
        return sb.toString();
    }

    @Override
    @Nullable
    public Integer getTypePrecision(@NotNull PostgreDataType type, int typmod) {
        if (typmod < 0) {
            return null;
        }
        return typmod;
    }

    private static int getTimeModifiers(int precision) throws DBException {
        if (precision < 0 || precision > 6) {
            throw new DBException("Time precision " + precision + " must be between 0 and 6");
        }
        return precision;
    }
}

