/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.utils.CommonUtils;

public class FilterMapping {
    public final String typeName;
    DBSObjectFilter defaultFilter;
    Map<String, DBSObjectFilter> customFilters = new HashMap<String, DBSObjectFilter>();

    FilterMapping(String typeName) {
        this.typeName = typeName;
    }

    FilterMapping(FilterMapping mapping) {
        this.typeName = mapping.typeName;
        this.defaultFilter = mapping.defaultFilter == null ? null : new DBSObjectFilter(mapping.defaultFilter);
        for (Map.Entry<String, DBSObjectFilter> entry : mapping.customFilters.entrySet()) {
            this.customFilters.put(entry.getKey(), new DBSObjectFilter(entry.getValue()));
        }
    }

    @Nullable
    DBSObjectFilter getFilter(@Nullable DBSObject parentObject, boolean firstMatch) {
        String objectID;
        DBSObjectFilter filter;
        if (parentObject == null) {
            return this.defaultFilter;
        }
        if (!this.customFilters.isEmpty() && ((filter = this.customFilters.get(objectID = FilterMapping.getFilterContainerUniqueID(parentObject))) != null && !filter.isNotApplicable() || firstMatch)) {
            return filter;
        }
        return firstMatch ? null : this.defaultFilter;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FilterMapping)) {
            return false;
        }
        FilterMapping source = (FilterMapping)obj;
        return CommonUtils.equalObjects((Object)this.typeName, (Object)source.typeName) && CommonUtils.equalObjects((Object)this.defaultFilter, (Object)source.defaultFilter) && CommonUtils.equalObjects(this.customFilters, source.customFilters);
    }

    public int hashCode() {
        return CommonUtils.hashCode((Object)this.typeName) + CommonUtils.hashCode((Object)this.defaultFilter) + CommonUtils.hashCode(this.customFilters);
    }

    public static String getFilterContainerUniqueID(@Nullable DBSObject parentObject) {
        String objectFullName = DBUtils.getObjectFullName((DBPNamedObject)parentObject, (DBPEvaluationContext)DBPEvaluationContext.UI);
        DBSInstance ownerInstance = DBUtils.getObjectOwnerInstance((DBSObject)parentObject);
        if (!CommonUtils.equalObjects((Object)ownerInstance.getName(), (Object)parentObject.getDataSource().getName())) {
            return ownerInstance.getName() + ":" + objectFullName;
        }
        return objectFullName;
    }
}

