/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.PlatformHelper;
import org.eclipse.ecf.filetransfer.service.IRemoteFileSystemBrowser;
import org.eclipse.ecf.filetransfer.service.IRemoteFileSystemBrowserFactory;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransferFactory;
import org.eclipse.ecf.filetransfer.service.ISendFileTransfer;
import org.eclipse.ecf.filetransfer.service.ISendFileTransferFactory;
import org.eclipse.ecf.internal.provider.filetransfer.IURLConnectionModifier;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;
import org.eclipse.ecf.provider.filetransfer.IFileTransferProtocolToFactoryMapper;
import org.eclipse.ecf.provider.filetransfer.retrieve.MultiProtocolRetrieveAdapter;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator,
IFileTransferProtocolToFactoryMapper {
    public static final String PLUGIN_EXCLUDED_SYS_PROP_NAME = "org.eclipse.ecf.provider.filetransfer.excludeContributors";
    private static final String CLASS_ATTR = "class";
    private static final String PRIORITY_ATTR = "priority";
    private static final int DEFAULT_PRIORITY = 100;
    private static final String PROTOCOL_ATTR = "protocol";
    private static final String URI_ATTR = "uri";
    private static final String[] jvmSchemes = new String[]{Messages.FileTransferNamespace_Http_Protocol, Messages.FileTransferNamespace_Ftp_Protocol, Messages.FileTransferNamespace_File_Protocol, Messages.FileTransferNamespace_Jar_Protocol, Messages.FileTransferNamespace_Https_Protocol, Messages.FileTransferNamespace_Mailto_Protocol, Messages.FileTransferNamespace_Gopher_Protocol};
    private static final String URL_HANDLER_PROTOCOL_NAME = "url.handler.protocol";
    private static final String URLSTREAM_HANDLER_SERVICE_NAME = "org.osgi.service.url.URLStreamHandlerService";
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.filetransfer";
    private static final String RETRIEVE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT_NAME = "retrieveFileTransferProtocolFactory";
    private static final String RETRIEVE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT = "org.eclipse.ecf.provider.filetransfer.retrieveFileTransferProtocolFactory";
    private static final String SEND_FILETRANSFER_PROTOCOL_FACTORY_EPOINT_NAME = "sendFileTransferProtocolFactory";
    private static final String SEND_FILETRANSFER_PROTOCOL_FACTORY_EPOINT = "org.eclipse.ecf.provider.filetransfer.sendFileTransferProtocolFactory";
    private static final String BROWSE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT_NAME = "browseFileTransferProtocolFactory";
    private static final String BROWSE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT = "org.eclipse.ecf.provider.filetransfer.browseFileTransferProtocolFactory";
    private static Activator plugin;
    private BundleContext context = null;
    private ServiceRegistration fileTransferServiceRegistration;
    private ServiceTracker logServiceTracker = null;
    private ServiceTracker extensionRegistryTracker = null;
    private Map retrieveFileTransferProtocolMap;
    private Map sendFileTransferProtocolMap;
    private Map browseFileTransferProtocolMap;
    private ServiceTracker adapterManagerTracker = null;
    private ServiceTracker proxyServiceTracker = null;
    private IURLConnectionModifier urlConnectionModifier = null;
    private String[] excludedPlugins = null;
    private ServiceRegistration protocolMapperRegistration;
    private IRegistryChangeListener registryChangeListener = new IRegistryChangeListener(){

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] browseDelta;
            IExtensionDelta[] sendDelta;
            IExtensionDelta[] retrieveDelta;
            IExtensionDelta[] iExtensionDeltaArray = retrieveDelta = event.getExtensionDeltas(Activator.PLUGIN_ID, Activator.RETRIEVE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT_NAME);
            int n = retrieveDelta.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta r = iExtensionDeltaArray[n2];
                switch (r.getKind()) {
                    case 1: {
                        Activator.this.addRetrieveExtensions(r.getExtension().getConfigurationElements());
                        break;
                    }
                    case 2: {
                        Activator.this.removeRetrieveExtensions(r.getExtension().getConfigurationElements());
                    }
                }
                ++n2;
            }
            IExtensionDelta[] iExtensionDeltaArray2 = sendDelta = event.getExtensionDeltas(Activator.PLUGIN_ID, Activator.SEND_FILETRANSFER_PROTOCOL_FACTORY_EPOINT_NAME);
            int n3 = sendDelta.length;
            n = 0;
            while (n < n3) {
                IExtensionDelta s = iExtensionDeltaArray2[n];
                switch (s.getKind()) {
                    case 1: {
                        Activator.this.addSendExtensions(s.getExtension().getConfigurationElements());
                        break;
                    }
                    case 2: {
                        Activator.this.removeSendExtensions(s.getExtension().getConfigurationElements());
                    }
                }
                ++n;
            }
            IExtensionDelta[] iExtensionDeltaArray3 = browseDelta = event.getExtensionDeltas(Activator.PLUGIN_ID, Activator.BROWSE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT_NAME);
            int n4 = browseDelta.length;
            n3 = 0;
            while (n3 < n4) {
                IExtensionDelta b = iExtensionDeltaArray3[n3];
                switch (b.getKind()) {
                    case 1: {
                        Activator.this.addBrowseExtensions(b.getExtension().getConfigurationElements());
                        break;
                    }
                    case 2: {
                        Activator.this.removeBrowseExtensions(b.getExtension().getConfigurationElements());
                    }
                }
                ++n3;
            }
        }
    };
    static boolean proxyWarningGiven;
    private final DummyURLStreamHandlerService dummyService = new DummyURLStreamHandlerService();

    static {
        proxyWarningGiven = false;
    }

    private String[] parseExcludedPlugins() {
        String prop = System.getProperty(PLUGIN_EXCLUDED_SYS_PROP_NAME);
        if (prop == null) {
            return new String[0];
        }
        StringTokenizer tok = new StringTokenizer(prop, ",");
        int count = tok.countTokens();
        String[] results = new String[count];
        int i = 0;
        while (i < count) {
            results[i] = tok.nextToken();
            ++i;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogService getLogService() {
        Activator activator = this;
        synchronized (activator) {
            block5: {
                if (this.context != null) break block5;
                return null;
            }
            if (this.logServiceTracker == null) {
                this.logServiceTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
                this.logServiceTracker.open();
            }
            return (LogService)this.logServiceTracker.getService();
        }
    }

    public IProxyService getProxyService() {
        try {
            if (this.proxyServiceTracker == null) {
                this.proxyServiceTracker = new ServiceTracker(this.context, IProxyService.class.getName(), null);
                this.proxyServiceTracker.open();
            }
            return (IProxyService)this.proxyServiceTracker.getService();
        }
        catch (Exception e) {
            Activator.logNoProxyWarning(e);
        }
        catch (NoClassDefFoundError e) {
            Activator.logNoProxyWarning(e);
        }
        return null;
    }

    public static void logNoProxyWarning(Throwable e) {
        Activator a = Activator.getDefault();
        if (a != null && !proxyWarningGiven) {
            a.log((IStatus)new Status(2, PLUGIN_ID, 2, "Warning: Platform proxy API not available", null));
            proxyWarningGiven = true;
        }
    }

    public void log(IStatus status) {
        if (this.context == null) {
            return;
        }
        LogService logService = this.getLogService();
        if (logService != null) {
            logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public Bundle getBundle() {
        if (this.context == null) {
            return null;
        }
        return this.context.getBundle();
    }

    public void start(BundleContext ctxt) throws Exception {
        plugin = this;
        this.context = ctxt;
        this.retrieveFileTransferProtocolMap = new HashMap(3);
        this.sendFileTransferProtocolMap = new HashMap(3);
        this.browseFileTransferProtocolMap = new HashMap(3);
        try {
            Class<?> urlConnectionModifierClass = Class.forName("org.eclipse.ecf.internal.provider.filetransfer.ssl.ECFURLConnectionModifier");
            this.urlConnectionModifier = (IURLConnectionModifier)urlConnectionModifierClass.newInstance();
            this.urlConnectionModifier.init(ctxt);
        }
        catch (ClassNotFoundException urlConnectionModifierClass) {
        }
        catch (Throwable t) {
            this.log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Unexpected Error in Activator.start", t));
        }
        this.fileTransferServiceRegistration = ctxt.registerService(IRetrieveFileTransferFactory.class.getName(), (Object)new IRetrieveFileTransferFactory(){

            public IRetrieveFileTransfer newInstance() {
                return new MultiProtocolRetrieveAdapter();
            }
        }, null);
        this.extensionRegistryTracker = new ServiceTracker(ctxt, IExtensionRegistry.class.getName(), null);
        this.extensionRegistryTracker.open();
        IExtensionRegistry registry = this.getExtensionRegistry();
        if (registry != null) {
            registry.addRegistryChangeListener(this.registryChangeListener);
        }
        this.loadProtocolHandlers();
        this.protocolMapperRegistration = this.context.registerService(IFileTransferProtocolToFactoryMapper.class.getName(), (Object)this, null);
    }

    @Override
    public boolean reinitialize() {
        try {
            this.loadProtocolHandlers();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext ctxt) throws Exception {
        IExtensionRegistry registry = this.getExtensionRegistry();
        if (registry != null) {
            registry.removeRegistryChangeListener(this.registryChangeListener);
        }
        if (this.urlConnectionModifier != null) {
            this.urlConnectionModifier.dispose();
            this.urlConnectionModifier = null;
        }
        if (this.extensionRegistryTracker != null) {
            this.extensionRegistryTracker.close();
            this.extensionRegistryTracker = null;
        }
        if (this.fileTransferServiceRegistration != null) {
            this.fileTransferServiceRegistration.unregister();
            this.fileTransferServiceRegistration = null;
        }
        if (this.adapterManagerTracker != null) {
            this.adapterManagerTracker.close();
            this.adapterManagerTracker = null;
        }
        if (this.proxyServiceTracker != null) {
            this.proxyServiceTracker.close();
            this.proxyServiceTracker = null;
        }
        if (this.retrieveFileTransferProtocolMap != null) {
            this.retrieveFileTransferProtocolMap.clear();
            this.retrieveFileTransferProtocolMap = null;
        }
        if (this.sendFileTransferProtocolMap != null) {
            this.sendFileTransferProtocolMap.clear();
            this.sendFileTransferProtocolMap = null;
        }
        if (this.browseFileTransferProtocolMap != null) {
            this.browseFileTransferProtocolMap.clear();
            this.browseFileTransferProtocolMap = null;
        }
        if (this.protocolMapperRegistration != null) {
            this.protocolMapperRegistration.unregister();
            this.protocolMapperRegistration = null;
        }
        Activator activator = this;
        synchronized (activator) {
            this.context = null;
        }
        plugin = null;
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }

    public String[] getPlatformSupportedSchemes() {
        ServiceTracker handlers = new ServiceTracker(this.context, URLSTREAM_HANDLER_SERVICE_NAME, null);
        handlers.open();
        ServiceReference[] refs = handlers.getServiceReferences();
        HashSet<Object> protocols = new HashSet<Object>();
        if (refs != null) {
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                Object protocol = ref.getProperty(URL_HANDLER_PROTOCOL_NAME);
                if (protocol instanceof String) {
                    protocols.add(protocol);
                } else if (protocol instanceof String[]) {
                    String[] ps = (String[])protocol;
                    protocols.addAll(Arrays.asList(ps));
                }
                ++n2;
            }
        }
        handlers.close();
        protocols.addAll(Arrays.asList(jvmSchemes));
        return protocols.toArray(new String[0]);
    }

    public IExtensionRegistry getExtensionRegistry() {
        if (this.extensionRegistryTracker == null) {
            this.extensionRegistryTracker = new ServiceTracker(this.context, IExtensionRegistry.class.getName(), null);
            this.extensionRegistryTracker.open();
        }
        return (IExtensionRegistry)this.extensionRegistryTracker.getService();
    }

    private int getPriority(IConfigurationElement configElement, String warning, String protocol) {
        String priorityString = configElement.getAttribute(PRIORITY_ATTR);
        int priority = 100;
        if (priorityString != null) {
            try {
                priority = Integer.parseInt(priorityString);
                priority = priority < 0 ? 0 : priority;
            }
            catch (NumberFormatException e) {
                Activator.getDefault().log((IStatus)new Status(2, PLUGIN_ID, 2, NLS.bind((String)"{0} for {1} from {2} has invalid priority {3}. Priority will be set to {4}", (Object[])new Object[]{warning, protocol, configElement.getDeclaringExtension().getContributor().getName(), priorityString, String.valueOf(100)}), null));
            }
        }
        return priority;
    }

    boolean pluginExcluded(String pluginId) {
        if (this.excludedPlugins == null) {
            this.excludedPlugins = this.parseExcludedPlugins();
        }
        List<String> l = Arrays.asList(this.excludedPlugins);
        return l.contains(pluginId);
    }

    void addRetrieveExtensions(IConfigurationElement[] configElements) {
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String protocol = configElement.getAttribute(PROTOCOL_ATTR);
            if (protocol == null || "".equals(protocol)) {
                return;
            }
            String uriStr = configElement.getAttribute(URI_ATTR);
            boolean uri = uriStr == null ? false : Boolean.valueOf(uriStr);
            String CONTRIBUTION_WARNING = "File retrieve contribution";
            try {
                String pluginId = configElement.getDeclaringExtension().getContributor().getName();
                if (!this.pluginExcluded(pluginId)) {
                    IRetrieveFileTransferFactory retrieveFactory = (IRetrieveFileTransferFactory)configElement.createExecutableExtension(CLASS_ATTR);
                    int priority = this.getPriority(configElement, CONTRIBUTION_WARNING, protocol);
                    String contributorName = configElement.getDeclaringExtension().getContributor().getName();
                    this.setRetrieveFileTransferFactory(protocol, contributorName, retrieveFactory, priority, uri);
                } else {
                    Activator.getDefault().log((IStatus)new Status(2, PLUGIN_ID, 2, "Plugin " + pluginId + " excluded from contributing retrieve factory", null));
                }
            }
            catch (CoreException e) {
                Activator.getDefault().log((IStatus)new Status(4, PLUGIN_ID, 4, NLS.bind((String)"Error loading from {0} extension point", (Object)RETRIEVE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT), (Throwable)e));
            }
            ++n2;
        }
    }

    void removeRetrieveExtensions(IConfigurationElement[] configElements) {
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String protocol = configElement.getAttribute(PROTOCOL_ATTR);
            if (protocol == null || "".equals(protocol)) {
                return;
            }
            String id = this.getRetrieveFileTransferFactoryId(protocol);
            if (id != null) {
                this.removeRetrieveFileTransferFactory(id);
            }
            ++n2;
        }
    }

    void addSendExtensions(IConfigurationElement[] configElements) {
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String protocol = configElement.getAttribute(PROTOCOL_ATTR);
            if (protocol == null || "".equals(protocol)) {
                return;
            }
            String uriStr = configElement.getAttribute(URI_ATTR);
            boolean uri = uriStr == null ? false : Boolean.valueOf(uriStr);
            String CONTRIBUTION_WARNING = "File send contribution";
            try {
                String pluginId = configElement.getDeclaringExtension().getContributor().getName();
                if (!this.pluginExcluded(pluginId)) {
                    ISendFileTransferFactory clazz = (ISendFileTransferFactory)configElement.createExecutableExtension(CLASS_ATTR);
                    int priority = this.getPriority(configElement, CONTRIBUTION_WARNING, protocol);
                    this.setSendFileTransferFactory(protocol, pluginId, clazz, priority, uri);
                } else {
                    Activator.getDefault().log((IStatus)new Status(2, PLUGIN_ID, 2, "Plugin " + pluginId + " excluded from contributing send factory", null));
                }
            }
            catch (CoreException e) {
                Activator.getDefault().log((IStatus)new Status(4, PLUGIN_ID, 4, NLS.bind((String)"Error loading from {0} extension point", (Object)SEND_FILETRANSFER_PROTOCOL_FACTORY_EPOINT), (Throwable)e));
            }
            ++n2;
        }
    }

    void removeSendExtensions(IConfigurationElement[] configElements) {
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String protocol = configElement.getAttribute(PROTOCOL_ATTR);
            if (protocol == null || "".equals(protocol)) {
                return;
            }
            String id = this.getSendFileTransferFactoryId(protocol);
            if (id != null) {
                this.removeSendFileTransferFactory(id);
            }
            ++n2;
        }
    }

    void addBrowseExtensions(IConfigurationElement[] configElements) {
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String protocol = configElement.getAttribute(PROTOCOL_ATTR);
            if (protocol == null || "".equals(protocol)) {
                return;
            }
            String uriStr = configElement.getAttribute(URI_ATTR);
            boolean uri = uriStr == null ? false : Boolean.valueOf(uriStr);
            String CONTRIBUTION_WARNING = "File browse contribution";
            try {
                String pluginId = configElement.getDeclaringExtension().getContributor().getName();
                if (!this.pluginExcluded(pluginId)) {
                    IRemoteFileSystemBrowserFactory clazz = (IRemoteFileSystemBrowserFactory)configElement.createExecutableExtension(CLASS_ATTR);
                    int priority = this.getPriority(configElement, CONTRIBUTION_WARNING, protocol);
                    this.setBrowseFileTransferFactory(protocol, pluginId, clazz, priority, uri);
                } else {
                    Activator.getDefault().log((IStatus)new Status(2, PLUGIN_ID, 2, "Plugin " + pluginId + " excluded from contributing browse factory", null));
                }
            }
            catch (CoreException e) {
                Activator.getDefault().log((IStatus)new Status(4, PLUGIN_ID, 4, NLS.bind((String)"Error loading from {0} extension point", (Object)BROWSE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT), (Throwable)e));
            }
            ++n2;
        }
    }

    void removeBrowseExtensions(IConfigurationElement[] configElements) {
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String protocol = configElement.getAttribute(PROTOCOL_ATTR);
            if (protocol == null || "".equals(protocol)) {
                return;
            }
            String id = this.getBrowseFileTransferFactoryId(protocol);
            if (id != null) {
                this.removeBrowseFileTransferFactory(id);
            }
            ++n2;
        }
    }

    private void loadProtocolHandlers() {
        IExtensionRegistry reg = this.getExtensionRegistry();
        if (reg != null) {
            IExtensionPoint browseExtensionPoint;
            IExtensionPoint sendExtensionPoint;
            IExtensionPoint retrieveExtensionPoint = reg.getExtensionPoint(RETRIEVE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT);
            if (retrieveExtensionPoint != null) {
                this.addRetrieveExtensions(retrieveExtensionPoint.getConfigurationElements());
            }
            if ((sendExtensionPoint = reg.getExtensionPoint(SEND_FILETRANSFER_PROTOCOL_FACTORY_EPOINT)) != null) {
                this.addSendExtensions(sendExtensionPoint.getConfigurationElements());
            }
            if ((browseExtensionPoint = reg.getExtensionPoint(BROWSE_FILETRANSFER_PROTOCOL_FACTORY_EPOINT)) != null) {
                this.addBrowseExtensions(browseExtensionPoint.getConfigurationElements());
            }
        }
    }

    private boolean isSchemeRegistered(String protocol, String[] schemes) {
        String[] stringArray = schemes;
        int n = schemes.length;
        int n2 = 0;
        while (n2 < n) {
            String scheme = stringArray[n2];
            if (protocol.equals(scheme)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void registerScheme(String protocol) {
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put(URL_HANDLER_PROTOCOL_NAME, new String[]{protocol});
        this.context.registerService(URLStreamHandlerService.class.getName(), (Object)this.dummyService, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRetrieveFileTransfer getFileTransfer(String protocol) {
        ProtocolFactory protocolFactory = null;
        Map map = this.retrieveFileTransferProtocolMap;
        synchronized (map) {
            protocolFactory = (ProtocolFactory)this.retrieveFileTransferProtocolMap.get(protocol);
        }
        if (protocolFactory == null) {
            return null;
        }
        IRetrieveFileTransferFactory factory = (IRetrieveFileTransferFactory)protocolFactory.getFactory();
        if (factory != null) {
            return factory.newInstance();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISendFileTransfer getSendFileTransfer(String protocol) {
        ProtocolFactory protocolFactory = null;
        Map map = this.sendFileTransferProtocolMap;
        synchronized (map) {
            protocolFactory = (ProtocolFactory)this.sendFileTransferProtocolMap.get(protocol);
        }
        if (protocolFactory == null) {
            return null;
        }
        ISendFileTransferFactory factory = (ISendFileTransferFactory)protocolFactory.getFactory();
        if (factory != null) {
            return factory.newInstance();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteFileSystemBrowser getBrowseFileTransfer(String protocol) {
        ProtocolFactory protocolFactory = null;
        Map map = this.browseFileTransferProtocolMap;
        synchronized (map) {
            protocolFactory = (ProtocolFactory)this.browseFileTransferProtocolMap.get(protocol);
        }
        if (protocolFactory == null) {
            return null;
        }
        IRemoteFileSystemBrowserFactory factory = (IRemoteFileSystemBrowserFactory)protocolFactory.getFactory();
        if (factory != null) {
            return factory.newInstance();
        }
        return null;
    }

    public IAdapterManager getAdapterManager() {
        IAdapterManager adapterManager;
        if (this.adapterManagerTracker == null) {
            this.adapterManagerTracker = new ServiceTracker(this.context, IAdapterManager.class.getName(), null);
            this.adapterManagerTracker.open();
        }
        if ((adapterManager = (IAdapterManager)this.adapterManagerTracker.getService()) == null) {
            adapterManager = PlatformHelper.getPlatformAdapterManager();
        }
        return adapterManager;
    }

    public IURLConnectionModifier getURLConnectionModifier() {
        return this.urlConnectionModifier;
    }

    @Override
    public boolean setRetrieveFileTransferFactory(String protocol, String id, IRetrieveFileTransferFactory factory, int priority) {
        return this.setRetrieveFileTransferFactory(protocol, id, factory, priority, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setRetrieveFileTransferFactory(String protocol, String id, IRetrieveFileTransferFactory factory, int priority, boolean uri) {
        if (protocol == null || "".equals(protocol)) {
            return false;
        }
        if (id == null) {
            return false;
        }
        if (factory == null) {
            return false;
        }
        if (this.pluginExcluded(id)) {
            return false;
        }
        ProtocolFactory newProtocolFactory = new ProtocolFactory(factory, priority, id);
        Map map = this.retrieveFileTransferProtocolMap;
        synchronized (map) {
            String[] existingSchemes;
            ProtocolFactory oldProtocolFactory = (ProtocolFactory)this.retrieveFileTransferProtocolMap.get(protocol);
            if (oldProtocolFactory != null) {
                String CONTRIBUTION_WARNING = "File retrieve contribution";
                int result = oldProtocolFactory.compareTo(newProtocolFactory);
                if (result < 0) {
                    Activator.getDefault().log((IStatus)new Status(2, PLUGIN_ID, 2, NLS.bind((String)"{0} for protocol {1} from {2} will be ignored.  Existing protocol factory has higher priority.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, id}), null));
                    return false;
                }
                if (result == 0) {
                    Activator.getDefault().log((IStatus)new Status(2, PLUGIN_ID, 2, NLS.bind((String)"{0} for protocol {1} from {2} will be used in preference to existing handler.  Both have same priority={3}.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, id, priority}), null));
                } else if (result > 0) {
                    Activator.getDefault().log((IStatus)new Status(2, PLUGIN_ID, 2, NLS.bind((String)"{0} for protocol {1} from {2} will be used in preference to existing handler.  New handler has higher priority={3}<{4}.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, id, priority, oldProtocolFactory.priority}), null));
                }
            }
            if (!uri && !this.isSchemeRegistered(protocol, existingSchemes = this.getPlatformSupportedSchemes())) {
                this.registerScheme(protocol);
            }
            this.retrieveFileTransferProtocolMap.put(protocol, newProtocolFactory);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRetrieveFileTransferFactoryId(String protocol) {
        if (protocol == null) {
            return null;
        }
        Map map = this.retrieveFileTransferProtocolMap;
        synchronized (map) {
            ProtocolFactory oldProtocolFactory;
            block5: {
                oldProtocolFactory = (ProtocolFactory)this.retrieveFileTransferProtocolMap.get(protocol);
                if (oldProtocolFactory != null) break block5;
                return null;
            }
            return oldProtocolFactory.getID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRetrieveFileTransferPriority(String protocol) {
        if (protocol == null) {
            return -1;
        }
        Map map = this.retrieveFileTransferProtocolMap;
        synchronized (map) {
            ProtocolFactory oldProtocolFactory;
            block5: {
                oldProtocolFactory = (ProtocolFactory)this.retrieveFileTransferProtocolMap.get(protocol);
                if (oldProtocolFactory != null) break block5;
                return -1;
            }
            return oldProtocolFactory.getPriority();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeRetrieveFileTransferFactory(String id) {
        if (id == null) {
            return false;
        }
        boolean removed = false;
        Map map = this.retrieveFileTransferProtocolMap;
        synchronized (map) {
            Iterator i = this.retrieveFileTransferProtocolMap.keySet().iterator();
            while (i.hasNext()) {
                ProtocolFactory oldProtocolFactory = (ProtocolFactory)this.retrieveFileTransferProtocolMap.get(i.next());
                if (oldProtocolFactory == null || !id.equals(oldProtocolFactory.getID())) continue;
                i.remove();
                removed = true;
            }
            return removed;
        }
    }

    @Override
    public boolean setBrowseFileTransferFactory(String protocol, String id, IRemoteFileSystemBrowserFactory factory, int priority) {
        return this.setBrowseFileTransferFactory(protocol, id, factory, priority, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setBrowseFileTransferFactory(String protocol, String id, IRemoteFileSystemBrowserFactory factory, int priority, boolean uri) {
        if (protocol == null || "".equals(protocol)) {
            return false;
        }
        if (id == null) {
            return false;
        }
        if (factory == null) {
            return false;
        }
        if (this.pluginExcluded(id)) {
            return false;
        }
        ProtocolFactory newProtocolFactory = new ProtocolFactory(factory, priority, id);
        Map map = this.browseFileTransferProtocolMap;
        synchronized (map) {
            String[] existingSchemes;
            ProtocolFactory oldProtocolFactory = (ProtocolFactory)this.browseFileTransferProtocolMap.get(protocol);
            if (oldProtocolFactory != null) {
                String CONTRIBUTION_WARNING = "File browse contribution";
                int result = oldProtocolFactory.compareTo(newProtocolFactory);
                if (result < 0) {
                    Activator.getDefault().log((IStatus)new Status(2, PLUGIN_ID, 2, NLS.bind((String)"{0} for protocol {1} from {2} will be ignored.  Existing protocol factory has higher priority.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, id}), null));
                    return false;
                }
                if (result == 0) {
                    Activator.getDefault().log((IStatus)new Status(2, PLUGIN_ID, 2, NLS.bind((String)"{0} for protocol {1} from {2} will be used in preference to existing handler.  Both have same priority={3}.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, id, priority}), null));
                } else if (result > 0) {
                    Activator.getDefault().log((IStatus)new Status(2, PLUGIN_ID, 2, NLS.bind((String)"{0} for protocol {1} from {2} will be used in preference to existing handler.  New handler has higher priority={3}<{4}.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, id, priority, oldProtocolFactory.priority}), null));
                }
            }
            if (!uri && !this.isSchemeRegistered(protocol, existingSchemes = this.getPlatformSupportedSchemes())) {
                this.registerScheme(protocol);
            }
            this.browseFileTransferProtocolMap.put(protocol, newProtocolFactory);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBrowseFileTransferFactoryId(String protocol) {
        if (protocol == null) {
            return null;
        }
        Map map = this.browseFileTransferProtocolMap;
        synchronized (map) {
            ProtocolFactory oldProtocolFactory;
            block5: {
                oldProtocolFactory = (ProtocolFactory)this.browseFileTransferProtocolMap.get(protocol);
                if (oldProtocolFactory != null) break block5;
                return null;
            }
            return oldProtocolFactory.getID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBrowseFileTransferPriority(String protocol) {
        if (protocol == null) {
            return -1;
        }
        Map map = this.browseFileTransferProtocolMap;
        synchronized (map) {
            ProtocolFactory oldProtocolFactory;
            block5: {
                oldProtocolFactory = (ProtocolFactory)this.browseFileTransferProtocolMap.get(protocol);
                if (oldProtocolFactory != null) break block5;
                return -1;
            }
            return oldProtocolFactory.getPriority();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeBrowseFileTransferFactory(String id) {
        if (id == null) {
            return false;
        }
        boolean removed = false;
        Map map = this.browseFileTransferProtocolMap;
        synchronized (map) {
            Iterator i = this.browseFileTransferProtocolMap.keySet().iterator();
            while (i.hasNext()) {
                ProtocolFactory oldProtocolFactory = (ProtocolFactory)this.browseFileTransferProtocolMap.get(i.next());
                if (oldProtocolFactory == null || !id.equals(oldProtocolFactory.getID())) continue;
                i.remove();
                removed = true;
            }
            return removed;
        }
    }

    @Override
    public boolean setSendFileTransferFactory(String protocol, String id, ISendFileTransferFactory factory, int priority) {
        return this.setSendFileTransferFactory(protocol, id, factory, priority, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setSendFileTransferFactory(String protocol, String id, ISendFileTransferFactory factory, int priority, boolean uri) {
        if (protocol == null || "".equals(protocol)) {
            return false;
        }
        if (id == null) {
            return false;
        }
        if (factory == null) {
            return false;
        }
        if (this.pluginExcluded(id)) {
            return false;
        }
        ProtocolFactory newProtocolFactory = new ProtocolFactory(factory, priority, id);
        Map map = this.sendFileTransferProtocolMap;
        synchronized (map) {
            String[] existingSchemes;
            ProtocolFactory oldProtocolFactory = (ProtocolFactory)this.sendFileTransferProtocolMap.get(protocol);
            if (oldProtocolFactory != null) {
                String CONTRIBUTION_WARNING = "File send contribution";
                int result = oldProtocolFactory.compareTo(newProtocolFactory);
                if (result < 0) {
                    Activator.getDefault().log((IStatus)new Status(2, PLUGIN_ID, 2, NLS.bind((String)"{0} for protocol {1} from {2} will be ignored.  Existing protocol factory has higher priority.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, id}), null));
                    return false;
                }
                if (result == 0) {
                    Activator.getDefault().log((IStatus)new Status(2, PLUGIN_ID, 2, NLS.bind((String)"{0} for protocol {1} from {2} will be used in preference to existing handler.  Both have same priority={3}.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, id, priority}), null));
                } else if (result > 0) {
                    Activator.getDefault().log((IStatus)new Status(2, PLUGIN_ID, 2, NLS.bind((String)"{0} for protocol {1} from {2} will be used in preference to existing handler.  New handler has higher priority={3}<{4}.", (Object[])new Object[]{CONTRIBUTION_WARNING, protocol, id, priority, oldProtocolFactory.priority}), null));
                }
            }
            if (!uri && !this.isSchemeRegistered(protocol, existingSchemes = this.getPlatformSupportedSchemes())) {
                this.registerScheme(protocol);
            }
            this.sendFileTransferProtocolMap.put(protocol, newProtocolFactory);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSendFileTransferFactoryId(String protocol) {
        if (protocol == null) {
            return null;
        }
        Map map = this.sendFileTransferProtocolMap;
        synchronized (map) {
            ProtocolFactory oldProtocolFactory;
            block5: {
                oldProtocolFactory = (ProtocolFactory)this.sendFileTransferProtocolMap.get(protocol);
                if (oldProtocolFactory != null) break block5;
                return null;
            }
            return oldProtocolFactory.getID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSendFileTransferPriority(String protocol) {
        if (protocol == null) {
            return -1;
        }
        Map map = this.sendFileTransferProtocolMap;
        synchronized (map) {
            ProtocolFactory oldProtocolFactory;
            block5: {
                oldProtocolFactory = (ProtocolFactory)this.sendFileTransferProtocolMap.get(protocol);
                if (oldProtocolFactory != null) break block5;
                return -1;
            }
            return oldProtocolFactory.getPriority();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSendFileTransferFactory(String id) {
        if (id == null) {
            return false;
        }
        boolean removed = false;
        Map map = this.sendFileTransferProtocolMap;
        synchronized (map) {
            Iterator i = this.sendFileTransferProtocolMap.keySet().iterator();
            while (i.hasNext()) {
                ProtocolFactory oldProtocolFactory = (ProtocolFactory)this.sendFileTransferProtocolMap.get(i.next());
                if (oldProtocolFactory == null || !id.equals(oldProtocolFactory.getID())) continue;
                i.remove();
                removed = true;
            }
            return removed;
        }
    }

    class DummyURLStreamHandlerService
    extends AbstractURLStreamHandlerService {
        DummyURLStreamHandlerService() {
        }

        public URLConnection openConnection(URL u) throws IOException {
            throw new IOException(NLS.bind((String)"URLConnection cannot be created for {0}", (Object)u.toExternalForm()));
        }
    }

    static class ProtocolFactory
    implements Comparable {
        Object factory;
        int priority = 0;
        String id;

        public ProtocolFactory(Object factory, int priority, String id) {
            this.factory = factory;
            this.priority = priority;
            this.id = id;
        }

        public Object getFactory() {
            return this.factory;
        }

        public String getID() {
            return this.id;
        }

        public int getPriority() {
            return this.priority;
        }

        public int compareTo(Object another) {
            if (!(another instanceof ProtocolFactory)) {
                return -1;
            }
            ProtocolFactory other = (ProtocolFactory)another;
            if (this.priority == other.priority) {
                return 0;
            }
            return this.priority < other.priority ? -1 : 1;
        }
    }
}

