/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.internal.InternalImages;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;

public class MatchSizeAction
extends SelectionAction {
    public MatchSizeAction(IWorkbenchPart part) {
        super(part);
        this.setText(GEFMessages.MatchSizeAction_Label);
        this.setImageDescriptor(InternalImages.DESC_MATCH_SIZE);
        this.setDisabledImageDescriptor(InternalImages.DESC_MATCH_SIZE_DIS);
        this.setToolTipText(GEFMessages.MatchSizeAction_Tooltip);
        this.setId("org.eclipse.gef.match.size");
    }

    @Override
    protected boolean calculateEnabled() {
        Command cmd = this.createMatchSizeCommand(this.getSelectedEditParts());
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    private Command createMatchSizeCommand(List<EditPart> editParts) {
        if (editParts.isEmpty()) {
            return null;
        }
        if (!(editParts.get(0) instanceof GraphicalEditPart)) {
            return null;
        }
        GraphicalEditPart primarySelection = MatchSizeAction.getPrimarySelectionEditPart(editParts);
        if (primarySelection == null) {
            return null;
        }
        CompoundCommand command = new CompoundCommand();
        PrecisionRectangle precisePrimaryBounds = new PrecisionRectangle(primarySelection.getFigure().getBounds().getCopy());
        primarySelection.getFigure().translateToAbsolute((Translatable)precisePrimaryBounds);
        editParts.stream().filter(GraphicalEditPart.class::isInstance).map(GraphicalEditPart.class::cast).forEach(part -> {
            if (!part.equals(primarySelection)) {
                ChangeBoundsRequest request = new ChangeBoundsRequest("resize");
                PrecisionRectangle precisePartBounds = new PrecisionRectangle(part.getFigure().getBounds().getCopy());
                part.getFigure().translateToAbsolute((Translatable)precisePartBounds);
                PrecisionDimension preciseDimension = new PrecisionDimension();
                preciseDimension.setPreciseWidth(this.getPreciseWidthDelta(precisePartBounds, precisePrimaryBounds));
                preciseDimension.setPreciseHeight(this.getPreciseHeightDelta(precisePartBounds, precisePrimaryBounds));
                request.setSizeDelta((Dimension)preciseDimension);
                Command cmd = part.getCommand(request);
                if (cmd != null) {
                    command.add(cmd);
                }
            }
        });
        return command;
    }

    protected double getPreciseHeightDelta(PrecisionRectangle precisePartBounds, PrecisionRectangle precisePrimaryBounds) {
        return precisePrimaryBounds.preciseHeight() - precisePartBounds.preciseHeight();
    }

    private static GraphicalEditPart getPrimarySelectionEditPart(List<EditPart> editParts) {
        for (EditPart editPart : editParts) {
            if (editPart.getSelected() != 2 || !(editPart instanceof GraphicalEditPart)) continue;
            GraphicalEditPart gEP = (GraphicalEditPart)editPart;
            return gEP;
        }
        return null;
    }

    protected double getPreciseWidthDelta(PrecisionRectangle precisePartBounds, PrecisionRectangle precisePrimaryBounds) {
        return precisePrimaryBounds.preciseWidth() - precisePartBounds.preciseWidth();
    }

    public void run() {
        this.execute(this.createMatchSizeCommand(this.getSelectedEditParts()));
    }
}

