/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.Disposable;
import org.eclipse.jface.action.IAction;

public class ActionRegistry {
    private final Map<String, IAction> map = new HashMap<String, IAction>(15);

    public void dispose() {
        this.map.values().stream().filter(Disposable.class::isInstance).map(Disposable.class::cast).forEach(Disposable::dispose);
    }

    public IAction getAction(Object key) {
        return this.map.get(key);
    }

    public Iterator<IAction> getActions() {
        return this.map.values().iterator();
    }

    public void registerAction(IAction action) {
        Assert.isNotNull((Object)action.getId(), (String)("action must have an ID in " + this.getClass().getName() + " :registerAction(IAction)"));
        this.registerAction(action.getId(), action);
    }

    private void registerAction(String id, IAction action) {
        this.map.put(id, action);
    }

    public void removeAction(IAction action) {
        this.map.remove(action.getId());
    }
}

